import static org.junit.Assert.*;
import org.junit.Before;
import org.junit.Test;


public class TestJUnitFStackInt {

  FStackInt f0;
  FStackInt f1;
  FStackInt f12;
  FStackInt f13;
  FStackInt f123;
  FStackInt f132;
  FStackInt f1234;

  FStackInt f129;
  FStackInt f193;
  FStackInt f923;


  @Before
  public void setup() {

    // Stacks to test
    f0 = FStackInt.empty();
    f1 = FStackInt.push(f0, 1);
    f12 = FStackInt.push(f1, 2);
    f123 = FStackInt.push(f12, 3);

    f129 = FStackInt.push(f12, 9);
    f193 = FStackInt.push(FStackInt.push(f1, 9), 3);
    f923 = FStackInt.push(
        FStackInt.push(FStackInt.push(f0, 9), 2), 3);
  }

  //@Test
  //public void test() {
  //  fail("Not yet implemented");
  //}

  @Test
  public void testCreation() {
    try {
      f0 = FStackInt.empty();
      f1 = FStackInt.push(f0, 1);
      f12 = FStackInt.push(f1, 2);
      f123 = FStackInt.push(f12, 3);

      f129 = FStackInt.push(f12, 9);
      f193 = FStackInt.push(FStackInt.push(f1, 9), 3);
      f923 = FStackInt.push(
          FStackInt.push(FStackInt.push(f0, 9), 2), 3);

    } catch (Exception e) {
      System.out.println("Exception thrown during creation tests:");
      System.out.println(e);
      assertTrue("creation", false);
    }
  }

  @Test
  public void testAccessors() {
    try {
      assertTrue("empty", FStackInt.isEmpty(f0));
      assertFalse("nonempty", FStackInt.isEmpty(f1));
      assertFalse("nonempty", FStackInt.isEmpty(f12));

      assertTrue("f0.size()", FStackInt.size(f0) == 0);
      assertTrue("f1.size()", FStackInt.size(f1) == 1);
      assertTrue("f12.size()", FStackInt.size(f12) == 2);
      assertTrue("f123.size()", FStackInt.size(f123) == 3);
      assertTrue("f129.size()", FStackInt.size(f129) == 3);
      assertTrue("f193.size()", FStackInt.size(f193) == 3);
      assertTrue("f923.size()", FStackInt.size(f923) == 3);
      assertFalse("f123.size()", FStackInt.size(f123) == 1);
      assertFalse("f129.size()", FStackInt.size(f129) == 2);
      assertFalse("f193.size()", FStackInt.size(f193) == 6);
      assertFalse("f923.size()", FStackInt.size(f923) == 7);

      assertTrue("f1.top()", (FStackInt.top(f1) == 1));
      assertTrue("f12.top()", (FStackInt.top(f12) == 2));
      assertTrue("f123.top()", (FStackInt.top(f123) == 3));
      assertTrue("f923.top()", (FStackInt.top(f923) == 3));
      assertTrue("f1.pop()", FStackInt.pop(f1).equals(f0));
      assertTrue("f12.pop()", FStackInt.pop(f12).equals(f1));
      assertTrue("f123.pop()", FStackInt.pop(f123).equals(f12));
      assertFalse("f923.pop()", FStackInt.pop(f923).equals(f12));

    } catch (Exception e) {
      System.out.println("Exception thrown during accessors tests:");
      System.out.println(e);
      assertTrue("accessors", false);
    }
  }

  @Test
  public void testUsual() {
    try {
      assertTrue("f0.hashCode()",f0.hashCode() == f0.hashCode());
      assertTrue("f1.hashCode()",f1.hashCode() == f1.hashCode());
      assertTrue("f123.hashCode()",f123.hashCode() == f123.hashCode());
      assertFalse("f0.f1.hashCode()",f0.hashCode() == f1.hashCode());   
      assertFalse("f1.hashCode()",f1.hashCode() == f12.hashCode());
      assertFalse("f123.hashCode()",f123.hashCode() == f129.hashCode());
      /*     
      assertTrue("f0.toString()",f0.toString().equals("[]"));
      assertTrue("f1.toString()",f1.toString().equals("[1]"));
      assertTrue("f12.toString()",f12.toString().equals("[2, 1]"));
      assertTrue("f123.toString()",f123.toString().equals("[3, 2, 1]"));
      assertFalse("f12.toString()",f12.toString().equals("[1, 2]"));
      assertFalse("f123.toString()",
                        f123.toString().equals(f129.toString()));
       */     
      assertTrue("f0.equals()",f0.equals(f0));
      assertTrue("f1.equals()",f1.equals(f1));
      assertTrue("f123.equals()",f123.equals(f123));
      assertFalse("f0.equals()",f0.equals(null));
      assertFalse("f123.equals()",f123.equals(f129));
      assertFalse("f129.equals()",f0.equals(12));
    } catch (Exception e) {
      System.out.println("Exception thrown during usual tests:");
      System.out.println(e);
      assertTrue("usual", false);
    }
  }


}
