


/**
 * to represent a stack of integers
 * @author vkp
 * @since 15 September 2013
 */
abstract class FStackInt {

  //----- BASIC CREATORS ---------------------
  
  /**
   * Produce an instance of this class
   */
  public static FStackInt empty() {
    return new Empty();
  }

  /**
   * Produce a new instance of this class
   * with the given n on the top
   * @param n the given n
   */
  public static FStackInt push(FStackInt s, int n) {
    return new Push(s, n);
  }

  // ------------ OTHER METHODS --------------------------
  
  /** is the given stack empty?
   * @param the given stack
   */
  public static boolean isEmpty(FStackInt s) {
    return s.isEmptyMethod();
  }

  abstract boolean isEmptyMethod();


  /** produce the item on the top of the given stack
   * @param the given stack
   * @return the top of the given stack
   */
  public static int top(FStackInt s) {
    return s.topMethod();
  }

  abstract int topMethod();


  /** produce the given stack with the top item removed
   * @param the given stack
   * @return the remainder of the given stack
   */
  public static FStackInt pop(FStackInt s) {
    return s.popMethod();
  }

  abstract FStackInt popMethod();


  /** produce the size of given stack 
   * @param the given stack
   * @return the size of the given stack
   */
  public static int size(FStackInt s) {
    return s.sizeMethod();
  }

  abstract int sizeMethod();
}

/**
 * to represent an empty stack of integers
 * @author vkp
 * @since 15 September 2013
 */
class Empty extends FStackInt {
  Empty() {}

  /**
   * Produce an instance of this class
   */
  public static FStackInt empty() {
    return new Empty();
  }


  public boolean isEmptyMethod() { return true; }

  int topMethod() { 
    throw new RuntimeException("Nothing is on top of empty stack"); 
    }

  FStackInt popMethod() { 
    throw new RuntimeException("Cannot pop of an empty stack"); }

  int sizeMethod() { return 0; }
}

/**
 * to represent a non-empty stack of integers
 * @author vkp
 * @since 15 September 2013
 */
class Push extends FStackInt {
  FStackInt s;
  int n;

  Push(FStackInt s, int n) {
    this.s = s;
    this.n = n;
  }

  boolean isEmptyMethod() { return false; }

  int topMethod() { return n; }

  FStackInt popMethod() { return s; }

  int sizeMethod() { return 1 + s.sizeMethod(); }
}
