import tester.*;

class ExamplesFStackInt {
  
  // Stacks to test
  FStackInt f0;
  FStackInt f1;
  FStackInt f12;
  FStackInt f13;
  FStackInt f123;
  FStackInt f132;
  FStackInt f1234;
  
  FStackInt f129;
  FStackInt f193;
  FStackInt f923;

  void init(){
    
  }

  void testCreation(Tester t) {
    try{
      f0 = FStackInt.empty();
      f1 = FStackInt.push(f0, 1);
      f12 = FStackInt.push(f1, 2);
      f123 = FStackInt.push(f12, 3);
            
      f129 = FStackInt.push(f12, 9);
      f193 = FStackInt.push(FStackInt.push(f1, 9), 3);
      f923 = FStackInt.push(
               FStackInt.push(FStackInt.push(f0, 9), 2), 3);        
    }
    catch(Exception e) {
      t.checkExpect(false, "Exception thrown during creation tests");
    }
  }
  
  void testAccessors(Tester t) {
    try {
      t.checkExpect(FStackInt.isEmpty(f0), "empty");
      t.checkFail(FStackInt.isEmpty(f1), "nonempty");
      t.checkFail(FStackInt.isEmpty(f12), "nonempty");
            
      t.checkExpect(FStackInt.size(f0) == 0, "f0.size()");
      t.checkExpect(FStackInt.size(f1) == 1, "f1.size()");
      t.checkExpect(FStackInt.size(f12) == 2, "f12.size()");
      t.checkExpect(FStackInt.size(f123) == 3, "f123.size()");
      t.checkExpect(FStackInt.size(f129) == 3, "f129.size()");
      t.checkExpect(FStackInt.size(f193) == 3, "f193.size()");
      t.checkExpect(FStackInt.size(f923) == 3, "f923.size()");
      t.checkFail(FStackInt.size(f123) == 1, "f123.size()");
      t.checkFail(FStackInt.size(f129) == 2, "f129.size()");
      t.checkFail(FStackInt.size(f193) == 6, "f193.size()");
      t.checkFail(FStackInt.size(f923) == 7, "f923.size()");
            
      t.checkExpect((FStackInt.top(f1) == 1), "f1.top()");
      t.checkExpect((FStackInt.top(f12) == 2), "f12.top()");
      t.checkExpect((FStackInt.top(f123) == 3), "f123.top()");
      t.checkExpect((FStackInt.top(f923) == 3), "f923.top()");
      t.checkExpect(FStackInt.pop(f1).equals(f0), "f1.pop()");
      t.checkExpect(FStackInt.pop(f12).equals(f1), "f12.pop()");
      t.checkExpect(FStackInt.pop(f123).equals(f12), "f123.pop()");
      t.checkFail(FStackInt.pop(f923).equals(f12), "f923.pop()");
            
    } catch (Exception e) {
      System.out.println("Exception thrown during accessors tests:");
      System.out.println(e);
      t.checkExpect(false, "accessors");
    }
  }
  
  
  void testUsual(Tester t) {
    try {
      t.checkExpect(f0.hashCode() == f0.hashCode(), "f0.hashCode()");
      t.checkExpect(f1.hashCode() == f1.hashCode(), "f1.hashCode()");
      t.checkExpect(f123.hashCode() == f123.hashCode(), "f123.hashCode()");
      t.checkFail(f0.hashCode() == f1.hashCode(), "f0.f1.hashCode()");   
      t.checkFail(f1.hashCode() == f12.hashCode(), "f1.hashCode()");
      t.checkFail(f123.hashCode() == f129.hashCode(), "f123.hashCode()");
       /*     
      t.checkExpect(f0.toString().equals("[]"), "f0.toString()");
      t.checkExpect(f1.toString().equals("[1]"), "f1.toString()");
      t.checkExpect(f12.toString().equals("[2, 1]"), "f12.toString()");
      t.checkExpect(f123.toString().equals("[3, 2, 1]"), "f123.toString()");
      t.checkFail(f12.toString().equals("[1, 2]"), "f12.toString()");
      t.checkFail(f123.toString().equals(f129.toString()), "f123.toString()");
       */     
      t.checkExpect(f0.equals(f0), "f0.equals()");
      t.checkExpect(f1.equals(f1), "f1.equals()");
      t.checkExpect(f123.equals(f123), "f123.equals()");
      t.checkFail(f0.equals(null), "f0.equals()");
      t.checkFail(f123.equals(f129), "f123.equals()");
      t.checkFail(f0.equals(12), "f129.equals()");
    } catch (Exception e) {
      System.out.println("Exception thrown during usual tests:");
      System.out.println(e);
      t.checkExpect(false, "usual");
    }
  }
}