import java.util.ArrayList; 

class ALTests { 
  // Students 
  Student skotthe = new Student("Theo", "A", 1234); 
  Student chadwick = new Student("Bryan", "B", 3456); 
  Student dimvar = new Student("Dimitris", "C", 7890); 
  Student chrdimo = new Student("Christos", "D", 1122); 
  Student mthomas = new Student("Mike", "A", 3344); 

  // ArrayLists 
  ArrayList<Student> al0; 
  ArrayList<Student> al1; 
  ArrayList<Student> al2;
  ArrayList<Student> al3;
  ArrayList<Student> al4;
  ArrayList<Student> al5;

  
  public void resetData(){ 
    al0 = new ArrayList<Student>(); 
    al1 = new ArrayList<Student>(); 
    al1.add(skotthe); 

    al2 = new ArrayList<Student>(); 
    al2.add(skotthe); 
    al2.add(chadwick); 

    al3 = new ArrayList<Student>(); 
    al3.add(skotthe); 
    al3.add(chadwick); 
    al3.add(dimvar); 

    al4 = new ArrayList<Student>(); 
    al4.add(skotthe); 
    al4.add(chadwick); 
    al4.add(dimvar); 
    al4.add(chrdimo); 

    al5 = new ArrayList<Student>(); 
    al5.add(skotthe); 
    al5.add(chadwick); 
    al5.add(dimvar); 
    al5.add(chrdimo); 
    al5.add(mthomas); 

  }

 public static void main(String[] args){ 
    ALTests alt = new ALTests(); 
    alt.resetData(); 
    alt.runswapTests();
    alt.runcuteswapTests();
  } 

 private <T> String updateToStringAcc(T ele, String acc){ 
	    return acc.concat("\n\t" + ele.toString()); 
	  }
 
    public <T> String toString(ArrayList<T> al){ 
    String acc = " "; // representation of ATL as a string up to now
    for(int index = 0; 0 <= index && index < al.size(); index++){ 
      acc = updateToStringAcc(al.get(index), acc); 
    }
    return acc; 
  } 


  public <T> void swap(int i, int j, ArrayList<T> al){ 
     
     T tmp=al.get(i);
     al.set(i, al.get(j));
     al.set(j, tmp);     

  }

  public <T> void cuteswap(int i, int j, ArrayList<T> al){ 
     
     al.set(i,al.set(j, al.get(i)));
  }  

  public void runswapTests(){
    resetData(); 


    System.out.println(" ==== Testing swap  ===="); 
   
    System.out.println("al1 = " + al1.toString()); 
    swap(0,0,al1);
    System.out.println("al1 swapped = " + al1.toString()); 
 
    System.out.println("al2 = " + al2.toString()); 
    swap(0,1,al2);
    System.out.println("al2 swapped = " + al2.toString()); 
 
    System.out.println("al3 = " + al3.toString()); 
    swap(1,2,al3);
    System.out.println("al3 swapped = " + al3.toString()); 
 
    System.out.println("al4 = " + al4.toString()); 
    swap(2,3,al4);
    System.out.println("al4 swapped = " + al4.toString()); 
 
    System.out.println("al5 = " + al5.toString()); 
    swap(3,4,al5);
    System.out.println("al5 swapped = " + al5.toString()); 
 
  }
  

public void runcuteswapTests(){
    resetData(); 


    System.out.println(" ==== Testing cute swap  ===="); 
        
    System.out.println("al1 = " + al1.toString()); 
    cuteswap(0,0,al1); 
    System.out.println("al1 swapped = " + al1.toString()); 
 
    System.out.println("al2 = " + al2.toString()); 
    cuteswap(0,1,al2);
    System.out.println("al2 swapped = " + al2.toString()); 
 
    System.out.println("al3 = " + al3.toString()); 
    cuteswap(1,2,al3);
    System.out.println("al3 swapped = " + al3.toString()); 
 
    System.out.println("al4 = " + al4.toString()); 
    cuteswap(2,3,al4);
    System.out.println("al4 swapped = " + al4.toString()); 
 
    System.out.println("al5 = " + al5.toString()); 
    cuteswap(3,4,al5);
    System.out.println("al5 swapped = " + al5.toString()); 
 
 
  }


} 
