/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.quick;

import edu.neu.ccs.quick.QuickTreeSet;
import edu.neu.ccs.quick.QuickVector;

public final class StringSet {
    private QuickTreeSet stringSet = new QuickTreeSet();
    private QuickVector stringList = new QuickVector();

    public StringSet() {
    }

    public StringSet(String[] stringArray) {
        this.addStrings(stringArray);
    }

    public void addString(String string) {
        if (string == null) {
            return;
        }
        if (this.contains(string)) {
            return;
        }
        this.stringSet.add(string);
        this.stringList.add(string);
    }

    public void addStrings(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addString(stringArray[n2]);
            ++n2;
        }
    }

    public void setStrings(String[] stringArray) {
        this.clear();
        this.addStrings(stringArray);
    }

    public String remove(int n) {
        if (n < 0 || n >= this.size()) {
            return null;
        }
        String string = this.getString(n);
        this.stringSet.remove(string);
        this.stringList.remove(n);
        return string;
    }

    public String remove(String string) {
        if (!this.contains(string)) {
            return null;
        }
        this.stringSet.remove(string);
        this.stringList.remove(string);
        return string;
    }

    public void clear() {
        this.stringSet.clear();
        this.stringList.clear();
    }

    public int size() {
        return this.stringList.size();
    }

    public String getString(int n) {
        if (n < 0 || n >= this.size()) {
            return null;
        }
        return (String)this.stringList.get(n);
    }

    public String[] getStrings() {
        return this.stringList.toArray(new String[0]);
    }

    public String[] getSortedStrings() {
        return this.stringSet.toArray(new String[0]);
    }

    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        return this.stringSet.contains(string);
    }
}

