/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.jpf;

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.gui.ActionsPanel;
import edu.neu.ccs.gui.BufferedPanel;
import edu.neu.ccs.gui.CenterLayout;
import edu.neu.ccs.gui.Display;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.JPTScrollPane;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.TableLayout;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.ThreadedAction;
import edu.neu.ccs.jpf.JPF;
import edu.neu.ccs.jpf.MethodGUI;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JRootPane;

class JPFApplication
extends DisplayPanel
implements JPTConstants,
ConsoleAware {
    public static final int BUFFER_WIDTH = 400;
    public static final int BUFFER_HEIGHT = 400;
    private static final Color commonButtonColor = new Color(255, 255, 100);
    private static final Color exitButtonColor = Color.red;
    private static final Color methodButtonColor = new Color(127, 255, 127);
    private static final Color methodButtonColorDisabled = new Color(231, 231, 231);
    protected BufferedPanel window = new BufferedPanel(400, 400);
    protected JPF initializer = null;
    protected Class initializerClass = null;
    protected JPTFrame frame = null;
    protected String frameTitle = null;
    protected boolean showGraphicsWindow = true;
    protected ActionsPanel methodButtonsPanel = null;
    protected ActionsPanel commonButtonsPanel = null;
    protected TablePanel buttonsPanel = null;
    protected DisplayPanel RHS = null;
    protected DisplayPanel LHS = null;
    JButton[] methodButtons = null;
    JButton[] commonButtons = null;
    protected TablePanel mainPanel = null;
    protected Action clearGraphics = new 1("Clear Graphics");
    protected Action toggleGraphics = new 2("Toggle Graphics");
    protected Action toggleConsole = new 3("Toggle Console");
    protected Action exitFramework = new 4("Exit");
    static /* synthetic */ Class class$edu$neu$ccs$jpf$JPF;
    static /* synthetic */ Class class$edu$neu$ccs$Stringable;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$awt$geom$Point2D$Double;
    static /* synthetic */ Class class$java$awt$Paint;

    public JPFApplication(JPF jPF, String string) {
        if (jPF == null) {
            return;
        }
        this.initializer = jPF;
        this.initializerClass = jPF.getClass();
        this.setFrameTitle(string);
        this.buildGUI();
        this.frame = JPTFrame.createQuickJPTFrame(this.getFrameTitle(), (Object)this, (LayoutManager)new CenterLayout(), 3);
    }

    public BufferedPanel getGraphicsWindow() {
        return this.window;
    }

    public String getFrameTitle() {
        return this.frameTitle;
    }

    public void setFrameTitle(String string) {
        String string2 = this.frameTitle = string != null && !string.equals("") ? string : JPFApplication.className(this.initializerClass);
        if (this.frame != null) {
            this.frame.setTitle(this.frameTitle);
        }
    }

    protected void buildButtons() {
        this.commonButtonsPanel = new ActionsPanel(new TableLayout(4, 1, 0, 0, 0, 1));
        JButton jButton = this.addOneButton(this.commonButtonsPanel, this.clearGraphics, "Clear the Graphics Window");
        jButton.setBackground(commonButtonColor);
        jButton = this.addOneButton(this.commonButtonsPanel, this.toggleGraphics, "Show or Hide the Graphics Window");
        jButton.setBackground(commonButtonColor);
        jButton = this.addOneButton(this.commonButtonsPanel, this.toggleConsole, "Show or Iconify the Console Window");
        jButton.setBackground(commonButtonColor);
        jButton = this.addOneButton(this.commonButtonsPanel, this.exitFramework, "Exit the Framework");
        jButton.setBackground(exitButtonColor);
        this.commonButtonsPanel.uniformizeSize();
        this.commonButtons = this.commonButtonsPanel.getActionButtons();
        this.methodButtonsPanel = new ActionsPanel(new TableLayout(1, 1, 0, 0, 0, 1));
        Method[] methodArray = this.getMethodList();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (methodArray[n2] != null) {
                jButton = this.addOneButton(this.methodButtonsPanel, this.makeActionFromMethod(methodArray[n2]), this.getMethodToolTip(methodArray[n2]));
                jButton.setBackground(methodButtonColor);
            }
            ++n2;
        }
        this.methodButtonsPanel.uniformizeSize();
        this.methodButtons = this.methodButtonsPanel.getActionButtons();
        JPTScrollPane jPTScrollPane = new JPTScrollPane(this.methodButtonsPanel);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = (int)dimension.getWidth();
        int n4 = (int)dimension.getHeight();
        int n5 = 50;
        int n6 = 250;
        JButton jButton2 = new JButton("MyTest");
        Dimension dimension2 = jButton2.getPreferredSize();
        Dimension dimension3 = this.RHS.getPreferredSize();
        Dimension dimension4 = this.commonButtonsPanel.getPreferredSize();
        int n7 = n3 - n5 - dimension3.width;
        int n8 = n4 - n6 - dimension4.height;
        n8 -= n8 % dimension2.height;
        jPTScrollPane.boundViewportPreferredSize(n7, n8);
        this.buttonsPanel = new TablePanel(new Object[]{jPTScrollPane, this.commonButtonsPanel}, 1, 5, 5, 0);
    }

    public void normalConsole() {
        ConsoleAware.console.normal();
    }

    public void iconifyConsole() {
        ConsoleAware.console.iconify();
    }

    public void toggleConsole() {
        ConsoleAware.console.toggle();
    }

    protected void clearGraphics() {
        this.window.clearPanelAndSequence();
        this.window.repaint();
    }

    protected boolean isGraphicsVisible() {
        return this.showGraphicsWindow;
    }

    protected void setGraphicsVisible(boolean bl) {
        if (this.showGraphicsWindow == bl) {
            return;
        }
        this.toggleGraphics();
    }

    protected void toggleGraphics() {
        if (this.showGraphicsWindow) {
            this.mainPanel.remove(this.RHS);
        } else {
            this.mainPanel.add(this.RHS);
        }
        this.showGraphicsWindow ^= true;
        this.frame.pack();
        this.frame.setLocation(3);
    }

    protected void exitFramework() {
        ConsoleAware.console.setActivated(false);
        System.exit(0);
    }

    protected JButton addOneButton(ActionsPanel actionsPanel, Action action, String string) {
        JButton jButton = actionsPanel.addAction(action);
        jButton.setToolTipText(string);
        return jButton;
    }

    protected String getMethodToolTip(Method method) {
        if (method == null) {
            return "";
        }
        return String.valueOf(this.isStatic(method) ? "static " : "") + JPFApplication.className(method.getReturnType()) + " " + method.getName() + "(" + this.getParameterNames(method) + ")" + " in " + JPFApplication.className(method.getDeclaringClass());
    }

    protected String getParameterNames(Method method) {
        String string = "";
        if (method == null) {
            return string;
        }
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        if (n == 0) {
            return string;
        }
        string = JPFApplication.className(classArray[0]);
        int n2 = 1;
        while (n2 < n) {
            string = String.valueOf(string) + ", " + JPFApplication.className(classArray[n2]);
            ++n2;
        }
        return string;
    }

    protected void buildGUI() {
        this.showConsole();
        this.RHS = new Display((Displayable)this.window, null, "Graphics");
        this.buildButtons();
        this.LHS = new Display((Displayable)this.buttonsPanel, null, "Tasks");
        this.mainPanel = new TablePanel(new Object[]{this.LHS, this.RHS}, 0, 5, 5, 1);
        this.add(this.mainPanel);
    }

    protected void showConsole() {
        ConsoleAware.console.setActivated(true);
        ConsoleAware.console.selectColorTextScheme();
    }

    protected void setMethodButtonsEnabled(boolean bl) {
        Color color = bl ? methodButtonColor : methodButtonColorDisabled;
        int n = this.methodButtons.length;
        int n2 = 0;
        while (n2 < n) {
            this.methodButtons[n2].setEnabled(bl);
            this.methodButtons[n2].setBackground(color);
            ++n2;
        }
    }

    protected Method[] getMethodList() {
        Method[] methodArray = this.getExtraMethods(this.initializerClass, class$edu$neu$ccs$jpf$JPF != null ? class$edu$neu$ccs$jpf$JPF : (class$edu$neu$ccs$jpf$JPF = JPFApplication.class$("edu.neu.ccs.jpf.JPF")));
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!this.isSimpleMethod(methodArray[n2]) && !this.isGUIMethod(methodArray[n2])) {
                methodArray[n2] = null;
            }
            ++n2;
        }
        this.removeDuplicateVirtualMethods(methodArray);
        return methodArray;
    }

    protected void removeDuplicateVirtualMethods(Method[] methodArray) {
        if (methodArray == null) {
            return;
        }
        int n = methodArray.length;
        int n2 = n - 1;
        while (n2 > 0) {
            if (methodArray[n2] != null && !this.isStatic(methodArray[n2])) {
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    if (methodArray[n3] != null && !this.isStatic(methodArray[n3]) && this.isDuplicate(methodArray[n2], methodArray[n3])) {
                        methodArray[n3] = null;
                    }
                    --n3;
                }
            }
            --n2;
        }
    }

    protected boolean isDuplicate(Method method, Method method2) {
        if (method == null || method2 == null) {
            return false;
        }
        return method.getName().equals(method2.getName()) && method.getModifiers() == method2.getModifiers() && method2.getReturnType() == method2.getReturnType() && this.isDuplicateParameterList(method, method2);
    }

    protected boolean isDuplicateParameterList(Method method, Method method2) {
        Class<?>[] classArray;
        int n;
        if (method == null || method2 == null) {
            return false;
        }
        Class<?>[] classArray2 = method.getParameterTypes();
        int n2 = classArray2.length;
        if (n2 != (n = (classArray = method2.getParameterTypes()).length)) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (classArray2[n3] != classArray[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected Action makeActionFromMethod(Method method) {
        if (method == null) {
            return null;
        }
        String string = this.isStatic(method) ? String.valueOf(JPFApplication.className(method.getDeclaringClass())) + "." + method.getName() : method.getName();
        return new ThreadedAction(new 5(method, this, string));
    }

    protected synchronized void performAction(Method method) {
        this.setMethodButtonsEnabled(false);
        String string = method.getName();
        try {
            try {
                if (this.isGUIMethod(method)) {
                    this.performActionUsingGUI(method);
                } else if (this.isStatic(method)) {
                    method.invoke(null, null);
                } else {
                    method.invoke((Object)this.initializer, null);
                }
            }
            catch (Exception exception) {
                this.handleMethodException(exception, string);
            }
            Object var4_4 = null;
            this.setMethodButtonsEnabled(true);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setMethodButtonsEnabled(true);
            throw throwable;
        }
    }

    protected void handleMethodException(Throwable throwable, String string) {
        if (throwable instanceof IllegalAccessException) {
            IllegalAccessException illegalAccessException = (IllegalAccessException)throwable;
            ConsoleAware.console.err.print("JPF Error: IllegalAccessException: ");
            ConsoleAware.console.err.println(String.valueOf(String.valueOf(illegalAccessException)) + "\n");
        } else if (throwable instanceof IllegalArgumentException) {
            IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
            ConsoleAware.console.err.print("JPF Error: IllegalArgumentException: ");
            ConsoleAware.console.err.println(String.valueOf(String.valueOf(illegalArgumentException)) + "\n");
        } else if (throwable instanceof InvocationTargetException) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
            throwable = invocationTargetException.getTargetException();
        }
        this.printExceptionTrace(throwable, string);
    }

    protected void printExceptionTrace(Throwable throwable, String string) {
        ConsoleAware.console.err.println("Exception: " + throwable + "\nIn: " + string + "\n");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        String string2 = stringWriter.toString();
        int n = string2.indexOf(".reflect.");
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.lastIndexOf("\n")) >= 0) {
            string2 = string2.substring(0, n);
        }
        if (string2.length() > 0) {
            ConsoleAware.console.err.println(String.valueOf(string2) + "\n");
        }
    }

    public synchronized void performActionUsingGUI(Method method) {
        String string = String.valueOf(method.getName()) + " evaluator";
        MethodGUI methodGUI = new MethodGUI(this, method);
        JPTFrame jPTFrame = JPTFrame.createQuickJPTFrame(string, (Object)methodGUI, (LayoutManager)new CenterLayout(), 0);
        JRootPane jRootPane = methodGUI.getRootPane();
        if (jRootPane != null) {
            jRootPane.setDefaultButton(methodGUI.evaluateButton);
        }
    }

    protected boolean isSimpleMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getName().equals("main")) {
            return false;
        }
        if (method.getReturnType() != Void.TYPE) {
            return false;
        }
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        int n = method.getModifiers();
        return (n & 1) != 0;
    }

    protected boolean isGUIMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getName().equals("main")) {
            return false;
        }
        if (!this.isAcceptableMethodForGUI(method)) {
            return false;
        }
        int n = method.getModifiers();
        return (n & 1) != 0;
    }

    protected boolean isAcceptableTypeForParameter(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return true;
        }
        if ((class$edu$neu$ccs$Stringable != null ? class$edu$neu$ccs$Stringable : (class$edu$neu$ccs$Stringable = JPFApplication.class$("edu.neu.ccs.Stringable"))).isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz.equals(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = JPFApplication.class$("java.lang.String")))) {
            return true;
        }
        if (clazz.equals(class$java$awt$Color != null ? class$java$awt$Color : (class$java$awt$Color = JPFApplication.class$("java.awt.Color")))) {
            return true;
        }
        if (clazz.equals(class$java$math$BigInteger != null ? class$java$math$BigInteger : (class$java$math$BigInteger = JPFApplication.class$("java.math.BigInteger")))) {
            return true;
        }
        if (clazz.equals(class$java$math$BigDecimal != null ? class$java$math$BigDecimal : (class$java$math$BigDecimal = JPFApplication.class$("java.math.BigDecimal")))) {
            return true;
        }
        return clazz.equals(class$java$awt$geom$Point2D$Double != null ? class$java$awt$geom$Point2D$Double : (class$java$awt$geom$Point2D$Double = JPFApplication.class$("java.awt.geom.Point2D$Double")));
    }

    protected boolean isAcceptableTypeForReturn(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (this.isAcceptableTypeForParameter(clazz)) {
            return true;
        }
        return (class$java$awt$Paint != null ? class$java$awt$Paint : (class$java$awt$Paint = JPFApplication.class$("java.awt.Paint"))).isAssignableFrom(clazz);
    }

    protected boolean isAcceptableMethodForGUI(Method method) {
        if (method == null) {
            return false;
        }
        Class<?> clazz = method.getReturnType();
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        if (clazz.equals(Void.TYPE) && n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!this.isAcceptableTypeForParameter(classArray[n2])) {
                return false;
            }
            ++n2;
        }
        return clazz.equals(Void.TYPE) || this.isAcceptableTypeForReturn(clazz);
    }

    protected Method[] getExtraMethods(Class clazz, Class clazz2) {
        if (clazz == null || clazz.equals(clazz2) || clazz.isPrimitive() || clazz.isInterface() || clazz.isArray()) {
            return new Method[0];
        }
        return this.joinMethodArrays(this.getExtraMethods(clazz.getSuperclass(), clazz2), clazz.getDeclaredMethods());
    }

    protected Method[] joinMethodArrays(Method[] methodArray, Method[] methodArray2) {
        int n = methodArray.length;
        int n2 = methodArray2.length;
        int n3 = n + n2;
        Method[] methodArray3 = new Method[n3];
        int n4 = 0;
        while (n4 < n) {
            methodArray3[n4] = methodArray[n4];
            ++n4;
        }
        int n5 = n;
        while (n5 < n3) {
            methodArray3[n5] = methodArray2[n5 - n];
            ++n5;
        }
        return methodArray3;
    }

    protected boolean isStatic(Method method) {
        if (method == null) {
            return false;
        }
        int n = method.getModifiers();
        return (n & 8) != 0;
    }

    protected static String className(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class 1
    extends SimpleAction {
        public void perform() {
            JPFApplication.this.clearGraphics();
        }

        /* synthetic */ 1(String string) {
            super(string);
        }
    }

    private final class 2
    extends SimpleAction {
        public void perform() {
            JPFApplication.this.toggleGraphics();
        }

        /* synthetic */ 2(String string) {
            super(string);
        }
    }

    private final class 3
    extends SimpleAction {
        public void perform() {
            JPFApplication.this.toggleConsole();
        }

        /* synthetic */ 3(String string) {
            super(string);
        }
    }

    private final class 4
    extends SimpleAction {
        public void perform() {
            JPFApplication.this.exitFramework();
        }

        /* synthetic */ 4(String string) {
            super(string);
        }
    }

    private static final class 5
    extends SimpleAction {
        private final /* synthetic */ JPFApplication this$0;
        private final /* synthetic */ Method val$method;

        public void perform() {
            this.this$0.performAction(this.val$method);
        }

        /* synthetic */ 5(Method method, JPFApplication jPFApplication, String string) {
            super(string);
            this.val$method = method;
            this.this$0 = jPFApplication;
        }
    }
}

