/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.jpf;

import edu.neu.ccs.util.MathUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

class ActivityIcon {
    protected static Color inputColor = Color.green;
    protected static Color actionColor = Color.yellow;
    protected static Color outputColor = Color.red;
    protected static Color boxColor = Color.black;
    private static int boxsize = 24;
    private static int halfsize = boxsize / 2;
    private static int linewidth = 4;
    private static int halfwidth = linewidth / 2;
    private static int arrowsize = 4;
    private static int width = 2 * (arrowsize + boxsize);
    private static int height = boxsize;
    private static int boxXCorner = arrowsize + halfsize;
    private static int boxYCorner = 0;
    private static int boxXCenter = arrowsize + boxsize;
    private static int boxYCenter = halfsize;
    private static Rectangle2D.Double box = new Rectangle2D.Double(boxXCorner, boxYCorner, boxsize, boxsize);
    private static int xInput = arrowsize + halfwidth;
    private static int xOutput = width - xInput;
    private static int yCommon = halfwidth;
    private static int arcInset = 2;
    private static int arcXCorner = boxXCorner + arcInset + halfwidth;
    private static int arcYCorner = boxYCorner + arcInset + halfwidth;
    private static int arcDiameter = boxsize - linewidth - 2 * arcInset;
    private static int arcStartAngle = 135;
    private static int arcTotalAngle = 315;
    private static int arcRadius = arcDiameter / 2;
    private static int side = (int)Math.round((double)arcRadius * MathUtilities.sindeg(45.0));
    private static int arcXStart = boxXCenter - side;
    private static int arcYStart = boxYCenter - side;

    ActivityIcon() {
    }

    public static class InputIcon
    extends JComponent {
        public InputIcon() {
            this.setPreferredSize(new Dimension(width, height));
        }

        protected void paintComponent(Graphics graphics) {
            Line2D.Double double_ = new Line2D.Double();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(linewidth, 1, 1));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (boxColor == null) {
                boxColor = Color.black;
            }
            graphics2D.setPaint(boxColor);
            graphics2D.fill(box);
            if (inputColor == null) {
                inputColor = Color.red;
            }
            graphics2D.setPaint(inputColor);
            double_.setLine(xInput, yCommon, xInput, boxYCenter);
            graphics2D.draw(double_);
            double_.setLine(xInput, boxYCenter, boxXCenter, boxYCenter);
            graphics2D.draw(double_);
            double_.setLine(boxXCenter, boxYCenter, boxXCenter - arrowsize, boxYCenter - arrowsize);
            graphics2D.draw(double_);
            double_.setLine(boxXCenter, boxYCenter, boxXCenter - arrowsize, boxYCenter + arrowsize);
            graphics2D.draw(double_);
        }
    }

    public static class ActionIcon
    extends JComponent {
        public ActionIcon() {
            this.setPreferredSize(new Dimension(width, height));
        }

        protected void paintComponent(Graphics graphics) {
            Arc2D.Double double_ = new Arc2D.Double();
            Line2D.Double double_2 = new Line2D.Double();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(linewidth, 1, 1));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (boxColor == null) {
                boxColor = Color.black;
            }
            graphics2D.setPaint(boxColor);
            graphics2D.fill(box);
            if (actionColor == null) {
                actionColor = Color.yellow;
            }
            graphics2D.setPaint(actionColor);
            double_.setArc(arcXCorner, arcYCorner, arcDiameter, arcDiameter, arcStartAngle, arcTotalAngle, 0);
            graphics2D.draw(double_);
            double_2.setLine(arcXStart, arcYStart, arcXStart - arrowsize, arcYStart);
            graphics2D.draw(double_2);
            double_2.setLine(arcXStart, arcYStart, arcXStart + 1, arcYStart + arrowsize);
            graphics2D.draw(double_2);
        }
    }

    public static class OutputIcon
    extends JComponent {
        public OutputIcon() {
            this.setPreferredSize(new Dimension(width, height));
        }

        protected void paintComponent(Graphics graphics) {
            Line2D.Double double_ = new Line2D.Double();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(linewidth, 1, 1));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (boxColor == null) {
                boxColor = Color.black;
            }
            graphics2D.setPaint(boxColor);
            graphics2D.fill(box);
            if (outputColor == null) {
                outputColor = Color.red;
            }
            graphics2D.setPaint(outputColor);
            double_.setLine(boxXCenter, boxYCenter, xOutput, boxYCenter);
            graphics2D.draw(double_);
            double_.setLine(xOutput, boxYCenter, xOutput, yCommon);
            graphics2D.draw(double_);
            double_.setLine(xOutput, yCommon, xOutput - arrowsize, yCommon + arrowsize);
            graphics2D.draw(double_);
            double_.setLine(xOutput, yCommon, xOutput + arrowsize, yCommon + arrowsize);
            graphics2D.draw(double_);
        }
    }
}

