/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.JPTScrollPane;
import edu.neu.ccs.gui.PaintSwatch;
import edu.neu.ccs.gui.TableGenerator;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.util.JPTConstants;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class VisualColorList
extends DisplayPanel
implements JPTConstants {
    private static final int MIN_SWATCH_SIZE = 20;
    private static final int DEFAULT_SWATCH_SIZE = 20;
    private static final int MAX_SWATCH_SIZE = 50;
    private static final int BORDER_SIZE = 2;
    private static final Border BORDER = PaintSwatch.BLACK_BORDER;
    private static final int HGAP = 6;
    private static final int VGAP = 6;
    private static final int MAX_WIDTH = 720;
    private static final int MIN_HEIGHT = 120;
    private static final int MAX_HEIGHT = 600;
    private int swatchSize = 20;

    private PaintSwatch makeSwatch(String string) {
        return new PaintSwatch(Colors.getColorFromName(string), this.swatchSize, this.swatchSize, BORDER);
    }

    public VisualColorList() {
        this(20, 600);
    }

    public VisualColorList(int n) {
        this(n, 600);
    }

    public VisualColorList(int n, int n2) {
        n = n >= 20 ? n : 20;
        this.swatchSize = n = n <= 50 ? n : 50;
        n2 = n2 >= 120 ? n2 : 120;
        n2 = n2 <= 600 ? n2 : 600;
        int n3 = n + 4 + 6;
        n2 = n3 * (n2 / n3);
        if (n2 < 120) {
            n2 += n3;
        }
        String[] stringArray = Colors.getColorNamesAsArray();
        int n4 = stringArray.length;
        1 var6_6 = new 1(n4, stringArray, this);
        TablePanel tablePanel = new TablePanel(var6_6, n4, 2, 6, 6, 7);
        JPTScrollPane jPTScrollPane = new JPTScrollPane(tablePanel);
        jPTScrollPane.boundViewportPreferredSize(720, n2);
        this.add(jPTScrollPane);
    }

    public static void showVisualColorList() {
        JPTFrame.createQuickJPTFrame("Visual Color List", new VisualColorList());
    }

    private static final class 1
    implements TableGenerator {
        private final /* synthetic */ VisualColorList this$0;
        private final /* synthetic */ String[] val$nameArray;
        private final /* synthetic */ int val$length;

        public Object makeContents(int n, int n2) {
            if (n < 0 || n >= this.val$length) {
                return null;
            }
            if (n2 < 0 || n2 >= 2) {
                return null;
            }
            if (n2 == 0) {
                return this.this$0.makeSwatch(this.val$nameArray[n]);
            }
            return new JLabel(this.val$nameArray[n]);
        }

        /* synthetic */ 1(int n, String[] stringArray, VisualColorList visualColorList) {
            this.val$length = n;
            this.val$nameArray = stringArray;
            this.this$0 = visualColorList;
        }
    }
}

