/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XPoint2D;
import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.TextPaintable;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;

public class TextAnchor {
    static final FontRenderContext standardFRC = TextPaintable.standardFRC;
    public static final XLocator LEFT = new 1();
    public static final XLocator RIGHT = new 2();
    public static final XLocator CENTER = new 3();
    public static final YLocator BASELINE = new 4();
    public static final YLocator ASCENTLINE = new 5();
    public static final YLocator DESCENTLINE = new 6();
    public static final YLocator LEADINGLINE = new 7();
    public static final Locator LEFT_BASELINE = TextAnchor.makeLocator(LEFT, BASELINE);
    public static final Locator RIGHT_BASELINE = TextAnchor.makeLocator(RIGHT, BASELINE);
    public static final Locator CENTER_BASELINE = TextAnchor.makeLocator(CENTER, BASELINE);
    public static final Locator LEFT_ASCENTLINE = TextAnchor.makeLocator(LEFT, ASCENTLINE);
    public static final Locator RIGHT_ASCENTLINE = TextAnchor.makeLocator(RIGHT, ASCENTLINE);
    public static final Locator CENTER_ASCENTLINE = TextAnchor.makeLocator(CENTER, ASCENTLINE);
    public static final Locator LEFT_DESCENTLINE = TextAnchor.makeLocator(LEFT, DESCENTLINE);
    public static final Locator RIGHT_DESCENTLINE = TextAnchor.makeLocator(RIGHT, DESCENTLINE);
    public static final Locator CENTER_DESCENTLINE = TextAnchor.makeLocator(CENTER, DESCENTLINE);
    public static final Locator LEFT_LEADINGLINE = TextAnchor.makeLocator(LEFT, LEADINGLINE);
    public static final Locator RIGHT_LEADINGLINE = TextAnchor.makeLocator(RIGHT, LEADINGLINE);
    public static final Locator CENTER_LEADINGLINE = TextAnchor.makeLocator(CENTER, LEADINGLINE);

    private TextAnchor() {
    }

    public static Locator makeLocator(XLocator xLocator, YLocator yLocator) {
        return new 8(xLocator, yLocator);
    }

    public static interface XLocator {
        public float getLeftX(String var1, Font var2, float var3);

        public float getRightX(String var1, Font var2, float var3);

        public float getCenterX(String var1, Font var2, float var3);
    }

    public static interface YLocator {
        public float getBaseLineY(String var1, Font var2, float var3);

        public float getAscentLineY(String var1, Font var2, float var3);

        public float getDescentLineY(String var1, Font var2, float var3);

        public float getLeadingLineY(String var1, Font var2, float var3);
    }

    public static interface Locator {
        public float getLeftX(String var1, Font var2, float var3);

        public float getRightX(String var1, Font var2, float var3);

        public float getCenterX(String var1, Font var2, float var3);

        public float getBaseLineY(String var1, Font var2, float var3);

        public float getAscentLineY(String var1, Font var2, float var3);

        public float getDescentLineY(String var1, Font var2, float var3);

        public float getLeadingLineY(String var1, Font var2, float var3);

        public float getWidth(String var1, Font var2, float var3);

        public float getHeight(String var1, Font var2, float var3);

        public XRect getBounds2D(String var1, Font var2, float var3, float var4);

        public XPoint2D getCenter(String var1, Font var2, float var3, float var4);
    }

    private final class 1
    implements XLocator {
        public float getLeftX(String string, Font font, float f) {
            return f;
        }

        public float getRightX(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            Rectangle2D rectangle2D = font.getStringBounds(string, standardFRC);
            return f + (float)rectangle2D.getWidth();
        }

        public float getCenterX(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            Rectangle2D rectangle2D = font.getStringBounds(string, standardFRC);
            return f + (float)(rectangle2D.getWidth() / 2.0);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements XLocator {
        public float getLeftX(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            Rectangle2D rectangle2D = font.getStringBounds(string, standardFRC);
            return f - (float)rectangle2D.getWidth();
        }

        public float getRightX(String string, Font font, float f) {
            return f;
        }

        public float getCenterX(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            Rectangle2D rectangle2D = font.getStringBounds(string, standardFRC);
            return f - (float)(rectangle2D.getWidth() / 2.0);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements XLocator {
        public float getLeftX(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            Rectangle2D rectangle2D = font.getStringBounds(string, standardFRC);
            return f - (float)(rectangle2D.getWidth() / 2.0);
        }

        public float getRightX(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            Rectangle2D rectangle2D = font.getStringBounds(string, standardFRC);
            return f + (float)(rectangle2D.getWidth() / 2.0);
        }

        public float getCenterX(String string, Font font, float f) {
            return f;
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements YLocator {
        public float getBaseLineY(String string, Font font, float f) {
            return f;
        }

        public float getAscentLineY(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            LineMetrics lineMetrics = font.getLineMetrics(string, standardFRC);
            return f - lineMetrics.getAscent();
        }

        public float getDescentLineY(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            LineMetrics lineMetrics = font.getLineMetrics(string, standardFRC);
            return f + lineMetrics.getDescent();
        }

        public float getLeadingLineY(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            LineMetrics lineMetrics = font.getLineMetrics(string, standardFRC);
            return f + lineMetrics.getDescent() + lineMetrics.getLeading();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements YLocator {
        public float getBaseLineY(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            LineMetrics lineMetrics = font.getLineMetrics(string, standardFRC);
            return f + lineMetrics.getAscent();
        }

        public float getAscentLineY(String string, Font font, float f) {
            return f;
        }

        public float getDescentLineY(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            LineMetrics lineMetrics = font.getLineMetrics(string, standardFRC);
            return f + lineMetrics.getAscent() + lineMetrics.getDescent();
        }

        public float getLeadingLineY(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            LineMetrics lineMetrics = font.getLineMetrics(string, standardFRC);
            return f + lineMetrics.getAscent() + lineMetrics.getDescent() + lineMetrics.getLeading();
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements YLocator {
        public float getBaseLineY(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            LineMetrics lineMetrics = font.getLineMetrics(string, standardFRC);
            return f - lineMetrics.getDescent();
        }

        public float getAscentLineY(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            LineMetrics lineMetrics = font.getLineMetrics(string, standardFRC);
            return f - lineMetrics.getDescent() - lineMetrics.getAscent();
        }

        public float getDescentLineY(String string, Font font, float f) {
            return f;
        }

        public float getLeadingLineY(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            LineMetrics lineMetrics = font.getLineMetrics(string, standardFRC);
            return f + lineMetrics.getLeading();
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements YLocator {
        public float getBaseLineY(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            LineMetrics lineMetrics = font.getLineMetrics(string, standardFRC);
            return f - lineMetrics.getLeading() - lineMetrics.getDescent();
        }

        public float getAscentLineY(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            LineMetrics lineMetrics = font.getLineMetrics(string, standardFRC);
            return f - lineMetrics.getLeading() - lineMetrics.getDescent() - lineMetrics.getAscent();
        }

        public float getDescentLineY(String string, Font font, float f) {
            if (string == null || font == null) {
                return f;
            }
            LineMetrics lineMetrics = font.getLineMetrics(string, standardFRC);
            return f - lineMetrics.getLeading();
        }

        public float getLeadingLineY(String string, Font font, float f) {
            return f;
        }

        /* synthetic */ 7() {
        }
    }

    private static final class 8
    implements Locator {
        private final /* synthetic */ YLocator val$ylocator;
        private final /* synthetic */ XLocator val$xlocator;

        public float getLeftX(String string, Font font, float f) {
            return this.val$xlocator.getLeftX(string, font, f);
        }

        public float getRightX(String string, Font font, float f) {
            return this.val$xlocator.getRightX(string, font, f);
        }

        public float getCenterX(String string, Font font, float f) {
            return this.val$xlocator.getCenterX(string, font, f);
        }

        public float getBaseLineY(String string, Font font, float f) {
            return this.val$ylocator.getBaseLineY(string, font, f);
        }

        public float getAscentLineY(String string, Font font, float f) {
            return this.val$ylocator.getAscentLineY(string, font, f);
        }

        public float getDescentLineY(String string, Font font, float f) {
            return this.val$ylocator.getDescentLineY(string, font, f);
        }

        public float getLeadingLineY(String string, Font font, float f) {
            return this.val$ylocator.getLeadingLineY(string, font, f);
        }

        public float getWidth(String string, Font font, float f) {
            return this.getRightX(string, font, f) - this.getLeftX(string, font, f);
        }

        public float getHeight(String string, Font font, float f) {
            return this.getLeadingLineY(string, font, f) - this.getAscentLineY(string, font, f);
        }

        public XRect getBounds2D(String string, Font font, float f, float f2) {
            double d = this.getLeftX(string, font, f);
            double d2 = this.getAscentLineY(string, font, f2);
            double d3 = (double)this.getRightX(string, font, f) - d;
            double d4 = (double)this.getLeadingLineY(string, font, f2) - d2;
            return new XRect(d, d2, d3, d4);
        }

        public XPoint2D getCenter(String string, Font font, float f, float f2) {
            double d = this.getCenterX(string, font, f);
            double d2 = this.getBaseLineY(string, font, f2);
            return new XPoint2D(d, d2);
        }

        /* synthetic */ 8(XLocator xLocator, YLocator yLocator) {
            this.val$xlocator = xLocator;
            this.val$ylocator = yLocator;
        }
    }
}

