/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.PaintMode;
import edu.neu.ccs.gui.PaintableSequence;
import edu.neu.ccs.gui.PathListIterator;
import edu.neu.ccs.gui.PathNode;
import edu.neu.ccs.gui.PlotMark;
import edu.neu.ccs.gui.PlotMarkAlgorithm;
import edu.neu.ccs.gui.PointPaintable;
import edu.neu.ccs.gui.ShapePaintable;
import edu.neu.ccs.gui.WindingRule;
import edu.neu.ccs.util.Bezier;
import edu.neu.ccs.util.FileExtensionFilter;
import edu.neu.ccs.util.FileUtilities;
import edu.neu.ccs.util.Metric;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.File;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.JFileChooser;

public class PathList
implements Stringable {
    public static final int MOVE = 0;
    public static final int LINE = 1;
    public static final int QUAD = 2;
    public static final int CUBIC = 3;
    public static final int CLOSE = 4;
    private static final int CAP_ROUND = 1;
    private static final int JOIN_ROUND = 1;
    public static final String standardMessage = "\nPathList error\nLine 1 should be either of the 2 strings\nWIND_NON_ZERO or WIND_EVEN_ODD\n\nThe remaining lines should give the data\nfor the path nodes with one node per line\n";
    public static final String String_WIND_NON_ZERO = "WIND_NON_ZERO";
    public static final String String_WIND_EVEN_ODD = "WIND_EVEN_ODD";
    protected Vector pathlist = new Vector();
    protected WindingRule windingrule = WindingRule.WIND_NON_ZERO;
    protected final FileExtensionFilter textFileFilter = new FileExtensionFilter("txt");
    protected final File home = new File(".");
    protected final JFileChooser filechooser = new JFileChooser();

    public PathList() {
        this.filechooser.setFileFilter(this.textFileFilter);
        this.filechooser.setCurrentDirectory(this.home);
    }

    public PathList(PathNode[] nodes) {
        this();
        this.append(nodes);
    }

    public PathList(PathNode[] nodes, WindingRule rule) {
        this();
        this.append(nodes);
        this.setWindingRule(rule);
    }

    public PathList(PathNode[] nodes, int rule) {
        this();
        this.append(nodes);
        this.setWindingRule(rule);
    }

    public PathList(PathList list) {
        this();
        this.setPathList(list);
    }

    public PathList(PathIterator iterator) {
        this();
        this.setPathList(iterator);
    }

    public PathList(Shape shape) {
        this();
        this.setPathList(shape);
    }

    public PathList(Shape shape, AffineTransform transform) {
        this();
        this.setPathList(shape, transform);
    }

    public PathList(Shape shape, AffineTransform transform, double flatness) {
        this();
        this.setPathList(shape, transform, flatness);
    }

    public PathList(Point2D[] points, boolean close) {
        this();
        if (points == null) {
            return;
        }
        int N = points.length;
        boolean first = true;
        int i = 0;
        while (i < N) {
            if (points[i] != null) {
                int type = first ? 0 : 1;
                float x = (float)points[i].getX();
                float y = (float)points[i].getY();
                this.append(new PathNode(type, x, y, 0.0f, 0.0f, 0.0f, 0.0f));
                first = false;
            }
            ++i;
        }
        if (close) {
            this.append(new PathNode(4, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
        }
    }

    public PathList(Point2D[] points, boolean close, WindingRule rule) {
        this(points, close);
        this.setWindingRule(rule);
    }

    public PathList(Point2D[] points, boolean close, int rule) {
        this(points, close);
        this.setWindingRule(rule);
    }

    public final Shape makeShape() {
        GeneralPath gp = new GeneralPath(this.getWindingRule().rule());
        if (!this.isValid()) {
            return gp;
        }
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: {
                    gp.moveTo(node.getX1(), node.getY1());
                    break;
                }
                case 1: {
                    gp.lineTo(node.getX1(), node.getY1());
                    break;
                }
                case 2: {
                    gp.quadTo(node.getX1(), node.getY1(), node.getX2(), node.getY2());
                    break;
                }
                case 3: {
                    gp.curveTo(node.getX1(), node.getY1(), node.getX2(), node.getY2(), node.getX3(), node.getY3());
                    break;
                }
                case 4: {
                    gp.closePath();
                    break;
                }
            }
            ++i;
        }
        return gp;
    }

    public final PathListIterator makePathListIterator() {
        return new PathListIterator(this);
    }

    public final PaintableSequence makeStructurePaintable(Color fillColor, Color drawColor, Color vertexDotsColor, Color controlDotsColor, Color vertexFrameColor, Color bezierFrameColor, int thickness) {
        if (thickness < 1) {
            thickness = 1;
        }
        int epsilon = thickness + 2;
        BasicStroke stroke = new BasicStroke(thickness, 1, 1);
        PlotMark plotmark = new PlotMark(PlotMarkAlgorithm.Square, epsilon, true);
        Shape mainshape = this.makeShape();
        Shape shape = null;
        Color color = null;
        Point2D[] points = null;
        PaintableSequence sequence = new PaintableSequence();
        color = controlDotsColor;
        if (color != null && color.getAlpha() > 0) {
            points = this.makeControlPoints();
            sequence.appendPaintable(PointPaintable.makePaintableSequence(points, plotmark, (Paint)color));
        }
        if ((color = vertexDotsColor) != null && color.getAlpha() > 0) {
            points = this.makeVertexPoints();
            sequence.appendPaintable(PointPaintable.makePaintableSequence(points, plotmark, (Paint)color));
        }
        if ((color = drawColor) != null && color.getAlpha() > 0) {
            shape = mainshape;
            sequence.appendPaintable(new ShapePaintable(shape, PaintMode.DRAW, null, (Paint)color, (Stroke)stroke));
        }
        if ((color = bezierFrameColor) != null && color.getAlpha() > 0) {
            shape = this.makeBezierShape();
            sequence.appendPaintable(new ShapePaintable(shape, PaintMode.DRAW, null, (Paint)color, (Stroke)stroke));
        }
        if ((color = vertexFrameColor) != null && color.getAlpha() > 0) {
            shape = this.makeVertexShape();
            sequence.appendPaintable(new ShapePaintable(shape, PaintMode.DRAW, null, (Paint)color, (Stroke)stroke));
        }
        if ((color = fillColor) != null && color.getAlpha() > 0) {
            shape = mainshape;
            sequence.appendPaintable(new ShapePaintable(shape, PaintMode.FILL, (Paint)color));
        }
        return sequence;
    }

    public final PaintableSequence makeStructurePaintable(Color fillColor, Color drawColor, int thickness) {
        Color vertexDotsColor = Colors.red;
        Color controlDotsColor = Colors.darkorange;
        Color vertexFrameColor = Colors.transparent;
        Color bezierFrameColor = Colors.darkorchid;
        return this.makeStructurePaintable(fillColor, drawColor, vertexDotsColor, controlDotsColor, vertexFrameColor, bezierFrameColor, thickness);
    }

    public final PaintableSequence makeStructurePaintable(int thickness) {
        Color fillColor = Colors.lime;
        Color drawColor = Colors.black;
        Color vertexDotsColor = Colors.red;
        Color controlDotsColor = Colors.darkorange;
        Color vertexFrameColor = Colors.transparent;
        Color bezierFrameColor = Colors.darkorchid;
        return this.makeStructurePaintable(fillColor, drawColor, vertexDotsColor, controlDotsColor, vertexFrameColor, bezierFrameColor, thickness);
    }

    public final PaintableSequence makeStructurePaintable() {
        Color fillColor = Colors.lime;
        Color drawColor = Colors.black;
        Color vertexDotsColor = Colors.red;
        Color controlDotsColor = Colors.darkorange;
        Color vertexFrameColor = Colors.transparent;
        Color bezierFrameColor = Colors.darkorchid;
        int thickness = 2;
        return this.makeStructurePaintable(fillColor, drawColor, vertexDotsColor, controlDotsColor, vertexFrameColor, bezierFrameColor, thickness);
    }

    public final void setPathNodes(PathNode[] nodes) {
        if (nodes == null) {
            return;
        }
        this.removeAll();
        this.append(nodes);
    }

    public final PathNode[] getPathNodes() {
        return this.pathlist.toArray(new PathNode[0]);
    }

    public final void setWindingRule(WindingRule rule) {
        if (rule == null) {
            return;
        }
        this.windingrule = rule;
    }

    public final void setWindingRule(int rule) {
        if (rule == 1) {
            this.windingrule = WindingRule.WIND_NON_ZERO;
        } else if (rule == 0) {
            this.windingrule = WindingRule.WIND_EVEN_ODD;
        }
    }

    public final WindingRule getWindingRule() {
        return this.windingrule;
    }

    public final void setPathList(PathList list) {
        if (list == null) {
            return;
        }
        this.removeAll();
        int N = list.size();
        int i = 0;
        while (i < N) {
            this.append(new PathNode(list.get(i)));
            ++i;
        }
        this.setWindingRule(list.getWindingRule());
    }

    public final void setPathList(PathIterator iterator) {
        if (iterator != null) {
            this.removeAll();
            this.append(PathNode.getPathNodes(iterator));
            this.setWindingRule(iterator.getWindingRule());
        }
    }

    public final void setPathList(Shape shape) {
        if (shape != null) {
            this.setPathList(shape.getPathIterator(null));
        }
    }

    public final void setPathList(Shape shape, AffineTransform transform) {
        if (shape != null) {
            this.setPathList(shape.getPathIterator(transform));
        }
    }

    public final void setPathList(Shape shape, AffineTransform transform, double flatness) {
        if (shape != null) {
            this.setPathList(shape.getPathIterator(transform, flatness));
        }
    }

    public final int size() {
        return this.pathlist.size();
    }

    public final void set(int index, PathNode node) {
        if (node == null) {
            return;
        }
        PathNode internal = this.get(index);
        if (internal != null) {
            internal.setPathNode(node);
        }
    }

    public final PathNode get(int index) {
        if (index >= 0 && index < this.size()) {
            return (PathNode)this.pathlist.get(index);
        }
        return null;
    }

    public final void setSlot(int index, int slot, float x, float y) {
        PathNode internal = this.get(index);
        if (internal != null) {
            internal.setSlot(slot, x, y);
        }
    }

    public final void setSlot(int index, int slot, float[] pair) {
        if (pair == null || pair.length != 2) {
            return;
        }
        this.setSlot(index, slot, pair[0], pair[1]);
    }

    public final void setSlot(int[] indices, float x, float y) {
        if (indices == null || indices.length != 2) {
            return;
        }
        this.setSlot(indices[0], indices[1], x, y);
    }

    public final void setSlot(int[] indices, float[] pair) {
        if (indices == null || indices.length != 2) {
            return;
        }
        if (pair == null || pair.length != 2) {
            return;
        }
        this.setSlot(indices[0], indices[1], pair[0], pair[1]);
    }

    public final float[] getSlot(int index, int slot) {
        PathNode internal = this.get(index);
        if (internal == null) {
            return null;
        }
        return internal.getSlot(slot);
    }

    public final float[] getSlot(int[] indices) {
        if (indices == null || indices.length != 2) {
            return null;
        }
        return this.getSlot(indices[0], indices[1]);
    }

    public final int[] nearSlot(double x, double y, double epsilon) {
        return this.nearSlot(x, y, epsilon, Metric.MAX);
    }

    public final int[] nearSlot(double x, double y, double epsilon, Metric metric) {
        if (metric == null) {
            metric = Metric.MAX;
        }
        int N = this.size();
        int index = 0;
        while (index < N) {
            PathNode internal = (PathNode)this.pathlist.get(index);
            int slot = internal.nearSlot(x, y, epsilon, metric);
            if (slot > 0) {
                return new int[]{index, slot};
            }
            ++index;
        }
        return null;
    }

    public final void add(int index, PathNode node) {
        if (node == null) {
            return;
        }
        if (index < 0) {
            index = 0;
        } else if (index > this.size()) {
            index = this.size();
        }
        this.pathlist.add(index, node);
    }

    public final void add(int index, PathNode[] nodes) {
        this.add(index, nodes, false);
    }

    public final void add(int index, PathNode[] nodes, boolean connect) {
        if (nodes == null) {
            return;
        }
        int N = nodes.length;
        if (N == 0) {
            return;
        }
        if (index < 0) {
            index = 0;
        } else if (index > this.size()) {
            index = this.size();
        }
        int start = index;
        int i = 0;
        while (i < N) {
            if (nodes[i] != null) {
                this.pathlist.add(index, nodes[i]);
                ++index;
            }
            ++i;
        }
        if (connect && start > 0 && index > start) {
            this.get(start).changeMoveToLine();
        }
    }

    public final void append(PathNode node) {
        if (node == null) {
            return;
        }
        this.pathlist.add(node);
    }

    public final void append(PathNode[] nodes) {
        this.append(nodes, false);
    }

    public final void append(PathNode[] nodes, boolean connect) {
        int start;
        if (nodes == null) {
            return;
        }
        int N = nodes.length;
        if (N == 0) {
            return;
        }
        int index = start = this.size();
        int i = 0;
        while (i < N) {
            if (nodes[i] != null) {
                this.pathlist.add(nodes[i]);
                ++index;
            }
            ++i;
        }
        if (connect && start > 0 && index > start) {
            this.get(start).changeMoveToLine();
        }
    }

    public final void append(PathIterator iterator) {
        this.append(iterator, false);
    }

    public final void append(PathIterator iterator, boolean connect) {
        if (iterator == null) {
            return;
        }
        this.append(PathNode.getPathNodes(iterator), connect);
    }

    public final void append(Shape shape) {
        this.append(shape, false);
    }

    public final void append(Shape shape, boolean connect) {
        if (shape == null) {
            return;
        }
        this.append(shape.getPathIterator(null), connect);
    }

    public final void append(Shape shape, AffineTransform transform) {
        this.append(shape, transform, false);
    }

    public final void append(Shape shape, AffineTransform transform, boolean connect) {
        if (shape == null) {
            return;
        }
        this.append(shape.getPathIterator(transform), connect);
    }

    public final void append(Shape shape, AffineTransform transform, double flatness) {
        this.append(shape, transform, flatness, false);
    }

    public final void append(Shape shape, AffineTransform transform, double flatness, boolean connect) {
        if (shape == null) {
            return;
        }
        this.append(shape.getPathIterator(transform, flatness), connect);
    }

    public final void cloneAndAdd(int index, PathNode node) {
        if (node == null) {
            return;
        }
        if (index < 0) {
            index = 0;
        } else if (index > this.size()) {
            index = this.size();
        }
        this.pathlist.add(index, new PathNode(node));
    }

    public final void cloneAndAdd(int index, PathNode[] nodes) {
        this.cloneAndAdd(index, nodes, false);
    }

    public final void cloneAndAdd(int index, PathNode[] nodes, boolean connect) {
        if (nodes == null) {
            return;
        }
        int N = nodes.length;
        if (N == 0) {
            return;
        }
        if (index < 0) {
            index = 0;
        } else if (index > this.size()) {
            index = this.size();
        }
        int start = index;
        int i = 0;
        while (i < N) {
            if (nodes[i] != null) {
                this.pathlist.add(index, new PathNode(nodes[i]));
                ++index;
            }
            ++i;
        }
        if (connect && start > 0 && index > start) {
            this.get(start).changeMoveToLine();
        }
    }

    public final void cloneAndAppend(PathNode node) {
        if (node == null) {
            return;
        }
        this.pathlist.add(new PathNode(node));
    }

    public final void cloneAndAppend(PathNode[] nodes) {
        this.cloneAndAppend(nodes, false);
    }

    public final void cloneAndAppend(PathNode[] nodes, boolean connect) {
        int start;
        if (nodes == null) {
            return;
        }
        int N = nodes.length;
        if (N == 0) {
            return;
        }
        int index = start = this.size();
        int i = 0;
        while (i < N) {
            if (nodes[i] != null) {
                this.pathlist.add(new PathNode(nodes[i]));
                ++index;
            }
            ++i;
        }
        if (connect && start > 0 && index > start) {
            this.get(start).changeMoveToLine();
        }
    }

    public final PathNode remove(int index) {
        if (index >= 0 && index < this.size()) {
            return (PathNode)this.pathlist.remove(index);
        }
        return null;
    }

    public final PathNode[] remove(int m, int n) {
        int c;
        if (m < 0) {
            m = 0;
        }
        if (n > this.size()) {
            n = this.size();
        }
        if ((c = n - m) <= 0) {
            return new PathNode[0];
        }
        PathNode[] result = new PathNode[c];
        while (n > m) {
            result[--c] = (PathNode)this.pathlist.remove(--n);
        }
        return result;
    }

    public final PathNode[] removeAll() {
        return this.remove(0, this.size());
    }

    public final void transform(AffineTransform T) {
        if (T == null) {
            return;
        }
        int N = this.size();
        int i = 0;
        while (i < N) {
            this.get(i).transform(T);
            ++i;
        }
    }

    public final boolean isValid() {
        return this.size() == 0 || this.get(0).getNodeType() == 0;
    }

    public final boolean isPolygon() {
        int N = this.size();
        if (N < 2) {
            return false;
        }
        if (this.get(0).getNodeType() != 0) {
            return false;
        }
        int i = 1;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            if (type == 2 || type == 3) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean isStrictPolygon() {
        int N = this.size();
        if (N < 2) {
            return false;
        }
        if (this.get(0).getNodeType() != 0) {
            return false;
        }
        int M = N - 1;
        int i = 1;
        while (i < M) {
            if (this.get(i).getNodeType() != 1) {
                return false;
            }
            ++i;
        }
        boolean hasLINE = M > 1;
        PathNode node = this.get(M);
        int type = node.getNodeType();
        if (type == 1) {
            hasLINE = true;
        } else if (type != 4) {
            return false;
        }
        return hasLINE;
    }

    public final PathList makeVertexPathList() {
        PathList list = new PathList();
        list.setWindingRule(this.getWindingRule());
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: 
                case 1: 
                case 4: {
                    list.append(new PathNode(node));
                    break;
                }
                case 2: {
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    list.append(new PathNode(1, x2, y2, 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
                case 3: {
                    float x3 = node.getX3();
                    float y3 = node.getY3();
                    list.append(new PathNode(1, x3, y3, 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
            }
            ++i;
        }
        return list;
    }

    public final PathList makeBezierPathList() {
        PathList list = new PathList();
        list.setWindingRule(this.getWindingRule());
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: 
                case 1: 
                case 4: {
                    list.append(new PathNode(node));
                    break;
                }
                case 2: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    list.append(new PathNode(1, x1, y1, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(1, x2, y2, 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
                case 3: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    float x3 = node.getX3();
                    float y3 = node.getY3();
                    list.append(new PathNode(1, x1, y1, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(1, x2, y2, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(1, x3, y3, 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
            }
            ++i;
        }
        return list;
    }

    public final PathList makeVertexDotsPathList() {
        PathList list = new PathList();
        list.setWindingRule(this.getWindingRule());
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: 
                case 1: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    list.append(new PathNode(0, x1, y1, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(1, x1, y1, 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
                case 2: {
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    list.append(new PathNode(0, x2, y2, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(1, x2, y2, 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
                case 3: {
                    float x3 = node.getX3();
                    float y3 = node.getY3();
                    list.append(new PathNode(0, x3, y3, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(1, x3, y3, 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
            }
            ++i;
        }
        return list;
    }

    public final PathList makeBezierDotsPathList() {
        PathList list = new PathList();
        list.setWindingRule(this.getWindingRule());
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: 
                case 1: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    list.append(new PathNode(0, x1, y1, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(1, x1, y1, 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
                case 2: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    list.append(new PathNode(0, x1, y1, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(1, x1, y1, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(0, x2, y2, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(1, x2, y2, 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
                case 3: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    float x3 = node.getX3();
                    float y3 = node.getY3();
                    list.append(new PathNode(0, x1, y1, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(1, x1, y1, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(0, x2, y2, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(1, x2, y2, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(0, x3, y3, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(1, x3, y3, 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
            }
            ++i;
        }
        return list;
    }

    public final PathList makeControlDotsPathList() {
        PathList list = new PathList();
        list.setWindingRule(this.getWindingRule());
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 2: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    list.append(new PathNode(0, x1, y1, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(1, x1, y1, 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
                case 3: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    list.append(new PathNode(0, x1, y1, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(1, x1, y1, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(0, x2, y2, 0.0f, 0.0f, 0.0f, 0.0f));
                    list.append(new PathNode(1, x2, y2, 0.0f, 0.0f, 0.0f, 0.0f));
                    break;
                }
            }
            ++i;
        }
        return list;
    }

    public final PathListIterator makeVertexPathListIterator() {
        return this.makeVertexPathList().makePathListIterator();
    }

    public final PathListIterator makeBezierPathListIterator() {
        return this.makeBezierPathList().makePathListIterator();
    }

    public final PathListIterator makeVertexDotsPathListIterator() {
        return this.makeVertexDotsPathList().makePathListIterator();
    }

    public final PathListIterator makeBezierDotsPathListIterator() {
        return this.makeBezierDotsPathList().makePathListIterator();
    }

    public final PathListIterator makeControlDotsPathListIterator() {
        return this.makeControlDotsPathList().makePathListIterator();
    }

    public final Shape makeVertexShape() {
        GeneralPath gp = new GeneralPath(this.getWindingRule().rule());
        if (!this.isValid()) {
            return gp;
        }
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: {
                    gp.moveTo(node.getX1(), node.getY1());
                    break;
                }
                case 1: {
                    gp.lineTo(node.getX1(), node.getY1());
                    break;
                }
                case 2: {
                    gp.lineTo(node.getX2(), node.getY2());
                    break;
                }
                case 3: {
                    gp.lineTo(node.getX3(), node.getY3());
                    break;
                }
                case 4: {
                    gp.closePath();
                    break;
                }
            }
            ++i;
        }
        return gp;
    }

    public final Shape makeBezierShape() {
        GeneralPath gp = new GeneralPath(this.getWindingRule().rule());
        if (!this.isValid()) {
            return gp;
        }
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: {
                    gp.moveTo(node.getX1(), node.getY1());
                    break;
                }
                case 1: {
                    gp.lineTo(node.getX1(), node.getY1());
                    break;
                }
                case 2: {
                    gp.lineTo(node.getX1(), node.getY1());
                    gp.lineTo(node.getX2(), node.getY2());
                    break;
                }
                case 3: {
                    gp.lineTo(node.getX1(), node.getY1());
                    gp.lineTo(node.getX2(), node.getY2());
                    gp.lineTo(node.getX3(), node.getY3());
                    break;
                }
                case 4: {
                    gp.closePath();
                    break;
                }
            }
            ++i;
        }
        return gp;
    }

    public final Shape makeVertexDotsShape() {
        GeneralPath gp = new GeneralPath(this.getWindingRule().rule());
        if (!this.isValid()) {
            return gp;
        }
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: {
                    gp.moveTo(node.getX1(), node.getY1());
                    gp.lineTo(node.getX1(), node.getY1());
                    break;
                }
                case 1: {
                    gp.moveTo(node.getX1(), node.getY1());
                    gp.lineTo(node.getX1(), node.getY1());
                    break;
                }
                case 2: {
                    gp.moveTo(node.getX2(), node.getY2());
                    gp.lineTo(node.getX2(), node.getY2());
                    break;
                }
                case 3: {
                    gp.moveTo(node.getX3(), node.getY3());
                    gp.lineTo(node.getX3(), node.getY3());
                    break;
                }
            }
            ++i;
        }
        return gp;
    }

    public final Shape makeBezierDotsShape() {
        GeneralPath gp = new GeneralPath(this.getWindingRule().rule());
        if (!this.isValid()) {
            return gp;
        }
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: {
                    gp.moveTo(node.getX1(), node.getY1());
                    gp.lineTo(node.getX1(), node.getY1());
                    break;
                }
                case 1: {
                    gp.moveTo(node.getX1(), node.getY1());
                    gp.lineTo(node.getX1(), node.getY1());
                    break;
                }
                case 2: {
                    gp.moveTo(node.getX1(), node.getY1());
                    gp.lineTo(node.getX1(), node.getY1());
                    gp.moveTo(node.getX2(), node.getY2());
                    gp.lineTo(node.getX2(), node.getY2());
                    break;
                }
                case 3: {
                    gp.moveTo(node.getX1(), node.getY1());
                    gp.lineTo(node.getX1(), node.getY1());
                    gp.moveTo(node.getX2(), node.getY2());
                    gp.lineTo(node.getX2(), node.getY2());
                    gp.moveTo(node.getX3(), node.getY3());
                    gp.lineTo(node.getX3(), node.getY3());
                    break;
                }
            }
            ++i;
        }
        return gp;
    }

    public final Shape makeControlDotsShape() {
        GeneralPath gp = new GeneralPath(this.getWindingRule().rule());
        if (!this.isValid()) {
            return gp;
        }
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 2: {
                    gp.moveTo(node.getX1(), node.getY1());
                    gp.lineTo(node.getX1(), node.getY1());
                    break;
                }
                case 3: {
                    gp.moveTo(node.getX1(), node.getY1());
                    gp.lineTo(node.getX1(), node.getY1());
                    gp.moveTo(node.getX2(), node.getY2());
                    gp.lineTo(node.getX2(), node.getY2());
                    break;
                }
            }
            ++i;
        }
        return gp;
    }

    public final Point2D[] makeVertexPoints() {
        Vector<Point2D.Double> list = new Vector<Point2D.Double>();
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: 
                case 1: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    list.add(new Point2D.Double(x1, y1));
                    break;
                }
                case 2: {
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    list.add(new Point2D.Double(x2, y2));
                    break;
                }
                case 3: {
                    float x3 = node.getX3();
                    float y3 = node.getY3();
                    list.add(new Point2D.Double(x3, y3));
                    break;
                }
            }
            ++i;
        }
        return list.toArray(new Point2D[0]);
    }

    public final Point2D[] makeBezierPoints() {
        Vector<Point2D.Double> list = new Vector<Point2D.Double>();
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 0: 
                case 1: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    list.add(new Point2D.Double(x1, y1));
                    break;
                }
                case 2: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    list.add(new Point2D.Double(x1, y1));
                    list.add(new Point2D.Double(x2, y2));
                    break;
                }
                case 3: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    float x3 = node.getX3();
                    float y3 = node.getY3();
                    list.add(new Point2D.Double(x1, y1));
                    list.add(new Point2D.Double(x2, y2));
                    list.add(new Point2D.Double(x3, y3));
                    break;
                }
            }
            ++i;
        }
        return list.toArray(new Point2D[0]);
    }

    public final Point2D[] makeControlPoints() {
        Vector<Point2D.Double> list = new Vector<Point2D.Double>();
        int N = this.size();
        int i = 0;
        while (i < N) {
            PathNode node = this.get(i);
            int type = node.getNodeType();
            switch (type) {
                case 2: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    list.add(new Point2D.Double(x1, y1));
                    break;
                }
                case 3: {
                    float x1 = node.getX1();
                    float y1 = node.getY1();
                    float x2 = node.getX2();
                    float y2 = node.getY2();
                    list.add(new Point2D.Double(x1, y1));
                    list.add(new Point2D.Double(x2, y2));
                    break;
                }
            }
            ++i;
        }
        return list.toArray(new Point2D[0]);
    }

    public static Shape makeVertexShape(Shape shape) {
        PathList pathlist = new PathList(shape);
        return pathlist.makeVertexShape();
    }

    public static Shape makeBezierShape(Shape shape) {
        PathList pathlist = new PathList(shape);
        return pathlist.makeBezierShape();
    }

    public static Shape makeVertexDotsShape(Shape shape) {
        PathList pathlist = new PathList(shape);
        return pathlist.makeVertexDotsShape();
    }

    public static Shape makeBezierDotsShape(Shape shape) {
        PathList pathlist = new PathList(shape);
        return pathlist.makeBezierDotsShape();
    }

    public static Shape makeControlDotsShape(Shape shape) {
        PathList pathlist = new PathList(shape);
        return pathlist.makeControlDotsShape();
    }

    public static Point2D[] makeVertexPoints(Shape shape) {
        PathList pathlist = new PathList(shape);
        return pathlist.makeVertexPoints();
    }

    public static Point2D[] makeBezierPoints(Shape shape) {
        PathList pathlist = new PathList(shape);
        return pathlist.makeBezierPoints();
    }

    public static Point2D[] makeControlPoints(Shape shape) {
        PathList pathlist = new PathList(shape);
        return pathlist.makeControlPoints();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public final float[] getShapePoint(float t) {
        N = this.size();
        if (N == 0) {
            return new float[2];
        }
        start = this.get(0);
        if (start.getNodeType() != 0) {
            return new float[2];
        }
        if (t <= 0.0f) {
            return new float[]{start.getX1(), start.getY1()};
        }
        M = N - 1;
        if (t > (float)M) {
            return this.getShapePoint(M);
        }
        k = (int)t;
        z = t - (float)k;
        if (z == 0.0f) {
            node = this.get(k);
            type = node.getNodeType();
            switch (type) {
                case 0: 
                case 1: {
                    return new float[]{node.getX1(), node.getY1()};
                }
                case 2: {
                    return new float[]{node.getX2(), node.getY2()};
                }
                case 3: {
                    return new float[]{node.getX3(), node.getY3()};
                }
                case 4: {
                    --k;
                    while (k >= 0) {
                        node = this.get(k);
                        type = node.getNodeType();
                        if (type == 0) {
                            return new float[]{node.getX1(), node.getY1()};
                        }
                        --k;
                    }
                    return new float[2];
                }
            }
            return new float[2];
        }
        node = this.get(k + 1);
        type = node.getNodeType();
        last = this.getShapePoint(k);
        x0 = last[0];
        y0 = last[1];
        switch (type) {
            case 0: {
                return last;
            }
            case 1: {
                x1 = node.getX1();
                y1 = node.getY1();
                x = Bezier.bezierF(z, x0, x1);
                y = Bezier.bezierF(z, y0, y1);
                return new float[]{x, y};
            }
            case 2: {
                x1 = node.getX1();
                y1 = node.getY1();
                x2 = node.getX2();
                y2 = node.getY2();
                x = Bezier.bezierF(z, x0, x1, x2);
                y = Bezier.bezierF(z, y0, y1, y2);
                return new float[]{x, y};
            }
            case 3: {
                x1 = node.getX1();
                y1 = node.getY1();
                x2 = node.getX2();
                y2 = node.getY2();
                x3 = node.getX3();
                y3 = node.getY3();
                x = Bezier.bezierF(z, x0, x1, x2, x3);
                y = Bezier.bezierF(z, y0, y1, y2, y3);
                return new float[]{x, y};
            }
            default: {
                return new float[2];
            }
            case 4: {
                if (--k >= 0) ** continue;
            }
            ** while ((type = (node = this.get((int)k)).getNodeType()) != 0)
        }
lbl-1000:
        // 1 sources

        {
            if (--k >= 0) continue;
        }
lbl73:
        // 3 sources

        x1 = node.getX1();
        y1 = node.getY1();
        x = Bezier.bezierF(z, x0, x1);
        y = Bezier.bezierF(z, y0, y1);
        return new float[]{x, y};
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getWindingRuleString());
        buffer.append("\n");
        int N = this.size();
        int i = 0;
        while (i < N) {
            buffer.append(this.get(i).toString());
            buffer.append("\n");
            ++i;
        }
        return buffer.toString();
    }

    public String toStringData() {
        return this.toString();
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            String message = "PathList error: null data\n";
            throw new ParseException(message, -1);
        }
        String[] item = Strings.tokenize(data = data.trim(), "\n", true);
        int L = item.length;
        if (L < 1) {
            String message = "PathList error: Too few lines of data " + L + "\n" + data + "\n\n" + standardMessage;
            throw new ParseException(message, -1);
        }
        WindingRule rule = this.getWindingRuleFromStringData(item[0]);
        int N = L - 1;
        PathNode[] nodes = new PathNode[N];
        int i = 0;
        while (i < N) {
            String info = item[i + 1];
            try {
                nodes[i] = new PathNode(info);
            }
            catch (ParseException ex) {
                String message = "PathList error in PathNode data item: " + i + "\n" + info + "\n\n" + ex.getMessage() + "\n" + standardMessage;
                throw new ParseException(message, -1);
            }
            ++i;
        }
        this.setWindingRule(rule);
        this.setPathNodes(nodes);
    }

    public final String[] getPathNodeStateArray() {
        int N = this.size();
        String[] state = new String[N];
        int i = 0;
        while (i < N) {
            state[i] = this.get(i).toStringData();
            ++i;
        }
        return state;
    }

    public final String getWindingRuleString() {
        if (this.windingrule == WindingRule.WIND_NON_ZERO) {
            return String_WIND_NON_ZERO;
        }
        return String_WIND_EVEN_ODD;
    }

    public WindingRule getWindingRuleFromStringData(String data) throws ParseException {
        if (data == null) {
            String message = "PathList winding rule error: null data\n";
            throw new ParseException(message, -1);
        }
        if ((data = data.trim().toUpperCase()).equals(String_WIND_NON_ZERO)) {
            return WindingRule.WIND_NON_ZERO;
        }
        if (data.equals(String_WIND_EVEN_ODD)) {
            return WindingRule.WIND_EVEN_ODD;
        }
        String message = "PathList winding rule error:\n" + data + "\n\n" + standardMessage;
        throw new ParseException(message, -1);
    }

    public final boolean readDataFromFile() {
        int result = this.filechooser.showOpenDialog(null);
        if (result == 1) {
            return false;
        }
        if (result == -1) {
            GeneralDialog.showOKDialog("File Dialog Error", "File Dialog Error");
            return false;
        }
        File source = this.filechooser.getSelectedFile();
        this.filechooser.setCurrentDirectory(source);
        return this.readDataFromFile(source, true);
    }

    public final boolean readDataFromFile(File source, boolean displayErrorDialogs) {
        if (source == null) {
            if (displayErrorDialogs) {
                String message = "Error in reading file\nNull source File\n";
                GeneralDialog.showOKDialog(message, "File Read Error");
            }
            return false;
        }
        String data = "";
        try {
            data = FileUtilities.readFile(source);
        }
        catch (Exception ex) {
            if (displayErrorDialogs) {
                String message = "Error in reading file\n" + source.getName() + "\n\n" + ex.getMessage() + "\n";
                GeneralDialog.showOKDialog(message, "File Read Error");
            }
            return false;
        }
        PathList list = new PathList();
        try {
            list.fromStringData(data);
        }
        catch (ParseException ex) {
            if (displayErrorDialogs) {
                String message = "Error in reading data\n" + source.getName() + "\n\n" + ex.getMessage() + "\n";
                GeneralDialog.showOKDialog(message, "File Data Error");
            }
            return false;
        }
        this.setPathList(list);
        return true;
    }

    public final boolean saveDataToFile() {
        int result = this.filechooser.showSaveDialog(null);
        if (result == 1) {
            return false;
        }
        if (result == -1) {
            GeneralDialog.showOKDialog("File Dialog Error", "File Dialog Error");
            return false;
        }
        File target = this.filechooser.getSelectedFile();
        this.filechooser.setCurrentDirectory(target);
        return this.saveDataToFile(target, true);
    }

    public final boolean saveDataToFile(File target, boolean displayErrorDialogs) {
        if (target == null) {
            if (displayErrorDialogs) {
                String message = "Error in writing file\nNull target File\n";
                GeneralDialog.showOKDialog(message, "File Save Error");
            }
            return false;
        }
        String data = this.toString();
        try {
            FileUtilities.writeFile(target, data, true);
        }
        catch (Exception ex) {
            if (displayErrorDialogs) {
                String message = "Error in writing file\n" + target.getName() + "\n\n" + ex.getMessage() + "\n";
                GeneralDialog.showOKDialog(message, "File Save Error");
            }
            return false;
        }
        return true;
    }
}

