/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ActionSequence;
import edu.neu.ccs.gui.MouseActionEvent;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.event.MouseInputListener;

public class MouseActionAdapter
implements MouseInputListener,
Cloneable,
Serializable {
    protected ActionSequence clickedActions = new ActionSequence();
    protected ActionSequence enteredActions = new ActionSequence();
    protected ActionSequence exitedActions = new ActionSequence();
    protected ActionSequence pressedActions = new ActionSequence();
    protected ActionSequence releasedActions = new ActionSequence();
    protected ActionSequence draggedActions = new ActionSequence();
    protected ActionSequence movedActions = new ActionSequence();

    public MouseActionAdapter() {
        this(null);
    }

    public MouseActionAdapter(Component component) {
        this.addAsListenerTo(component);
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
        this.clickedActions.actionPerformed(new MouseActionEvent(mouseEvent, mouseEvent.getSource()));
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
        this.enteredActions.actionPerformed(new MouseActionEvent(mouseEvent, mouseEvent.getSource()));
    }

    public final void mouseExited(MouseEvent mouseEvent) {
        this.exitedActions.actionPerformed(new MouseActionEvent(mouseEvent, mouseEvent.getSource()));
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        this.pressedActions.actionPerformed(new MouseActionEvent(mouseEvent, mouseEvent.getSource()));
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        this.releasedActions.actionPerformed(new MouseActionEvent(mouseEvent, mouseEvent.getSource()));
    }

    public final void mouseDragged(MouseEvent mouseEvent) {
        this.draggedActions.actionPerformed(new MouseActionEvent(mouseEvent, mouseEvent.getSource()));
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
        this.movedActions.actionPerformed(new MouseActionEvent(mouseEvent, mouseEvent.getSource()));
    }

    public void addAsListenerTo(Component component) {
        if (component == null) {
            return;
        }
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    public void removeAsListenerTo(Component component) {
        if (component == null) {
            return;
        }
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
    }

    public void addMouseClickedAction(ActionListener actionListener) {
        this.clickedActions.add(actionListener);
    }

    public void addMouseEnteredAction(ActionListener actionListener) {
        this.enteredActions.add(actionListener);
    }

    public void addMouseExitedAction(ActionListener actionListener) {
        this.exitedActions.add(actionListener);
    }

    public void addMousePressedAction(ActionListener actionListener) {
        this.pressedActions.add(actionListener);
    }

    public void addMouseReleasedAction(ActionListener actionListener) {
        this.releasedActions.add(actionListener);
    }

    public void addMouseDraggedAction(ActionListener actionListener) {
        this.draggedActions.add(actionListener);
    }

    public void addMouseMovedAction(ActionListener actionListener) {
        this.movedActions.add(actionListener);
    }

    public void removeMouseClickedAction(ActionListener actionListener) {
        this.clickedActions.remove(actionListener);
    }

    public void removeMouseEnteredAction(ActionListener actionListener) {
        this.enteredActions.remove(actionListener);
    }

    public void removeMouseExitedAction(ActionListener actionListener) {
        this.exitedActions.remove(actionListener);
    }

    public void removeMousePressedAction(ActionListener actionListener) {
        this.pressedActions.remove(actionListener);
    }

    public void removeMouseReleasedAction(ActionListener actionListener) {
        this.releasedActions.remove(actionListener);
    }

    public void removeMouseDraggedAction(ActionListener actionListener) {
        this.draggedActions.remove(actionListener);
    }

    public void removeMouseMovedAction(ActionListener actionListener) {
        this.movedActions.remove(actionListener);
    }

    public void setMouseClickedActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.clickedActions.clear();
        } else {
            this.clickedActions = actionSequence;
        }
    }

    public void setMouseEnteredActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.enteredActions.clear();
        } else {
            this.enteredActions = actionSequence;
        }
    }

    public void setMouseExitedActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.exitedActions.clear();
        } else {
            this.exitedActions = actionSequence;
        }
    }

    public void setMousePressedActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.pressedActions.clear();
        } else {
            this.pressedActions = actionSequence;
        }
    }

    public void setMouseReleasedActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.releasedActions.clear();
        } else {
            this.releasedActions = actionSequence;
        }
    }

    public void setMouseDraggedActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.draggedActions.clear();
        } else {
            this.draggedActions = actionSequence;
        }
    }

    public void setMouseMovedActions(ActionSequence actionSequence) {
        if (actionSequence == null) {
            this.movedActions.clear();
        } else {
            this.movedActions = actionSequence;
        }
    }

    public ActionSequence getMouseClickedActions() {
        return this.clickedActions;
    }

    public ActionSequence getMouseEnteredActions() {
        return this.enteredActions;
    }

    public ActionSequence getMouseExitedActions() {
        return this.exitedActions;
    }

    public ActionSequence getMousePressedActions() {
        return this.pressedActions;
    }

    public ActionSequence getMouseReleasedActions() {
        return this.releasedActions;
    }

    public ActionSequence getMouseDraggedActions() {
        return this.draggedActions;
    }

    public ActionSequence getMouseMovedActions() {
        return this.movedActions;
    }

    public void uninstallAllMouseActions() {
        this.setMouseMovedActions(null);
        this.setMousePressedActions(null);
        this.setMouseReleasedActions(null);
        this.setMouseClickedActions(null);
        this.setMouseDraggedActions(null);
        this.setMouseEnteredActions(null);
        this.setMouseExitedActions(null);
    }
}

