/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.XLine2D;
import edu.neu.ccs.gui.CenterLayout;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.KeyActionAdapter;
import edu.neu.ccs.gui.MouseAction;
import edu.neu.ccs.gui.MouseActionAdapter;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableSequence;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class BufferedPanel
extends DisplayPanel {
    public static final Color DEFAULT_BUFFER_BACKGROUND = Color.white;
    protected BufferedImage buffer = null;
    protected PaintableSequence paintablesequence = new PaintableSequence();
    protected Painter painter = null;
    protected Paint bufferBackground = DEFAULT_BUFFER_BACKGROUND;
    protected MouseActionAdapter mouseActions = null;
    protected KeyActionAdapter keyActions = null;
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected Paintable currentPaintable = null;
    protected boolean autoShiftToTop = false;
    protected boolean mouseIsInPanel = true;
    protected MouseAction SMA_Moved_Action = new 1();
    protected MouseAction SMA_Pressed_Action = new 2();
    protected MouseAction SMA_Released_Action = new 3();
    protected MouseAction SMA_Clicked_Action = new 4();
    protected MouseAction SMA_Dragged_Action = new 5();
    protected MouseAction SMA_Entered_Action = new 6();
    protected MouseAction SMA_Exited_Action = new 7();

    public BufferedPanel(int n, int n2) {
        this(n, n2, DEFAULT_BUFFER_BACKGROUND);
    }

    public BufferedPanel(Dimension dimension) {
        this(dimension == null ? 1 : dimension.width, dimension == null ? 1 : dimension.height, DEFAULT_BUFFER_BACKGROUND);
    }

    public BufferedPanel(int n, int n2, Paint paint) {
        super(new CenterLayout());
        this.setBufferBackground(paint);
        this.setBufferSize(n, n2);
        this.painter = new Painter(this);
        this.add(this.painter);
        this.mouseActions = new MouseActionAdapter(this.painter);
        this.keyActions = new KeyActionAdapter(this.painter);
    }

    public BufferedPanel(Dimension dimension, Paint paint) {
        this(dimension == null ? 1 : dimension.width, dimension == null ? 1 : dimension.height, paint);
    }

    public Graphics2D getBufferGraphics() {
        return this.buffer.createGraphics();
    }

    public BufferedImage getBuffer() {
        return this.buffer;
    }

    public void quickRepaint() {
        DisplayPanel displayPanel = this.getInnerPanel();
        Graphics graphics = displayPanel.getGraphics();
        if (graphics == null) {
            return;
        }
        displayPanel.paint(graphics);
    }

    public void fillPanel(Paint paint) {
        if (paint == null) {
            return;
        }
        Graphics2D graphics2D = this.getBufferGraphics();
        graphics2D.setPaint(paint);
        graphics2D.fillRect(0, 0, this.getBufferWidth(), this.getBufferHeight());
    }

    public void clearPanel() {
        this.fillPanel(this.getBufferBackground());
    }

    public final Paintable[] clearSequence() {
        return this.paintablesequence.clearSequence();
    }

    public Paintable[] clearPanelAndSequence() {
        this.clearPanel();
        return this.clearSequence();
    }

    public void setBufferBackground(Paint paint) {
        if (paint == null) {
            return;
        }
        this.bufferBackground = paint;
    }

    public Paint getBufferBackground() {
        return this.bufferBackground;
    }

    public void drawGrid(int n) {
        this.drawGrid(n, null);
    }

    public void drawGrid(int n, Color color) {
        if (n <= 0) {
            return;
        }
        if (color == null) {
            color = Colors.lightgray;
        }
        Graphics2D graphics2D = this.getBufferGraphics();
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(color);
        XLine2D xLine2D = new XLine2D();
        int n2 = this.getBufferWidth();
        int n3 = this.getBufferHeight();
        int n4 = n;
        while (n4 < n2) {
            xLine2D.setValue(n4, 0.0, n4, n3);
            graphics2D.draw(xLine2D);
            n4 += n;
        }
        int n5 = n;
        while (n5 < n3) {
            xLine2D.setValue(0.0, n5, n2, n5);
            graphics2D.draw(xLine2D);
            n5 += n;
        }
        graphics2D.setPaint(paint);
    }

    public void setBackground(Color color) {
        if (this.painter != null) {
            this.painter.setBackground(color);
        }
        super.setBackground(color);
    }

    public synchronized void setBufferSize(Dimension dimension) {
        if (dimension == null) {
            return;
        }
        this.setBufferSize(dimension.width, dimension.height);
    }

    public synchronized void setBufferSize(int n, int n2) {
        n = Math.max(n, 1);
        n2 = Math.max(n2, 1);
        BufferedImage bufferedImage = this.buffer;
        this.buffer = new BufferedImage(n, n2, 1);
        this.clearPanel();
        if (bufferedImage != null) {
            Graphics2D graphics2D = this.getBufferGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, this);
        }
        this.refreshComponent();
    }

    public int getBufferWidth() {
        return this.buffer.getWidth();
    }

    public int getBufferHeight() {
        return this.buffer.getHeight();
    }

    public void setMouseActionAdapter(MouseActionAdapter mouseActionAdapter) {
        if (mouseActionAdapter == null) {
            return;
        }
        this.painter.removeMouseListener(this.mouseActions);
        this.painter.removeMouseMotionListener(this.mouseActions);
        this.mouseActions = mouseActionAdapter;
        this.painter.addMouseListener(this.mouseActions);
        this.painter.addMouseMotionListener(this.mouseActions);
    }

    public MouseActionAdapter getMouseActionAdapter() {
        return this.mouseActions;
    }

    public void setKeyActionAdapter(KeyActionAdapter keyActionAdapter) {
        if (keyActionAdapter == null) {
            return;
        }
        this.painter.removeKeyListener(this.keyActions);
        this.keyActions = keyActionAdapter;
        this.painter.addKeyListener(this.keyActions);
    }

    public KeyActionAdapter getKeyActionAdapter() {
        return this.keyActions;
    }

    public final PaintableSequence getPaintableSequence() {
        return this.paintablesequence;
    }

    public final Paintable setPaintable(int n, Object object) {
        return this.paintablesequence.setPaintable(n, object);
    }

    public final Paintable setPaintable(Object object, int n) {
        return this.paintablesequence.setPaintable(object, n);
    }

    public final Paintable getPaintable(int n) {
        return this.paintablesequence.getPaintable(n);
    }

    public final int getIndex(Paintable paintable) {
        return this.paintablesequence.getIndex(paintable);
    }

    public final Paintable addPaintable(int n, Object object) {
        return this.paintablesequence.addPaintable(n, object);
    }

    public final Paintable addPaintable(Object object, int n) {
        return this.paintablesequence.addPaintable(object, n);
    }

    public final Paintable addPaintable(Object object) {
        return this.paintablesequence.addPaintable(object);
    }

    public final Paintable addPaintableAtTop(Object object) {
        return this.paintablesequence.addPaintableAtTop(object);
    }

    public final Paintable appendPaintable(Object object) {
        return this.paintablesequence.appendPaintable(object);
    }

    public final Paintable[] setSequence(Object[] objectArray) {
        return this.paintablesequence.setSequence(objectArray);
    }

    public final Paintable[] addSequence(int n, Object[] objectArray) {
        return this.paintablesequence.addSequence(n, objectArray);
    }

    public final Paintable[] addSequence(Object[] objectArray, int n) {
        return this.paintablesequence.addSequence(objectArray, n);
    }

    public final Paintable[] addSequence(Object[] objectArray) {
        return this.paintablesequence.addSequence(objectArray);
    }

    public final Paintable[] addSequenceAtTop(Object[] objectArray) {
        return this.paintablesequence.addSequenceAtTop(objectArray);
    }

    public final Paintable[] appendSequence(Object[] objectArray) {
        return this.paintablesequence.appendSequence(objectArray);
    }

    public final Paintable removePaintable(int n) {
        return this.paintablesequence.removePaintable(n);
    }

    public final void removePaintable(Paintable paintable) {
        this.paintablesequence.removePaintable(paintable);
    }

    public final Paintable[] removeSequence(int n, int n2) {
        return this.paintablesequence.removeSequence(n, n2);
    }

    public void paintOver(Graphics2D graphics2D) {
    }

    public DisplayPanel getInnerPanel() {
        return this.painter;
    }

    protected void SMA_Moved(MouseEvent mouseEvent) {
        if (this.mouseIsInPanel) {
            this.setMousePosition(mouseEvent);
        }
    }

    protected void SMA_Pressed(MouseEvent mouseEvent) {
        this.mouseIsInPanel = true;
        this.setMousePosition(mouseEvent);
        int n = this.mouseX;
        int n2 = this.mouseY;
        this.currentPaintable = this.paintablesequence != null ? this.paintablesequence.hits(n, n2) : null;
        if (this.currentPaintable != null && this.autoShiftToTop) {
            this.paintablesequence.shiftPaintableToTop(this.currentPaintable);
            this.repaint();
        }
    }

    protected void SMA_Released(MouseEvent mouseEvent) {
    }

    protected void SMA_Clicked(MouseEvent mouseEvent) {
    }

    protected void SMA_Dragged(MouseEvent mouseEvent) {
        int n = this.mouseX;
        int n2 = this.mouseY;
        if (this.mouseIsInPanel) {
            this.setMousePosition(mouseEvent);
        }
        int n3 = this.mouseX;
        int n4 = this.mouseY;
        if (this.currentPaintable != null && (n3 != n || n4 != n2)) {
            int n5 = n3 - n;
            int n6 = n4 - n2;
            this.currentPaintable.move(n5, n6);
            this.repaint();
        }
    }

    protected void SMA_Entered(MouseEvent mouseEvent) {
        this.mouseIsInPanel = true;
    }

    protected void SMA_Exited(MouseEvent mouseEvent) {
        this.mouseIsInPanel = false;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public void setMousePosition(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
    }

    public void setAutoShiftToTop(boolean bl) {
        this.autoShiftToTop = bl;
    }

    public boolean getAutoShiftToTop() {
        return this.autoShiftToTop;
    }

    public void installSimpleMouseActions() {
        this.uninstallAllMouseActions();
        this.mouseActions.addMouseMovedAction(this.SMA_Moved_Action);
        this.mouseActions.addMousePressedAction(this.SMA_Pressed_Action);
        this.mouseActions.addMouseReleasedAction(this.SMA_Released_Action);
        this.mouseActions.addMouseClickedAction(this.SMA_Clicked_Action);
        this.mouseActions.addMouseDraggedAction(this.SMA_Dragged_Action);
        this.mouseActions.addMouseEnteredAction(this.SMA_Entered_Action);
        this.mouseActions.addMouseExitedAction(this.SMA_Exited_Action);
    }

    public void installSimpleMouseActions(boolean bl) {
        this.installSimpleMouseActions();
        this.setAutoShiftToTop(bl);
    }

    public void uninstallAllMouseActions() {
        this.mouseActions.uninstallAllMouseActions();
    }

    public void uninstallAllKeyActions() {
        this.keyActions.uninstallAllKeyActions();
    }

    private final class 1
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent mouseEvent) {
            BufferedPanel.this.SMA_Moved(mouseEvent);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent mouseEvent) {
            BufferedPanel.this.SMA_Pressed(mouseEvent);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent mouseEvent) {
            BufferedPanel.this.SMA_Released(mouseEvent);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent mouseEvent) {
            BufferedPanel.this.SMA_Clicked(mouseEvent);
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent mouseEvent) {
            BufferedPanel.this.SMA_Dragged(mouseEvent);
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent mouseEvent) {
            BufferedPanel.this.SMA_Entered(mouseEvent);
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    extends MouseAction {
        public void mouseActionPerformed(MouseEvent mouseEvent) {
            BufferedPanel.this.SMA_Exited(mouseEvent);
        }

        /* synthetic */ 7() {
        }
    }

    protected static class Painter
    extends DisplayPanel {
        protected BufferedPanel panel = null;

        protected Painter(BufferedPanel bufferedPanel) {
            this.panel = bufferedPanel;
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.panel.getBufferWidth(), this.panel.getBufferHeight());
        }

        protected void paintComponent(Graphics graphics) {
            Insets insets = this.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            graphics.drawImage(this.panel.getBuffer(), n, n2, this);
            graphics.translate(n, n2);
            this.panel.paintablesequence.paint(graphics);
            graphics.translate(-n, -n2);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Insets insets = this.getInsets();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.transform(AffineTransform.getTranslateInstance(insets.left, insets.top));
            this.panel.paintOver(graphics2D);
        }
    }
}

