/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.filter;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.MaximumBoundFilter;
import edu.neu.ccs.filter.MinimumBoundFilter;
import edu.neu.ccs.filter.NumericFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class RangeFilter
extends NumericFilter
implements PropertyChangeListener {
    public static final String MINIMUM = "minimum";
    public static final String MAXIMUM = "maximum";
    public static final String MINIMUM_INCLUSIVE = "minimum.inclusive";
    public static final String MAXIMUM_INCLUSIVE = "maximum.inclusive";
    protected MinimumBoundFilter minimum = null;
    protected MaximumBoundFilter maximum = null;

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.minimum) {
            if (propertyChangeEvent.getPropertyName() == MINIMUM) {
                this.changeAdapter.firePropertyChange(MINIMUM, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName() == "inclusive") {
                this.changeAdapter.firePropertyChange(MINIMUM_INCLUSIVE, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        } else if (propertyChangeEvent.getSource() == this.maximum) {
            if (propertyChangeEvent.getPropertyName() == MAXIMUM) {
                this.changeAdapter.firePropertyChange(MAXIMUM, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName() == "inclusive") {
                this.changeAdapter.firePropertyChange(MAXIMUM_INCLUSIVE, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }

    public static class Long
    extends RangeFilter {
        public Long(long l, long l2) {
            this(l, true, l2, true);
        }

        public Long(long l, boolean bl, long l2, boolean bl2) {
            this.minimum = new MinimumBoundFilter.Long(l, bl);
            this.minimum.addPropertyChangeListener(this);
            this.maximum = new MaximumBoundFilter.Long(l2, bl2);
            this.maximum.addPropertyChangeListener(this);
        }

        public Stringable filterStringable(Stringable stringable) throws FilterException {
            stringable = super.filterStringable(stringable);
            try {
                stringable = this.minimum.filterStringable(stringable);
                stringable = this.maximum.filterStringable(stringable);
            }
            catch (FilterException filterException) {
                String string = "Value not within the range ";
                string = String.valueOf(string) + (this.isMinimumInclusive() ? "[" : "(");
                string = String.valueOf(string) + this.getMinimum() + ",";
                string = String.valueOf(string) + this.getMaximum();
                string = String.valueOf(string) + (this.isMaximumInclusive() ? "]" : ")");
                throw new FilterException(stringable, string);
            }
            return stringable;
        }

        public void setMinimum(long l) {
            this.getMinimumFilter().setMinimum(l);
        }

        public long getMinimum() {
            return this.getMinimumFilter().getMinimum();
        }

        public void setMaximum(long l) {
            this.getMaximumFilter().setMaximum(l);
        }

        public long getMaximum() {
            return this.getMaximumFilter().getMaximum();
        }

        public void setMinimumInclusive(boolean bl) {
            this.minimum.setInclusive(bl);
        }

        public boolean isMinimumInclusive() {
            return this.minimum.isInclusive();
        }

        public void setMaximumInclusive(boolean bl) {
            this.maximum.setInclusive(bl);
        }

        public boolean isMaximumInclusive() {
            return this.maximum.isInclusive();
        }

        protected MinimumBoundFilter.Long getMinimumFilter() {
            return (MinimumBoundFilter.Long)this.minimum;
        }

        protected MaximumBoundFilter.Long getMaximumFilter() {
            return (MaximumBoundFilter.Long)this.maximum;
        }
    }

    public static class Double
    extends RangeFilter {
        public Double(double d, double d2) {
            this(d, true, d2, true);
        }

        public Double(double d, boolean bl, double d2, boolean bl2) {
            this.minimum = new MinimumBoundFilter.Double(d, bl);
            this.minimum.addPropertyChangeListener(this);
            this.maximum = new MaximumBoundFilter.Double(d2, bl2);
            this.maximum.addPropertyChangeListener(this);
        }

        public Stringable filterStringable(Stringable stringable) throws FilterException {
            stringable = super.filterStringable(stringable);
            try {
                stringable = this.minimum.filterStringable(stringable);
                stringable = this.maximum.filterStringable(stringable);
            }
            catch (FilterException filterException) {
                String string = "Value not within the range ";
                string = String.valueOf(string) + (this.isMinimumInclusive() ? "[" : "(");
                string = String.valueOf(string) + this.getMinimum() + ",";
                string = String.valueOf(string) + this.getMaximum();
                string = String.valueOf(string) + (this.isMaximumInclusive() ? "]" : ")");
                throw new FilterException(stringable, string);
            }
            return stringable;
        }

        public void setMinimum(double d) {
            this.getMinimumFilter().setMinimum(d);
        }

        public double getMinimum() {
            return this.getMinimumFilter().getMinimum();
        }

        public void setMaximum(double d) {
            this.getMaximumFilter().setMaximum(d);
        }

        public double getMaximum() {
            return this.getMaximumFilter().getMaximum();
        }

        public void setMinimumInclusive(boolean bl) {
            this.minimum.setInclusive(bl);
        }

        public boolean isMinimumInclusive() {
            return this.minimum.isInclusive();
        }

        public void setMaximumInclusive(boolean bl) {
            this.maximum.setInclusive(bl);
        }

        public boolean isMaximumInclusive() {
            return this.maximum.isInclusive();
        }

        protected MinimumBoundFilter.Double getMinimumFilter() {
            return (MinimumBoundFilter.Double)this.minimum;
        }

        protected MaximumBoundFilter.Double getMaximumFilter() {
            return (MaximumBoundFilter.Double)this.maximum;
        }
    }

    public static class BigInteger
    extends RangeFilter {
        public BigInteger(java.math.BigInteger bigInteger, java.math.BigInteger bigInteger2) {
            this(bigInteger, true, bigInteger2, true);
        }

        public BigInteger(java.math.BigInteger bigInteger, boolean bl, java.math.BigInteger bigInteger2, boolean bl2) {
            this.minimum = new MinimumBoundFilter.BigInteger(bigInteger, bl);
            this.minimum.addPropertyChangeListener(this);
            this.maximum = new MaximumBoundFilter.BigInteger(bigInteger2, bl2);
            this.maximum.addPropertyChangeListener(this);
        }

        public Stringable filterStringable(Stringable stringable) throws FilterException {
            stringable = super.filterStringable(stringable);
            try {
                stringable = this.minimum.filterStringable(stringable);
                stringable = this.maximum.filterStringable(stringable);
            }
            catch (FilterException filterException) {
                String string = "Value not within the range ";
                string = String.valueOf(string) + (this.isMinimumInclusive() ? "[" : "(");
                string = String.valueOf(string) + this.getMinimum() + ",";
                string = String.valueOf(string) + this.getMaximum();
                string = String.valueOf(string) + (this.isMaximumInclusive() ? "]" : ")");
                throw new FilterException(stringable, string);
            }
            return stringable;
        }

        public void setMinimum(java.math.BigInteger bigInteger) {
            this.getMinimumFilter().setMinimum(bigInteger);
        }

        public java.math.BigInteger getMinimum() {
            return this.getMinimumFilter().getMinimum();
        }

        public void setMaximum(java.math.BigInteger bigInteger) {
            this.getMaximumFilter().setMaximum(bigInteger);
        }

        public java.math.BigInteger getMaximum() {
            return this.getMaximumFilter().getMaximum();
        }

        public void setMinimumInclusive(boolean bl) {
            this.minimum.setInclusive(bl);
        }

        public boolean isMinimumInclusive() {
            return this.minimum.isInclusive();
        }

        public void setMaximumInclusive(boolean bl) {
            this.maximum.setInclusive(bl);
        }

        public boolean isMaximumInclusive() {
            return this.maximum.isInclusive();
        }

        protected MinimumBoundFilter.BigInteger getMinimumFilter() {
            return (MinimumBoundFilter.BigInteger)this.minimum;
        }

        protected MaximumBoundFilter.BigInteger getMaximumFilter() {
            return (MaximumBoundFilter.BigInteger)this.maximum;
        }
    }

    public static class BigDecimal
    extends RangeFilter {
        protected MinimumBoundFilter.BigDecimal minimum = null;
        protected MaximumBoundFilter.BigDecimal maximum = null;

        public BigDecimal(java.math.BigDecimal bigDecimal, java.math.BigDecimal bigDecimal2) {
            this(bigDecimal, true, bigDecimal2, true);
        }

        public BigDecimal(java.math.BigDecimal bigDecimal, boolean bl, java.math.BigDecimal bigDecimal2, boolean bl2) {
            this.minimum = new MinimumBoundFilter.BigDecimal(bigDecimal, bl);
            this.minimum.addPropertyChangeListener(this);
            this.maximum = new MaximumBoundFilter.BigDecimal(bigDecimal2, bl2);
            this.maximum.addPropertyChangeListener(this);
        }

        public Stringable filterStringable(Stringable stringable) throws FilterException {
            stringable = super.filterStringable(stringable);
            try {
                stringable = this.minimum.filterStringable(stringable);
                stringable = this.maximum.filterStringable(stringable);
            }
            catch (FilterException filterException) {
                String string = "Value not within the range ";
                string = String.valueOf(string) + (this.isMinimumInclusive() ? "[" : "(");
                string = String.valueOf(string) + this.getMinimum() + ",";
                string = String.valueOf(string) + this.getMaximum();
                string = String.valueOf(string) + (this.isMaximumInclusive() ? "]" : ")");
                throw new FilterException(stringable, string);
            }
            return stringable;
        }

        public void setMinimum(java.math.BigDecimal bigDecimal) {
            this.getMinimumFilter().setMinimum(bigDecimal);
        }

        public java.math.BigDecimal getMinimum() {
            return this.getMinimumFilter().getMinimum();
        }

        public void setMaximum(java.math.BigDecimal bigDecimal) {
            this.getMaximumFilter().setMaximum(bigDecimal);
        }

        public java.math.BigDecimal getMaximum() {
            return this.getMaximumFilter().getMaximum();
        }

        public void setMinimumInclusive(boolean bl) {
            this.minimum.setInclusive(bl);
        }

        public boolean isMinimumInclusive() {
            return this.minimum.isInclusive();
        }

        public void setMaximumInclusive(boolean bl) {
            this.maximum.setInclusive(bl);
        }

        public boolean isMaximumInclusive() {
            return this.maximum.isInclusive();
        }

        protected MinimumBoundFilter.BigDecimal getMinimumFilter() {
            return this.minimum;
        }

        protected MaximumBoundFilter.BigDecimal getMaximumFilter() {
            return this.maximum;
        }
    }
}

