/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.util.JPTConstants;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.event.SwingPropertyChangeSupport;

public class XInterval
implements Serializable,
Stringable,
JPTConstants {
    private static String[] BLANK = new String[]{"", ""};
    private static String[] MINMAX = new String[]{"min", "max"};
    private static String[] MAXMIN = new String[]{"max", "min"};
    public static final String standardMessage = "\nXInterval Error: Data format must be\n[...;...] or\n[min=...;max=...] or\n[max=...;min=...]\nwhere ... stands for\nthe minimum and maximum of the interval\n";
    protected double minimum = 0.0;
    protected double maximum = 0.0;
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);

    public XInterval() {
    }

    public XInterval(XInterval interval) {
        this.setInterval(interval);
    }

    public XInterval(double endpointA, double endpointB) {
        this.setEndpoints(endpointA, endpointB);
    }

    public XInterval(String data) throws ParseException {
        this.fromStringData(data);
    }

    public String toString() {
        return "XInterval[min=" + this.minimum + ";max=" + this.maximum + "]";
    }

    public String toStringData() {
        return "[" + this.minimum + ";" + this.maximum + "]";
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException(standardMessage, -1);
        }
        String[] strings = Strings.decode(data);
        if (strings == null) {
            throw new ParseException(standardMessage, -1);
        }
        if (strings.length != 2) {
            throw new ParseException(standardMessage, -1);
        }
        Object[] names = Strings.getNames(strings);
        String[] values = Strings.getValues(strings);
        if (Arrays.equals(names, BLANK) || Arrays.equals(names, MINMAX)) {
            names = MINMAX;
        } else if (Arrays.equals(names, MAXMIN)) {
            names = MAXMIN;
        } else {
            throw new ParseException(standardMessage, -1);
        }
        double[] result = null;
        try {
            result = Strings.stringsToDoubles(values);
        }
        catch (ParseException ex) {
            throw Strings.makeAdjustedParseException(ex, "XInterval", (String[])names);
        }
        this.setEndpoints(result[0], result[1]);
    }

    public void setEndpoints(double endpointA, double endpointB) {
        double oldMin = this.getMinimum();
        double oldMax = this.getMaximum();
        if (endpointA <= endpointB) {
            this.minimum = endpointA;
            this.maximum = endpointB;
        } else {
            this.minimum = endpointB;
            this.maximum = endpointA;
        }
        if (this.minimum != oldMin || this.maximum != oldMax) {
            this.changeAdapter.firePropertyChange("value", null, null);
        }
    }

    public void setInterval(XInterval interval) {
        if (interval == null) {
            return;
        }
        this.setEndpoints(interval.minimum, interval.maximum);
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getSize() {
        return this.maximum - this.minimum;
    }

    public double getMidpoint() {
        return this.minimum + (this.maximum - this.minimum) / 2.0;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }
}

