/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import edu.neu.ccs.XObject;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class XInt
extends XNumber {
    private int value = 0;

    public XInt() {
    }

    public XInt(int n) {
        this.value = n;
    }

    public XInt(String string) throws ParseException {
        this.fromStringData(string);
    }

    public void fromStringData(String string) throws ParseException {
        int n = this.value;
        Parser parser = ParserUtilities.getDefaultParser();
        Object object = parser.parse(string);
        if (!(object instanceof XNumber)) {
            throw new ParseException("Expected numeric value.", string.length());
        }
        XNumber xNumber = (XNumber)object;
        this.value = xNumber.intValue();
        this.changeAdapter.firePropertyChange("value", new Integer(n), string);
    }

    public String toStringData() {
        return String.valueOf(this.value);
    }

    public byte byteValue() {
        if (this.getValue() > 127 || this.getValue() < -128) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue();
    }

    public short shortValue() {
        if (this.getValue() > Short.MAX_VALUE || this.getValue() < Short.MIN_VALUE) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue();
    }

    public int intValue() {
        return this.getValue();
    }

    public long longValue() {
        return this.getValue();
    }

    public float floatValue() {
        return this.getValue();
    }

    public double doubleValue() {
        return this.getValue();
    }

    public boolean equals(Object object) {
        if (object instanceof XInt) {
            return this.getValue() == ((XInt)object).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Integer(this.getValue()).hashCode();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void setValue(int n) {
        int n2 = this.value;
        this.value = n;
        if (this.getValue() != n2) {
            this.changeAdapter.firePropertyChange("value", new Integer(n2), new Integer(this.getValue()));
        }
    }

    public int getValue() {
        return this.value;
    }

    public static int parseInt(String string) throws NumberFormatException {
        try {
            return new XInt((String)string).value;
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(XObject.formatErrorMessage(parseException, string));
        }
    }

    public static int[] toPrimitiveArray(XInt[] xIntArray) {
        if (xIntArray == null) {
            return null;
        }
        int[] nArray = new int[xIntArray.length];
        int n = 0;
        while (n < nArray.length) {
            if (xIntArray[n] != null) {
                nArray[n] = xIntArray[n].getValue();
            }
            ++n;
        }
        return nArray;
    }

    public static XInt[] toXArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        XInt[] xIntArray = new XInt[nArray.length];
        int n = 0;
        while (n < xIntArray.length) {
            xIntArray[n] = new XInt(nArray[n]);
            ++n;
        }
        return xIntArray;
    }
}

