/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import edu.neu.ccs.XObject;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserUtilities;
import java.text.ParseException;

public class XFloat
extends XNumber {
    private float value = 0.0f;

    public XFloat() {
    }

    public XFloat(float f) {
        this.value = f;
    }

    public XFloat(String string) throws ParseException {
        this.fromStringData(string);
    }

    public void fromStringData(String string) throws ParseException {
        float f = this.value;
        Parser parser = ParserUtilities.getDefaultParser();
        Object object = parser.parse(string);
        if (!(object instanceof XNumber)) {
            throw new ParseException("Expected numeric value.", string.length());
        }
        XNumber xNumber = (XNumber)object;
        this.value = xNumber.floatValue();
        this.changeAdapter.firePropertyChange("value", new Float(f), string);
    }

    public String toStringData() {
        return String.valueOf(this.value);
    }

    public byte byteValue() {
        if (this.getValue() > 127.0f || this.getValue() < -128.0f) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue();
    }

    public short shortValue() {
        if (this.getValue() > 32767.0f || this.getValue() < -32768.0f) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue();
    }

    public int intValue() {
        if (this.getValue() > 2.1474836E9f || this.getValue() < -2.1474836E9f) {
            throw new NumberFormatException("Number beyond precision of an int.");
        }
        return (int)this.getValue();
    }

    public long longValue() {
        if (this.getValue() > 9.223372E18f || this.getValue() < -9.223372E18f) {
            throw new NumberFormatException("Number beyond precision of a long.");
        }
        return (long)this.getValue();
    }

    public float floatValue() {
        return this.getValue();
    }

    public double doubleValue() {
        return this.getValue();
    }

    public boolean equals(Object object) {
        if (object instanceof XFloat) {
            return this.getValue() == ((XFloat)object).getValue();
        }
        return false;
    }

    public int hashCode() {
        return new Float(this.getValue()).hashCode();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void setValue(float f) {
        float f2 = this.value;
        this.value = f;
        if (this.getValue() != f2) {
            this.changeAdapter.firePropertyChange("value", new Float(f2), new Float(this.value));
        }
    }

    public float getValue() {
        return this.value;
    }

    public static float parseFloat(String string) throws NumberFormatException {
        try {
            return new XFloat((String)string).value;
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(XObject.formatErrorMessage(parseException, string));
        }
    }

    public static float[] toPrimitiveArray(XFloat[] xFloatArray) {
        if (xFloatArray == null) {
            return null;
        }
        float[] fArray = new float[xFloatArray.length];
        int n = 0;
        while (n < fArray.length) {
            if (xFloatArray[n] != null) {
                fArray[n] = xFloatArray[n].getValue();
            }
            ++n;
        }
        return fArray;
    }

    public static XFloat[] toXArray(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        XFloat[] xFloatArray = new XFloat[fArray.length];
        int n = 0;
        while (n < xFloatArray.length) {
            xFloatArray[n] = new XFloat(fArray[n]);
            ++n;
        }
        return xFloatArray;
    }
}

