/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;

public class XBigDecimal
extends XNumber {
    private static final BigDecimal ZERO = new BigDecimal("0");
    private BigDecimal value = ZERO;
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;

    public XBigDecimal() {
    }

    public XBigDecimal(BigDecimal bigDecimal) {
        this.setValue(bigDecimal);
    }

    public XBigDecimal(XBigDecimal xBigDecimal) {
        this.setValue(xBigDecimal);
    }

    public XBigDecimal(String string) throws ParseException {
        this.fromStringData(string);
    }

    public XBigDecimal(XBigInteger xBigInteger) {
        this.setValue(xBigInteger);
    }

    public XBigDecimal(XBigInteger xBigInteger, int n) {
        this.setValue(xBigInteger, n);
    }

    public XBigDecimal(long l) {
        this.setValue(l);
    }

    public XBigDecimal(long l, int n) {
        this.setValue(l, n);
    }

    public XBigDecimal(double d) {
        this.setValue(d);
    }

    public void fromStringData(String string) throws ParseException {
        if (string == null) {
            throw new ParseException("\nXBigDecimal fromStringData(String) Error: Data was null\n", -1);
        }
        try {
            this.setValue(new BigDecimal(string));
        }
        catch (Exception exception) {
            String string2 = "\nXBigDecimal fromStringData(String) Error:\n" + exception.getMessage() + "\n";
            throw new ParseException(string2, string.length());
        }
    }

    public String toStringData() {
        return this.value.toString();
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof XBigDecimal) {
            XBigDecimal xBigDecimal = (XBigDecimal)object;
            return this.getValue().equals(xBigDecimal.getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public void setValue(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = this.value;
        BigDecimal bigDecimal3 = this.value = bigDecimal == null ? ZERO : bigDecimal;
        if (!this.value.equals(bigDecimal2)) {
            this.changeAdapter.firePropertyChange("value", bigDecimal2, this.value);
        }
    }

    public final void setValue(XBigDecimal xBigDecimal) {
        this.setValue(xBigDecimal == null ? ZERO : xBigDecimal.getValue());
    }

    public final void setValue(String string) throws ParseException {
        if (string == null) {
            throw new ParseException("\nXBigDecimal setValue(String) Error: Data was null\n", -1);
        }
        this.fromStringData(string);
    }

    public void setValue(XBigInteger xBigInteger) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        this.setValue(new BigDecimal(bigInteger));
    }

    public void setValue(XBigInteger xBigInteger, int n) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        this.setValue(new BigDecimal(bigInteger, n));
    }

    public void setValue(long l) {
        this.setValue(BigDecimal.valueOf(l));
    }

    public void setValue(long l, int n) {
        this.setValue(BigDecimal.valueOf(l, n));
    }

    public void setValue(double d) {
        this.setValue(new BigDecimal(d));
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public byte byteValue() {
        BigDecimal bigDecimal = new BigDecimal("127");
        BigDecimal bigDecimal2 = new BigDecimal("-128");
        if (this.getValue().compareTo(bigDecimal) > 0 || this.getValue().compareTo(bigDecimal2) < 0) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue().intValue();
    }

    public short shortValue() {
        BigDecimal bigDecimal = new BigDecimal("32767");
        BigDecimal bigDecimal2 = new BigDecimal("-32768");
        if (this.getValue().compareTo(bigDecimal) > 0 || this.getValue().compareTo(bigDecimal2) < 0) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue().intValue();
    }

    public int intValue() {
        BigDecimal bigDecimal = new BigDecimal("2147483647");
        BigDecimal bigDecimal2 = new BigDecimal("-2147483648");
        if (this.getValue().compareTo(bigDecimal) > 0 || this.getValue().compareTo(bigDecimal2) < 0) {
            throw new NumberFormatException("Number beyond precision of an int.");
        }
        return this.getValue().intValue();
    }

    public long longValue() {
        BigDecimal bigDecimal = new BigDecimal("9223372036854775807");
        BigDecimal bigDecimal2 = new BigDecimal("-9223372036854775808");
        if (this.getValue().compareTo(bigDecimal) > 0 || this.getValue().compareTo(bigDecimal2) < 0) {
            throw new NumberFormatException("Number beyond precision of a long.");
        }
        return this.getValue().longValue();
    }

    public float floatValue() {
        return this.getValue().floatValue();
    }

    public double doubleValue() {
        return this.getValue().doubleValue();
    }

    public final int signum() {
        return this.getValue().signum();
    }

    public final int scale() {
        return this.getValue().scale();
    }

    public final void setScale(int n) {
        this.setValue(this.getValue().setScale(n));
    }

    public static XBigDecimal setScale(XBigDecimal xBigDecimal, int n) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        return new XBigDecimal(bigDecimal.setScale(n));
    }

    public final void setScale(int n, int n2) {
        this.setValue(this.getValue().setScale(n, n2));
    }

    public static XBigDecimal setScale(XBigDecimal xBigDecimal, int n, int n2) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        return new XBigDecimal(bigDecimal.setScale(n, n2));
    }

    public final void movePointLeft(int n) {
        this.setValue(this.getValue().movePointLeft(n));
    }

    public static XBigDecimal movePointLeft(XBigDecimal xBigDecimal, int n) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        return new XBigDecimal(bigDecimal.movePointLeft(n));
    }

    public final void movePointRight(int n) {
        this.setValue(this.getValue().movePointRight(n));
    }

    public static XBigDecimal movePointRight(XBigDecimal xBigDecimal, int n) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        return new XBigDecimal(bigDecimal.movePointRight(n));
    }

    public final XBigInteger toUnscaledXBigInteger() {
        return new XBigInteger(this.getValue().unscaledValue());
    }

    public final XBigInteger toXBigInteger() {
        return new XBigInteger(this.getValue().toBigInteger());
    }

    public final void abs() {
        this.setValue(this.getValue().abs());
    }

    public static XBigDecimal abs(XBigDecimal xBigDecimal) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        return new XBigDecimal(bigDecimal.abs());
    }

    public final void negate() {
        this.setValue(this.getValue().negate());
    }

    public static XBigDecimal negate(XBigDecimal xBigDecimal) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        return new XBigDecimal(bigDecimal.negate());
    }

    public final void max(XBigDecimal xBigDecimal) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        this.setValue(this.getValue().max(bigDecimal));
    }

    public static XBigDecimal max(XBigDecimal xBigDecimal, XBigDecimal xBigDecimal2) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        BigDecimal bigDecimal2 = xBigDecimal2 == null ? ZERO : xBigDecimal2.getValue();
        return new XBigDecimal(bigDecimal.max(bigDecimal2));
    }

    public final void min(XBigDecimal xBigDecimal) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        this.setValue(this.getValue().min(bigDecimal));
    }

    public static XBigDecimal min(XBigDecimal xBigDecimal, XBigDecimal xBigDecimal2) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        BigDecimal bigDecimal2 = xBigDecimal2 == null ? ZERO : xBigDecimal2.getValue();
        return new XBigDecimal(bigDecimal.min(bigDecimal2));
    }

    public final void add(XBigDecimal xBigDecimal) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        this.setValue(this.getValue().add(bigDecimal));
    }

    public static XBigDecimal add(XBigDecimal xBigDecimal, XBigDecimal xBigDecimal2) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        BigDecimal bigDecimal2 = xBigDecimal2 == null ? ZERO : xBigDecimal2.getValue();
        return new XBigDecimal(bigDecimal.add(bigDecimal2));
    }

    public final void subtract(XBigDecimal xBigDecimal) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        this.setValue(this.getValue().subtract(bigDecimal));
    }

    public static XBigDecimal subtract(XBigDecimal xBigDecimal, XBigDecimal xBigDecimal2) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        BigDecimal bigDecimal2 = xBigDecimal2 == null ? ZERO : xBigDecimal2.getValue();
        return new XBigDecimal(bigDecimal.subtract(bigDecimal2));
    }

    public final void multiply(XBigDecimal xBigDecimal) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        this.setValue(this.getValue().multiply(bigDecimal));
    }

    public static XBigDecimal multiply(XBigDecimal xBigDecimal, XBigDecimal xBigDecimal2) {
        BigDecimal bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        BigDecimal bigDecimal2 = xBigDecimal2 == null ? ZERO : xBigDecimal2.getValue();
        return new XBigDecimal(bigDecimal.multiply(bigDecimal2));
    }

    public final void divide(XBigDecimal xBigDecimal, int n) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        if (bigDecimal.equals(ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigDecimal.divide(y, roundingMode)");
        }
        if (!XBigDecimal.isRoundingMode(n)) {
            throw new IllegalArgumentException("Invalid rounding mode in XBigDecimal.divide(y, roundingMode)");
        }
        try {
            this.setValue(this.getValue().divide(bigDecimal, n));
        }
        catch (Exception exception) {
            throw new ArithmeticException("Invalid use of ROUND_UNNECESSARY in XBigDecimal.divide(y, roundingMode)");
        }
    }

    public static XBigDecimal divide(XBigDecimal xBigDecimal, XBigDecimal xBigDecimal2, int n) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        BigDecimal bigDecimal3 = bigDecimal = xBigDecimal2 == null ? ZERO : xBigDecimal2.getValue();
        if (bigDecimal.equals(ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigDecimal.divide(x, y, roundingMode)");
        }
        if (!XBigDecimal.isRoundingMode(n)) {
            throw new IllegalArgumentException("Invalid rounding mode in XBigDecimal.divide(x, y, roundingMode)");
        }
        try {
            return new XBigDecimal(bigDecimal2.divide(bigDecimal, n));
        }
        catch (Exception exception) {
            throw new ArithmeticException("Invalid use of ROUND_UNNECESSARY in XBigDecimal.divide(x, y, roundingMode)");
        }
    }

    public final void divide(XBigDecimal xBigDecimal, int n, int n2) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = bigDecimal = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        if (bigDecimal.equals(ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigDecimal.divide(y, scale, roundingMode)");
        }
        if (n < 0) {
            throw new ArithmeticException("Negative scale in XBigDecimal.divide(y, scale, roundingMode)");
        }
        if (!XBigDecimal.isRoundingMode(n2)) {
            throw new IllegalArgumentException("Invalid rounding mode in XBigDecimal.divide(y, scale, roundingMode)");
        }
        try {
            this.setValue(this.getValue().divide(bigDecimal, n, n2));
        }
        catch (Exception exception) {
            throw new ArithmeticException("Invalid use of ROUND_UNNECESSARY in XBigDecimal.divide(y, scale, roundingMode)");
        }
    }

    public static XBigDecimal divide(XBigDecimal xBigDecimal, XBigDecimal xBigDecimal2, int n, int n2) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = xBigDecimal == null ? ZERO : xBigDecimal.getValue();
        BigDecimal bigDecimal3 = bigDecimal = xBigDecimal2 == null ? ZERO : xBigDecimal2.getValue();
        if (bigDecimal.equals(ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigDecimal.divide(x, y, scale, roundingMode)");
        }
        if (n < 0) {
            throw new ArithmeticException("Negative scale in XBigDecimal.divide(x, y, scale, roundingMode)");
        }
        if (!XBigDecimal.isRoundingMode(n2)) {
            throw new IllegalArgumentException("Invalid rounding mode in XBigDecimal.divide(x, y, scale, roundingMode)");
        }
        try {
            return new XBigDecimal(bigDecimal2.divide(bigDecimal, n, n2));
        }
        catch (Exception exception) {
            throw new ArithmeticException("Invalid use of ROUND_UNNECESSARY in XBigDecimal.divide(x, y, scale, roundingMode)");
        }
    }

    public static boolean isRoundingMode(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public final int compareTo(XBigDecimal xBigDecimal) {
        if (xBigDecimal == null) {
            throw new NullPointerException("Null object passed to XBigDecimal.compareTo(XBigDecimal)");
        }
        return this.getValue().compareTo(xBigDecimal.getValue());
    }

    public final int compareTo(Object object) {
        if (object == null) {
            throw new ClassCastException("Null object passed to XBigDecimal.compareTo(Object)");
        }
        if (!(object instanceof XBigDecimal)) {
            throw new ClassCastException("Invalid object passed to XBigDecimal.compareTo(Object)");
        }
        return this.compareTo((XBigDecimal)object);
    }

    public static BigDecimal[] toPrimitiveArray(XBigDecimal[] xBigDecimalArray) {
        if (xBigDecimalArray == null) {
            return null;
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[xBigDecimalArray.length];
        int n = 0;
        while (n < bigDecimalArray.length) {
            if (xBigDecimalArray[n] != null) {
                bigDecimalArray[n] = xBigDecimalArray[n].getValue();
            }
            ++n;
        }
        return bigDecimalArray;
    }

    public static XBigDecimal[] toXArray(BigDecimal[] bigDecimalArray) {
        if (bigDecimalArray == null) {
            return null;
        }
        XBigDecimal[] xBigDecimalArray = new XBigDecimal[bigDecimalArray.length];
        int n = 0;
        while (n < xBigDecimalArray.length) {
            if (bigDecimalArray[n] != null) {
                xBigDecimalArray[n] = new XBigDecimal(bigDecimalArray[n]);
            }
            ++n;
        }
        return xBigDecimalArray;
    }
}

