/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.BaseShape;
import edu.neu.ccs.gui.ClosureMode;
import edu.neu.ccs.gui.Path;
import edu.neu.ccs.gui.WindingRule;
import edu.neu.ccs.util.FloatArray;

public class TweakableShape
extends BaseShape {
    public static final String SET_VERTEX = "set.vertex";
    public static final String SET_TANGENT = "set.tangent";
    public static final String SET_VERTEX_TANGENT = "set.vertex.tangent";
    public static final String ADD_VERTEX_TANGENT = "add.vertex.tangent";
    public static final String REMOVE_VERTEX_TANGENT = "remove.vertex.tangent";

    public TweakableShape() {
        this(null, null, null, null, null);
    }

    public TweakableShape(float[][] fArray) {
        this(fArray, null, null, null, null);
    }

    public TweakableShape(float[][] fArray, float[][] fArray2) {
        this(fArray, fArray2, null, null, null);
    }

    public TweakableShape(float[][] fArray, float[][] fArray2, Path.Strategy strategy) {
        this(fArray, fArray2, strategy, null, null);
    }

    public TweakableShape(float[][] fArray, float[][] fArray2, Path.Strategy strategy, ClosureMode closureMode) {
        this(fArray, fArray2, strategy, closureMode, null);
    }

    public TweakableShape(float[][] fArray, float[][] fArray2, Path.Strategy strategy, ClosureMode closureMode, WindingRule windingRule) {
        this.vertex = new float[0][2];
        this.tangent = new float[0][2];
        if (strategy == null) {
            strategy = Path.BEZIER_CUBIC;
        }
        this.setPathStrategy(strategy);
        this.setClosureMode(closureMode);
        this.setWindingRule(windingRule);
        this.setVertexTangentData(fArray, fArray2);
        this.makePath();
    }

    public final void setVertexData(float[][] fArray) {
        if (!FloatArray.checkArray(fArray, 2)) {
            return;
        }
        if (fArray.length != this.tangent.length) {
            return;
        }
        this.vertex = FloatArray.deepclone(fArray);
        this.makePath();
        this.firePropertyChange(SET_VERTEX, null, null);
    }

    public final void setTangentData(float[][] fArray) {
        if (fArray == null) {
            this.tangent = new float[this.vertex.length][2];
        } else {
            if (!FloatArray.checkArray(fArray, 2)) {
                return;
            }
            if (fArray.length != this.vertex.length) {
                return;
            }
            this.tangent = FloatArray.deepclone(fArray);
        }
        this.makePath();
        this.firePropertyChange(SET_TANGENT, null, null);
    }

    public final void setVertexTangentData(float[][] fArray, float[][] fArray2) {
        if (fArray == null) {
            this.vertex = new float[0][2];
            this.tangent = new float[0][2];
        } else {
            if (!FloatArray.checkArray(fArray, 2)) {
                return;
            }
            int n = fArray.length;
            if (fArray2 == null) {
                this.tangent = new float[n][2];
            } else {
                if (!FloatArray.checkArray(fArray2, 2)) {
                    return;
                }
                if (fArray2.length != n) {
                    return;
                }
                this.tangent = FloatArray.deepclone(fArray2);
            }
            this.vertex = FloatArray.deepclone(fArray);
        }
        this.makePath();
        this.firePropertyChange(SET_VERTEX_TANGENT, null, null);
    }

    public final void setVertexTangentData(float[][] fArray) {
        if (fArray == null) {
            this.vertex = new float[0][2];
            this.tangent = new float[0][2];
        } else {
            if (!FloatArray.checkArray(fArray, 4)) {
                return;
            }
            int n = fArray.length;
            this.vertex = new float[n][2];
            this.tangent = new float[n][2];
            int n2 = 0;
            while (n2 < n) {
                this.vertex[n2][0] = fArray[n2][0];
                this.vertex[n2][1] = fArray[n2][1];
                this.tangent[n2][0] = fArray[n2][2];
                this.tangent[n2][1] = fArray[n2][3];
                ++n2;
            }
        }
        this.makePath();
        this.firePropertyChange(SET_VERTEX_TANGENT, null, null);
    }

    public final void setVertex(int n, float f, float f2) {
        if (n < 0 || n >= this.vertex.length) {
            return;
        }
        this.vertex[n][0] = f;
        this.vertex[n][1] = f2;
        this.makePath();
        this.firePropertyChange(SET_VERTEX, null, null);
    }

    public final void setVertex(int n, float[] fArray) {
        if (fArray == null || fArray.length != 2) {
            return;
        }
        this.setVertex(n, fArray[0], fArray[1]);
    }

    public final void setTangent(int n, float f, float f2) {
        if (n < 0 || n >= this.vertex.length) {
            return;
        }
        this.tangent[n][0] = f;
        this.tangent[n][1] = f2;
        this.makePath();
        this.firePropertyChange(SET_TANGENT, null, null);
    }

    public final void setTangent(int n, float[] fArray) {
        if (fArray == null || fArray.length != 2) {
            return;
        }
        this.setTangent(n, fArray[0], fArray[1]);
    }

    public final void setTangentViaControlA(int n, float f, float f2) {
        if (n < 0 || n >= this.vertex.length) {
            return;
        }
        this.tangent[n][0] = f - this.vertex[n][0];
        this.tangent[n][1] = f2 - this.vertex[n][1];
        this.makePath();
        this.firePropertyChange(SET_TANGENT, null, null);
    }

    public final void setTangentViaControlA(int n, float[] fArray) {
        if (fArray == null || fArray.length != 2) {
            return;
        }
        this.setTangentViaControlA(n, fArray[0], fArray[1]);
    }

    public final void setTangentViaControlB(int n, float f, float f2) {
        if (n < 0 || n >= this.vertex.length) {
            return;
        }
        this.tangent[n][0] = this.vertex[n][0] - f;
        this.tangent[n][1] = this.vertex[n][1] - f2;
        this.makePath();
        this.firePropertyChange(SET_TANGENT, null, null);
    }

    public final void setTangentViaControlB(int n, float[] fArray) {
        if (fArray == null || fArray.length != 2) {
            return;
        }
        this.setTangentViaControlB(n, fArray[0], fArray[1]);
    }

    public final void setVertexTangent(int n, float f, float f2, float f3, float f4) {
        if (n < 0 || n >= this.vertex.length) {
            return;
        }
        this.vertex[n][0] = f;
        this.vertex[n][1] = f2;
        this.tangent[n][0] = f3;
        this.tangent[n][1] = f4;
        this.makePath();
        this.firePropertyChange(SET_VERTEX_TANGENT, null, null);
    }

    public final void setVertexTangent(int n, float[] fArray, float[] fArray2) {
        if (fArray == null || fArray.length != 2) {
            return;
        }
        if (fArray2 == null || fArray2.length != 2) {
            return;
        }
        this.setVertexTangent(n, fArray[0], fArray[1], fArray2[0], fArray2[1]);
    }

    public final void setVertexTangent(int n, float[] fArray) {
        if (fArray == null || fArray.length != 4) {
            return;
        }
        this.setVertexTangent(n, fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public final void addVertexTangent(int n, float f, float f2, float f3, float f4) {
        int n2 = this.vertex.length;
        int n3 = n2 + 1;
        if (n < 0) {
            n = 0;
        } else if (n > n2) {
            n = n2;
        }
        float[][] fArray = this.vertex;
        float[][] fArray2 = this.tangent;
        this.vertex = new float[n3][2];
        this.tangent = new float[n3][2];
        int n4 = 0;
        while (n4 < n) {
            this.vertex[n4][0] = fArray[n4][0];
            this.vertex[n4][1] = fArray[n4][1];
            this.tangent[n4][0] = fArray2[n4][0];
            this.tangent[n4][1] = fArray2[n4][1];
            ++n4;
        }
        this.vertex[n][0] = f;
        this.vertex[n][1] = f2;
        this.tangent[n][0] = f3;
        this.tangent[n][1] = f4;
        int n5 = n + 1;
        while (n5 < n3) {
            int n6 = n5 - 1;
            this.vertex[n5][0] = fArray[n6][0];
            this.vertex[n5][1] = fArray[n6][1];
            this.tangent[n5][0] = fArray2[n6][0];
            this.tangent[n5][1] = fArray2[n6][1];
            ++n5;
        }
        this.makePath();
        this.firePropertyChange(ADD_VERTEX_TANGENT, null, null);
    }

    public final void addVertexTangent(int n, float[] fArray, float[] fArray2) {
        if (fArray == null || fArray.length != 2) {
            return;
        }
        if (fArray2 == null || fArray2.length != 2) {
            return;
        }
        this.addVertexTangent(n, fArray[0], fArray[1], fArray2[0], fArray2[1]);
    }

    public final void addVertexTangent(int n, float[] fArray) {
        if (fArray == null || fArray.length != 4) {
            return;
        }
        this.addVertexTangent(n, fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public final void addVerticesTangents(int n, float[][] fArray, float[][] fArray2) {
        int n2;
        if (!FloatArray.checkArrayPair(fArray, fArray2, 2)) {
            return;
        }
        int n3 = fArray.length;
        if (n3 == 0) {
            return;
        }
        int n4 = this.vertex.length;
        int n5 = n4 + n3;
        float[][] fArray3 = this.vertex;
        float[][] fArray4 = this.tangent;
        this.vertex = new float[n5][2];
        this.tangent = new float[n5][2];
        if (n < 0) {
            n = 0;
        } else if (n > n4) {
            n = n4;
        }
        int n6 = 0;
        while (n6 < n) {
            this.vertex[n6][0] = fArray3[n6][0];
            this.vertex[n6][1] = fArray3[n6][1];
            this.tangent[n6][0] = fArray4[n6][0];
            this.tangent[n6][1] = fArray4[n6][1];
            ++n6;
        }
        int n7 = 0;
        while (n7 < n3) {
            n2 = n7 + n;
            this.vertex[n2][0] = fArray[n7][0];
            this.vertex[n2][1] = fArray[n7][1];
            this.tangent[n2][0] = fArray2[n7][0];
            this.tangent[n2][1] = fArray2[n7][1];
            ++n7;
        }
        n2 = n;
        while (n2 < n4) {
            int n8 = n2 + n3;
            this.vertex[n8][0] = fArray3[n2][0];
            this.vertex[n8][1] = fArray3[n2][1];
            this.tangent[n8][0] = fArray4[n2][0];
            this.tangent[n8][1] = fArray4[n2][1];
            ++n2;
        }
        this.makePath();
        this.firePropertyChange(ADD_VERTEX_TANGENT, null, null);
    }

    public final void addVerticesTangents(int n, float[][] fArray) {
        int n2;
        if (!FloatArray.checkArray(fArray, 4)) {
            return;
        }
        int n3 = fArray.length;
        if (n3 == 0) {
            return;
        }
        int n4 = this.vertex.length;
        int n5 = n4 + n3;
        float[][] fArray2 = this.vertex;
        float[][] fArray3 = this.tangent;
        this.vertex = new float[n5][2];
        this.tangent = new float[n5][2];
        if (n < 0) {
            n = 0;
        } else if (n > n4) {
            n = n4;
        }
        int n6 = 0;
        while (n6 < n) {
            this.vertex[n6][0] = fArray2[n6][0];
            this.vertex[n6][1] = fArray2[n6][1];
            this.tangent[n6][0] = fArray3[n6][0];
            this.tangent[n6][1] = fArray3[n6][1];
            ++n6;
        }
        int n7 = 0;
        while (n7 < n3) {
            n2 = n7 + n;
            this.vertex[n2][0] = fArray[n7][0];
            this.vertex[n2][1] = fArray[n7][1];
            this.tangent[n2][0] = fArray[n7][2];
            this.tangent[n2][1] = fArray[n7][3];
            ++n7;
        }
        n2 = n;
        while (n2 < n4) {
            int n8 = n2 + n3;
            this.vertex[n8][0] = fArray2[n2][0];
            this.vertex[n8][1] = fArray2[n2][1];
            this.tangent[n8][0] = fArray3[n2][0];
            this.tangent[n8][1] = fArray3[n2][1];
            ++n2;
        }
        this.makePath();
        this.firePropertyChange(ADD_VERTEX_TANGENT, null, null);
    }

    public final void appendVertexTangent(float f, float f2, float f3, float f4) {
        this.addVertexTangent(this.vertex.length, f, f2, f3, f4);
    }

    public final void appendVertexTangent(float[] fArray, float[] fArray2) {
        this.addVertexTangent(this.vertex.length, fArray, fArray2);
    }

    public final void appendVertexTangent(float[] fArray) {
        this.addVertexTangent(this.vertex.length, fArray);
    }

    public final void appendVerticesTangents(float[][] fArray, float[][] fArray2) {
        this.addVerticesTangents(this.vertex.length, fArray, fArray2);
    }

    public final void appendVerticesTangents(float[][] fArray) {
        this.addVerticesTangents(this.vertex.length, fArray);
    }

    public final float[] removeVertexTangent(int n) {
        int n2 = this.vertex.length;
        int n3 = n2 - 1;
        if (n < 0 || n >= n2) {
            return null;
        }
        float[][] fArray = this.vertex;
        float[][] fArray2 = this.tangent;
        this.vertex = new float[n3][2];
        this.tangent = new float[n3][2];
        int n4 = 0;
        while (n4 < n) {
            this.vertex[n4][0] = fArray[n4][0];
            this.vertex[n4][1] = fArray[n4][1];
            this.tangent[n4][0] = fArray2[n4][0];
            this.tangent[n4][1] = fArray2[n4][1];
            ++n4;
        }
        int n5 = n + 1;
        while (n5 < n2) {
            int n6 = n5 - 1;
            this.vertex[n6][0] = fArray[n5][0];
            this.vertex[n6][1] = fArray[n5][1];
            this.tangent[n6][0] = fArray2[n5][0];
            this.tangent[n6][1] = fArray2[n5][1];
            ++n5;
        }
        this.makePath();
        this.firePropertyChange(REMOVE_VERTEX_TANGENT, null, null);
        float f = fArray[n][0];
        float f2 = fArray[n][1];
        float f3 = fArray2[n][0];
        float f4 = fArray2[n][1];
        return new float[]{f, f2, f3, f4};
    }

    public final float[][] removeVerticesTangents(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.vertex.length;
        if (n < 0) {
            n = 0;
        }
        if (n2 > n5) {
            n2 = n5;
        }
        if ((n4 = n2 - n) <= 0) {
            return new float[0][4];
        }
        int n6 = n5 - n4;
        float[][] fArray = this.vertex;
        float[][] fArray2 = this.tangent;
        this.vertex = new float[n6][2];
        this.tangent = new float[n6][2];
        float[][] fArray3 = new float[n4][4];
        int n7 = 0;
        while (n7 < n) {
            this.vertex[n7][0] = fArray[n7][0];
            this.vertex[n7][1] = fArray[n7][1];
            this.tangent[n7][0] = fArray2[n7][0];
            this.tangent[n7][1] = fArray2[n7][1];
            ++n7;
        }
        int n8 = n;
        while (n8 < n2) {
            n3 = n8 - n;
            fArray3[n3][0] = fArray[n8][0];
            fArray3[n3][1] = fArray[n8][1];
            fArray3[n3][2] = fArray2[n8][0];
            fArray3[n3][3] = fArray2[n8][1];
            ++n8;
        }
        n3 = n2;
        while (n3 < n5) {
            int n9 = n3 - n4;
            this.vertex[n9][0] = fArray[n3][0];
            this.vertex[n9][1] = fArray[n3][1];
            this.tangent[n9][0] = fArray2[n3][0];
            this.tangent[n9][1] = fArray2[n3][1];
            ++n3;
        }
        this.makePath();
        this.firePropertyChange(REMOVE_VERTEX_TANGENT, null, null);
        return fArray3;
    }

    public final float[][] removeAllVerticesTangents() {
        return this.removeVerticesTangents(0, this.vertex.length);
    }
}

