/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.util.MathUtilities;
import java.awt.geom.AffineTransform;

public class TransformFactory {
    private TransformFactory() {
    }

    public static AffineTransform translate(double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(d, d2);
        return affineTransform;
    }

    public static AffineTransform rotate(double d, double d2, double d3) {
        AffineTransform affineTransform = new AffineTransform();
        double d4 = Math.toRadians(d3);
        affineTransform.translate(d, d2);
        affineTransform.rotate(d4);
        affineTransform.translate(-d, -d2);
        return affineTransform;
    }

    public static AffineTransform scale(double d, double d2, double d3, double d4, double d5) {
        AffineTransform affineTransform = new AffineTransform();
        double d6 = Math.toRadians(d3);
        affineTransform.translate(d, d2);
        affineTransform.rotate(d6);
        affineTransform.scale(d4, d5);
        affineTransform.rotate(-d6);
        affineTransform.translate(-d, -d2);
        return affineTransform;
    }

    public static AffineTransform shear(double d, double d2, double d3, double d4) {
        AffineTransform affineTransform = new AffineTransform();
        double d5 = Math.toRadians(d3);
        affineTransform.translate(d, d2);
        affineTransform.rotate(d5);
        affineTransform.shear(d4, 0.0);
        affineTransform.rotate(-d5);
        affineTransform.translate(-d, -d2);
        return affineTransform;
    }

    public static AffineTransform reflect(double d, double d2, double d3) {
        return TransformFactory.scale(d, d2, d3, 1.0, -1.0);
    }

    public static AffineTransform glide(double d, double d2) {
        double d3 = Math.toRadians(d);
        double d4 = d2 * Math.cos(d3);
        double d5 = d2 * Math.sin(d3);
        return TransformFactory.translate(d4, d5);
    }

    public static AffineTransform glidereflect(double d, double d2, double d3, double d4) {
        double d5 = Math.toRadians(d3);
        double d6 = d4 * Math.cos(d5);
        double d7 = d4 * Math.sin(d5);
        return TransformFactory.compose(new AffineTransform[]{TransformFactory.translate(d6, d7), TransformFactory.reflect(d, d2, d3)});
    }

    public static AffineTransform transform(double d, double d2, double d3, double d4, double d5, double d6) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setTransform(d, d2, d3, d4, d5, d6);
        return affineTransform;
    }

    public static AffineTransform centeredTransform(double d, double d2, AffineTransform affineTransform) {
        if (affineTransform == null) {
            return new AffineTransform();
        }
        return TransformFactory.compose(new AffineTransform[]{TransformFactory.translate(d, d2), affineTransform, TransformFactory.translate(-d, -d2)});
    }

    public static AffineTransform centeredTransform(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return TransformFactory.centeredTransform(d, d2, TransformFactory.transform(d3, d4, d5, d6, d7, d8));
    }

    public static AffineTransform compose(AffineTransform[] affineTransformArray) {
        AffineTransform affineTransform = new AffineTransform();
        if (affineTransformArray == null) {
            return affineTransform;
        }
        int n = affineTransformArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (affineTransformArray[n2] != null) {
                affineTransform.concatenate(affineTransformArray[n2]);
            }
            ++n2;
        }
        return affineTransform;
    }

    public static AffineTransform compose(AffineTransform affineTransform, AffineTransform affineTransform2) {
        return TransformFactory.compose(new AffineTransform[]{affineTransform, affineTransform2});
    }

    public static AffineTransform rotateAtOrigin(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            return new AffineTransform();
        }
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = d / d3;
        double d5 = d2 / d3;
        return new AffineTransform(d4, d5, -d5, d4, 0.0, 0.0);
    }

    public static AffineTransform rotateAtOrigin(double d, double d2, double d3, double d4) {
        return TransformFactory.rotateAtOrigin(d3 - d, d4 - d2);
    }

    public static AffineTransform rotateAtX1Y1(double d, double d2, double d3, double d4) {
        return TransformFactory.centeredTransform(d, d2, TransformFactory.rotateAtOrigin(d, d2, d3, d4));
    }

    public static AffineTransform rotateAtX2Y2(double d, double d2, double d3, double d4) {
        return TransformFactory.centeredTransform(d3, d4, TransformFactory.rotateAtOrigin(d, d2, d3, d4));
    }

    public static AffineTransform reflectAtOrigin(double d, double d2) {
        if (d2 == 0.0) {
            return new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        }
        if (d == 0.0) {
            return new AffineTransform(-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = d / d3;
        double d5 = d2 / d3;
        double d6 = d4 * d4 - d5 * d5;
        double d7 = 2.0 * d5 * d4;
        return new AffineTransform(d6, d7, d7, -d6, 0.0, 0.0);
    }

    public static AffineTransform reflectThroughLine(double d, double d2, double d3, double d4) {
        return TransformFactory.centeredTransform(d, d2, TransformFactory.reflectAtOrigin(d3 - d, d4 - d2));
    }

    public static AffineTransform randomTranslate(double d) {
        d = Math.abs(d);
        double d2 = MathUtilities.randomDouble(-d, d);
        double d3 = MathUtilities.randomDouble(-d, d);
        return TransformFactory.translate(d2, d3);
    }

    public static AffineTransform randomRotate(double d, double d2, double d3) {
        d3 = Math.abs(d3);
        double d4 = MathUtilities.randomDouble(-d3, d3);
        return TransformFactory.rotate(d, d2, d4);
    }

    public static AffineTransform randomTranslateRotate(double d, double d2, double d3, double d4) {
        return TransformFactory.compose(new AffineTransform[]{TransformFactory.randomTranslate(d3), TransformFactory.randomRotate(d, d2, d4)});
    }

    public static AffineTransform randomScale(double d, double d2, double d3, double d4) {
        d4 = Math.abs(d4);
        double d5 = MathUtilities.randomDouble(-d4, d4) + 1.0;
        double d6 = MathUtilities.randomDouble(-d4, d4) + 1.0;
        return TransformFactory.scale(d, d2, d3, d5, d6);
    }

    public static AffineTransform randomCenteredTransform(double d, double d2, double d3) {
        d3 = Math.abs(d3);
        double d4 = MathUtilities.randomDouble(-d3, d3) + 1.0;
        double d5 = MathUtilities.randomDouble(-d3, d3);
        double d6 = MathUtilities.randomDouble(-d3, d3);
        double d7 = MathUtilities.randomDouble(-d3, d3) + 1.0;
        double d8 = MathUtilities.randomDouble(-d3, d3);
        double d9 = MathUtilities.randomDouble(-d3, d3);
        return TransformFactory.centeredTransform(d, d2, d4, d5, d6, d7, d8, d9);
    }
}

