/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.Tile;
import java.awt.Paint;
import java.awt.geom.AffineTransform;

public class TileBox
extends Tile {
    public static final String SET_BORDER_SIZE = "set.border.size";
    protected int border = 0;

    public TileBox() {
    }

    public TileBox(Object o) {
        this.initializeTile(o, null, null);
    }

    public TileBox(Object o, Paint background) {
        this.initializeTile(o, background, null);
    }

    public TileBox(Object o, AffineTransform m) {
        this.initializeTile(o, null, m);
    }

    public TileBox(Object o, Paint background, AffineTransform m) {
        this.initializeTile(o, background, m);
    }

    public TileBox(Object o, int border) {
        this.initializeTileBox(o, null, null, border);
    }

    public TileBox(Object o, Paint background, int border) {
        this.initializeTileBox(o, background, null, border);
    }

    public TileBox(Object o, AffineTransform m, int border) {
        this.initializeTileBox(o, null, m, border);
    }

    public TileBox(Object o, Paint background, AffineTransform m, int border) {
        this.initializeTileBox(o, background, m, border);
    }

    public void initializeTileBox(Object o, Paint background, AffineTransform m, int border) {
        this.initializeTile(o, background, m);
        this.setBorderSize(border);
    }

    public XRect getActualBounds2D() {
        if (this.paintable == null) {
            return null;
        }
        XRect rect = this.paintable.getBounds2D();
        if (this.border == 0) {
            return rect;
        }
        double x = rect.getX();
        double y = rect.getY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        double b = this.border;
        double t = 2.0 * b;
        return new XRect(x - b, y - b, w + t, h + t);
    }

    public boolean originalContains(double x, double y) {
        if (this.paintable == null) {
            return false;
        }
        return this.getActualBounds2D().contains(x, y);
    }

    public void setBorderSize(int border) {
        if (border < 0) {
            border = 0;
        }
        if (border == this.border) {
            return;
        }
        this.border = border;
        this.firePropertyChange(SET_BORDER_SIZE, null, null);
    }

    public int getBorderSize() {
        return this.border;
    }
}

