/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.ComponentFactory;
import edu.neu.ccs.gui.Paintable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;

public class Tile
extends AbstractPaintable {
    public static final String SET_BACKGROUND_PAINT = "set.background.paint";
    protected Paintable paintable = null;
    protected Paint background = null;

    public Tile() {
    }

    public Tile(Object object) {
        this.initializeTile(object, null, null);
    }

    public Tile(Object object, Paint paint) {
        this.initializeTile(object, paint, null);
    }

    public Tile(Object object, AffineTransform affineTransform) {
        this.initializeTile(object, null, affineTransform);
    }

    public Tile(Object object, Paint paint, AffineTransform affineTransform) {
        this.initializeTile(object, paint, affineTransform);
    }

    public void initializeTile(Object object, Paint paint, AffineTransform affineTransform) {
        this.setPaintable(object);
        this.setBackgroundPaint(paint);
        this.setMutator(affineTransform);
    }

    public void originalPaint(Graphics graphics) {
        XRect xRect;
        if (graphics == null || this.paintable == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.background != null && (xRect = this.getActualBounds2D()) != null) {
            graphics2D.setPaint(this.background);
            graphics2D.fill(xRect);
        }
        this.paintable.paint(graphics2D);
    }

    public XRect getActualBounds2D() {
        if (this.paintable == null) {
            return null;
        }
        return this.paintable.getBounds2D();
    }

    public boolean originalContains(double d, double d2) {
        if (this.paintable == null) {
            return false;
        }
        return this.paintable.contains(d, d2);
    }

    public Paintable makePaintable(Object object) {
        return ComponentFactory.makePaintable(object);
    }

    public void setPaintable(Object object) {
        Paintable paintable = this.makePaintable(object);
        if (paintable == this.paintable) {
            return;
        }
        this.removeAndAddForwardingListener(this.paintable, paintable);
        this.paintable = paintable;
        this.firePropertyChange("set.paintable", null, null);
    }

    public Paintable getPaintable() {
        return this.paintable;
    }

    public final void setBackgroundPaint(Paint paint) {
        if (paint == this.background) {
            return;
        }
        this.background = paint;
        this.firePropertyChange(SET_BACKGROUND_PAINT, null, null);
    }

    public final Paint getBackgroundPaint() {
        return this.background;
    }
}

