/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.util.FloatArray;

public class Tangent {
    private static final int minTerms = 1;
    private static final int maxTerms = 7;
    private static final Strategy standardBezierStrategy = Tangent.bezierStrategy(7);

    private Tangent() {
    }

    public static Strategy bezierStrategy() {
        return standardBezierStrategy;
    }

    public static Strategy bezierStrategy(int n) {
        int n2 = n < 1 ? 1 : n;
        return new 1(n2);
    }

    public static float[][] bezierTangents(float[][] fArray, int n) {
        if (!FloatArray.checkArray(fArray, 2)) {
            return new float[0][2];
        }
        int n2 = fArray.length;
        float[][] fArray2 = new float[n2][2];
        if (n2 <= 2) {
            return fArray2;
        }
        float[] fArray3 = Tangent.bezierCoefficients(n2, n);
        int n3 = fArray3.length - 1;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 1;
            while (n5 <= n3) {
                int n6 = n4 + n5;
                int n7 = n4 - n5;
                if (n6 >= n2) {
                    n6 -= n2;
                }
                if (n7 < 0) {
                    n7 += n2;
                }
                float[] fArray4 = fArray2[n4];
                fArray4[0] = fArray4[0] + fArray3[n5] * (fArray[n6][0] - fArray[n7][0]);
                float[] fArray5 = fArray2[n4];
                fArray5[1] = fArray5[1] + fArray3[n5] * (fArray[n6][1] - fArray[n7][1]);
                ++n5;
            }
            ++n4;
        }
        return fArray2;
    }

    public static float[][] bezierTangents(float[][] fArray, float[][] fArray2, int n) {
        if (!FloatArray.checkArray(fArray2, 2) || fArray2.length != 2) {
            return Tangent.bezierTangents(fArray, n);
        }
        if (!FloatArray.checkArray(fArray, 2)) {
            return new float[0][2];
        }
        int n2 = fArray.length;
        int n3 = n2 - 1;
        float[][] fArray3 = new float[n2][2];
        if (n2 > 0) {
            fArray3[0][0] = fArray2[0][0];
            fArray3[0][1] = fArray2[0][1];
        }
        if (n2 > 1) {
            fArray3[n3][0] = fArray2[1][0];
            fArray3[n3][1] = fArray2[1][1];
        }
        if (n2 <= 2) {
            return fArray3;
        }
        float[][] fArray4 = FloatArray.deepclone(fArray);
        fArray4[0][0] = fArray[0][0] + fArray3[0][0];
        fArray4[0][1] = fArray[0][1] + fArray3[0][1];
        fArray4[n3][0] = fArray[n3][0] - fArray3[n3][0];
        fArray4[n3][1] = fArray[n3][1] - fArray3[n3][1];
        int n4 = 2 * n3;
        float[] fArray5 = Tangent.bezierCoefficients(n4, n);
        int n5 = fArray5.length - 1;
        int n6 = 1;
        while (n6 < n3) {
            int n7 = 1;
            while (n7 <= n5) {
                int n8 = n6 + n7;
                int n9 = n6 - n7;
                if (n8 >= n2) {
                    n8 = n4 - n8;
                }
                if (n9 < 0) {
                    n9 = -n9;
                }
                float[] fArray6 = fArray3[n6];
                fArray6[0] = fArray6[0] + fArray5[n7] * (fArray4[n8][0] - fArray4[n9][0]);
                float[] fArray7 = fArray3[n6];
                fArray7[1] = fArray7[1] + fArray5[n7] * (fArray4[n8][1] - fArray4[n9][1]);
                ++n7;
            }
            ++n6;
        }
        return fArray3;
    }

    public static float[] bezierCoefficients(int n, int n2) {
        if (n <= 2) {
            return new float[0];
        }
        int n3 = (n - 1) / 2;
        if (n2 < 1) {
            n2 = 1;
        }
        if (n3 > n2) {
            n3 = n2;
        }
        float[] fArray = new float[n3 + 1];
        float[] fArray2 = new float[n3 + 1];
        fArray2[0] = 1.0f;
        fArray2[1] = n % 2 == 1 ? -3 : -4;
        int n4 = 2;
        while (n4 <= n3) {
            fArray2[n4] = -4.0f * fArray2[n4 - 1] - fArray2[n4 - 2];
            ++n4;
        }
        int n5 = 1;
        while (n5 <= n3) {
            fArray[n5] = -fArray2[n3 - n5] / fArray2[n3];
            ++n5;
        }
        return fArray;
    }

    public static Strategy chordStrategy(float f) {
        return new 2(f);
    }

    public static float[][] chordTangents(float[][] fArray, float f) {
        if (!FloatArray.checkArray(fArray, 2)) {
            return new float[0][2];
        }
        int n = fArray.length;
        float[][] fArray2 = new float[n][2];
        if (n <= 2) {
            return fArray2;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 1;
            int n4 = n2 - 1;
            if (n3 >= n) {
                n3 -= n;
            }
            if (n4 < 0) {
                n4 += n;
            }
            fArray2[n2][0] = f * (fArray[n3][0] - fArray[n4][0]);
            fArray2[n2][1] = f * (fArray[n3][1] - fArray[n4][1]);
            ++n2;
        }
        return fArray2;
    }

    public static float[][] chordTangents(float[][] fArray, float[][] fArray2, float f) {
        if (!FloatArray.checkArray(fArray2, 2) || fArray2.length != 2) {
            return Tangent.chordTangents(fArray, f);
        }
        if (!FloatArray.checkArray(fArray, 2)) {
            return new float[0][2];
        }
        int n = fArray.length;
        int n2 = n - 1;
        float[][] fArray3 = new float[n][2];
        if (n > 0) {
            fArray3[0][0] = fArray2[0][0];
            fArray3[0][1] = fArray2[0][1];
        }
        if (n > 1) {
            fArray3[n2][0] = fArray2[1][0];
            fArray3[n2][1] = fArray2[1][1];
        }
        if (n <= 2) {
            return fArray3;
        }
        int n3 = 1;
        while (n3 < n2) {
            int n4 = n3 + 1;
            int n5 = n3 - 1;
            fArray3[n3][0] = f * (fArray[n4][0] - fArray[n5][0]);
            fArray3[n3][1] = f * (fArray[n4][1] - fArray[n5][1]);
            ++n3;
        }
        return fArray3;
    }

    public static interface Strategy {
        public float[][] makeTangents(float[][] var1);

        public float[][] makeTangents(float[][] var1, float[][] var2);
    }

    private static final class 1
    implements Strategy {
        private final /* synthetic */ int val$t;

        public float[][] makeTangents(float[][] fArray) {
            return Tangent.bezierTangents(fArray, this.val$t);
        }

        public float[][] makeTangents(float[][] fArray, float[][] fArray2) {
            return Tangent.bezierTangents(fArray, fArray2, this.val$t);
        }

        /* synthetic */ 1(int n) {
            this.val$t = n;
        }
    }

    private static final class 2
    implements Strategy {
        private final /* synthetic */ float val$factor;

        public float[][] makeTangents(float[][] fArray) {
            return Tangent.chordTangents(fArray, this.val$factor);
        }

        public float[][] makeTangents(float[][] fArray, float[][] fArray2) {
            return Tangent.chordTangents(fArray, fArray2, this.val$factor);
        }

        /* synthetic */ 2(float f) {
            this.val$factor = f;
        }
    }
}

