/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XPoint2D;
import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.Mutator;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableSequence;
import edu.neu.ccs.gui.PlotMark;
import edu.neu.ccs.gui.PlotMarkAlgorithm;
import edu.neu.ccs.gui.TransformFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class PointPaintable
extends AbstractPaintable {
    private static final XPoint2D ORIGIN = new XPoint2D();
    public static final String SET_PLOTMARK = "set.plotmark";
    public static final String SET_PAINT = "set.paint";
    private XPoint2D point = new XPoint2D();
    private PlotMark plotmark = new PlotMark();
    private Paint paint = Color.black;

    public PointPaintable() {
    }

    public PointPaintable(double x, double y, PlotMark pm, Paint paint) {
        this.setPoint(x, y);
        this.setPlotMark(pm);
        this.setPaint(paint);
    }

    public PointPaintable(Point2D p, PlotMark pm, Paint paint) {
        this.setPoint(p);
        this.setPlotMark(pm);
        this.setPaint(paint);
    }

    public PointPaintable(double[] data, PlotMark pm, Paint paint) {
        this.setPoint(data);
        this.setPlotMark(pm);
        this.setPaint(paint);
    }

    public PointPaintable(float[] data, PlotMark pm, Paint paint) {
        this.setPoint(data);
        this.setPlotMark(pm);
        this.setPaint(paint);
    }

    public void originalPaint(Graphics g) {
        Graphics2D h = (Graphics2D)g;
        Paint oldpaint = h.getPaint();
        h.setPaint(this.paint);
        this.plotmark.mark(h, ORIGIN);
        h.setPaint(oldpaint);
    }

    public XRect getActualBounds2D() {
        int size;
        Paintable paintable = this.plotmark.getPaintable();
        if (paintable != null) {
            return paintable.getActualBounds2D();
        }
        PlotMarkAlgorithm algorithm = this.plotmark.getAlgorithm();
        Shape shape = algorithm.makeShape(0.0, 0.0, size = this.plotmark.getSize());
        if (shape == null) {
            return null;
        }
        return new XRect(shape.getBounds2D());
    }

    public XPoint2D getOriginalCenter() {
        XPoint2D center = this.getDefaultOriginalCenter();
        if (center != null) {
            return center;
        }
        Paintable paintable = this.plotmark.getPaintable();
        if (paintable != null) {
            return paintable.getOriginalCenter();
        }
        return new XPoint2D();
    }

    public boolean originalContains(double x, double y) {
        int size;
        Paintable paintable = this.plotmark.getPaintable();
        if (paintable != null) {
            return paintable.originalContains(x, y);
        }
        PlotMarkAlgorithm algorithm = this.plotmark.getAlgorithm();
        Shape shape = algorithm.makeShape(0.0, 0.0, size = this.plotmark.getSize());
        if (shape == null) {
            return false;
        }
        return shape.contains(x, y);
    }

    public void setPoint(double x, double y) {
        this.point.setValue(x, y);
        super.setMutator(TransformFactory.translate(x, y));
    }

    public void setPoint(Point2D p) {
        if (p != null) {
            this.setPoint(p.getX(), p.getY());
        }
    }

    public void setPoint(double[] data) {
        if (data != null && data.length == 2) {
            this.setPoint(data[0], data[1]);
        }
    }

    public void setPoint(float[] data) {
        if (data != null && data.length == 2) {
            this.setPoint(data[0], data[1]);
        }
    }

    public void setPlotMark(PlotMark pm) {
        if (pm != null && pm != this.plotmark) {
            Paintable paintable = this.plotmark.getPaintable();
            if (paintable != null) {
                this.removeForwardingListener(paintable);
            }
            this.plotmark = pm;
            paintable = this.plotmark.getPaintable();
            if (paintable != null) {
                this.addForwardingListener(paintable);
            }
            this.firePropertyChange(SET_PLOTMARK, null, null);
        }
    }

    public void setPlotMark(PlotMarkAlgorithm algorithm, int size, boolean fill) {
        if (algorithm != null) {
            this.setPlotMark(new PlotMark(algorithm, size, fill));
        }
    }

    public void setPlotMark(Paintable paintable) {
        if (paintable != null) {
            this.setPlotMark(new PlotMark(paintable));
        }
    }

    public void setPaint(Paint paint) {
        if (paint != null) {
            this.paint = paint;
        }
    }

    public XPoint2D getPoint() {
        return new XPoint2D(this.point);
    }

    public PlotMark getPlotMark() {
        return this.plotmark;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setMutator(AffineTransform M) {
        if (M == null) {
            return;
        }
        double x = M.getTranslateX();
        double y = M.getTranslateY();
        this.setPoint(x, y);
    }

    public void setMutator(Mutator.Strategy strategy) {
        super.setMutator(strategy);
    }

    public static PointPaintable[] makePointPaintableArray(Point2D[] points, PlotMark pm, Paint paint) {
        if (points == null) {
            return null;
        }
        int N = points.length;
        int i = 0;
        while (i < N) {
            if (points[i] == null) {
                return null;
            }
            ++i;
        }
        PointPaintable[] result = new PointPaintable[N];
        int i2 = 0;
        while (i2 < N) {
            result[i2] = new PointPaintable(points[i2], pm, paint);
            ++i2;
        }
        return result;
    }

    public static PointPaintable[] makePointPaintableArray(double[][] points, PlotMark pm, Paint paint) {
        if (points == null) {
            return null;
        }
        int N = points.length;
        int i = 0;
        while (i < N) {
            if (points[i] == null) {
                return null;
            }
            if (points[i].length != 2) {
                return null;
            }
            ++i;
        }
        PointPaintable[] result = new PointPaintable[N];
        int i2 = 0;
        while (i2 < N) {
            result[i2] = new PointPaintable(points[i2], pm, paint);
            ++i2;
        }
        return result;
    }

    public static PointPaintable[] makePointPaintableArray(float[][] points, PlotMark pm, Paint paint) {
        if (points == null) {
            return null;
        }
        int N = points.length;
        int i = 0;
        while (i < N) {
            if (points[i] == null) {
                return null;
            }
            if (points[i].length != 2) {
                return null;
            }
            ++i;
        }
        PointPaintable[] result = new PointPaintable[N];
        int i2 = 0;
        while (i2 < N) {
            result[i2] = new PointPaintable(points[i2], pm, paint);
            ++i2;
        }
        return result;
    }

    public static PaintableSequence makePaintableSequence(Point2D[] points, PlotMark pm, Paint paint) {
        Object[] array = PointPaintable.makePointPaintableArray(points, pm, paint);
        if (array == null) {
            return null;
        }
        return new PaintableSequence(array);
    }

    public static PaintableSequence makePaintableSequence(double[][] points, PlotMark pm, Paint paint) {
        Object[] array = PointPaintable.makePointPaintableArray(points, pm, paint);
        if (array == null) {
            return null;
        }
        return new PaintableSequence(array);
    }

    public static PaintableSequence makePaintableSequence(float[][] points, PlotMark pm, Paint paint) {
        Object[] array = PointPaintable.makePointPaintableArray(points, pm, paint);
        if (array == null) {
            return null;
        }
        return new PaintableSequence(array);
    }
}

