/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.ComponentFactory;
import edu.neu.ccs.gui.Mutator;
import edu.neu.ccs.gui.Paintable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.Vector;

public class PaintableSequence
extends AbstractPaintable {
    private Vector paintablesequence = new Vector(16);
    private Mutator.StrategyUsage usage = Mutator.MUTATE_AS_ITEMS;

    public PaintableSequence() {
        this(null, null);
    }

    public PaintableSequence(Object[] objectArray) {
        this(objectArray, null);
    }

    public PaintableSequence(Object[] objectArray, Mutator.StrategyUsage strategyUsage) {
        this.appendSequence(objectArray);
        this.setMutatorStrategyUsage(strategyUsage);
    }

    public final void originalPaint(Graphics graphics) {
        if (graphics == null || !this.isVisible()) {
            return;
        }
        int n = this.length();
        if (n == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n2 = n - 1;
        while (n2 >= 0) {
            Paintable paintable = this.getPaintable(n2);
            if (paintable != null) {
                paintable.paint(graphics2D);
            }
            --n2;
        }
    }

    public final XRect getActualBounds2D() {
        XRect xRect = null;
        int n = this.length();
        int n2 = 0;
        while (n2 < n) {
            XRect xRect2;
            Paintable paintable = this.getPaintable(n2);
            if (paintable != null && (xRect2 = paintable.getBounds2D()) != null && !(xRect2.getWidth() <= 0.0) && !(xRect2.getHeight() <= 0.0)) {
                xRect = xRect == null ? xRect2 : xRect.createUnionRect(xRect2);
            }
            ++n2;
        }
        return xRect;
    }

    public final boolean originalContains(double d, double d2) {
        return this.hitsItem(d, d2) != null;
    }

    public final void setMutator(AffineTransform affineTransform) {
        if (affineTransform == null) {
            return;
        }
        try {
            AffineTransform affineTransform2 = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return;
        }
        int n = this.length();
        int n2 = 0;
        while (n2 < n) {
            Paintable paintable = this.getPaintable(n2);
            if (paintable != null) {
                paintable.setMutator(affineTransform);
            }
            ++n2;
        }
    }

    public void addPreMutation(AffineTransform affineTransform) {
        if (affineTransform == null) {
            return;
        }
        try {
            AffineTransform affineTransform2 = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return;
        }
        int n = this.length();
        int n2 = 0;
        while (n2 < n) {
            Paintable paintable = this.getPaintable(n2);
            if (paintable != null) {
                paintable.addPreMutation(affineTransform);
            }
            ++n2;
        }
    }

    public void addPostMutation(AffineTransform affineTransform) {
        if (affineTransform == null) {
            return;
        }
        try {
            AffineTransform affineTransform2 = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return;
        }
        int n = this.length();
        int n2 = 0;
        while (n2 < n) {
            Paintable paintable = this.getPaintable(n2);
            if (paintable != null) {
                paintable.addPostMutation(affineTransform);
            }
            ++n2;
        }
    }

    public void setMutator(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        if (this.usage == Mutator.MUTATE_AS_ITEMS) {
            int n = this.length();
            int n2 = 0;
            while (n2 < n) {
                Paintable paintable = this.getPaintable(n2);
                if (paintable != null) {
                    paintable.setMutator(strategy);
                }
                ++n2;
            }
        } else {
            this.setMutator(strategy.mutator(this.getOriginalCenter()));
        }
    }

    public final void addPreMutation(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        if (this.usage == Mutator.MUTATE_AS_ITEMS) {
            int n = this.length();
            int n2 = 0;
            while (n2 < n) {
                Paintable paintable = this.getPaintable(n2);
                if (paintable != null) {
                    paintable.addPreMutation(strategy);
                }
                ++n2;
            }
        } else {
            this.addPreMutation(strategy.mutator(this.getOriginalCenter()));
        }
    }

    public final void addPostMutation(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        if (this.usage == Mutator.MUTATE_AS_ITEMS) {
            int n = this.length();
            int n2 = 0;
            while (n2 < n) {
                Paintable paintable = this.getPaintable(n2);
                if (paintable != null) {
                    paintable.addPostMutation(strategy);
                }
                ++n2;
            }
        } else {
            this.addPostMutation(strategy.mutator(this.getCenter()));
        }
    }

    public Paintable makePaintable(Object object) {
        return ComponentFactory.makePaintable(object);
    }

    public final int length() {
        return this.paintablesequence.size();
    }

    public final Paintable setPaintable(int n, Object object) {
        Paintable paintable;
        if (n < 0 || n >= this.length()) {
            return null;
        }
        Paintable paintable2 = this.makePaintable(object);
        if (paintable2 != (paintable = this.getPaintable(n))) {
            this.removeAndAddForwardingListener(paintable, paintable2);
            this.paintablesequence.set(n, paintable2);
            this.firePropertyChange("set.paintable", null, null);
        }
        return paintable2;
    }

    public final Paintable setPaintable(Object object, int n) {
        return this.setPaintable(n, object);
    }

    public final Paintable getPaintable(int n) {
        if (n < 0 || n >= this.length()) {
            return null;
        }
        return (Paintable)this.paintablesequence.get(n);
    }

    public final int getIndex(Paintable paintable) {
        int n = -1;
        if (paintable == null) {
            return n;
        }
        int n2 = this.length();
        int n3 = 0;
        while (n3 < n2) {
            if (paintable == this.getPaintable(n3)) {
                n = n3;
                break;
            }
            ++n3;
        }
        return n;
    }

    public final Paintable addPaintable(int n, Object object) {
        int n2 = this.length();
        if (n < 0) {
            n = 0;
        }
        if (n > n2) {
            n = n2;
        }
        Paintable paintable = this.makePaintable(object);
        this.addForwardingListener(paintable);
        this.paintablesequence.add(n, paintable);
        this.firePropertyChange("set.paintable", null, null);
        return paintable;
    }

    public final Paintable addPaintable(Object object, int n) {
        return this.addPaintable(n, object);
    }

    public final Paintable addPaintable(Object object) {
        return this.addPaintable(0, object);
    }

    public final Paintable addPaintableAtTop(Object object) {
        return this.addPaintable(0, object);
    }

    public final Paintable appendPaintable(Object object) {
        return this.addPaintable(Integer.MAX_VALUE, object);
    }

    public final Paintable[] setSequence(Object[] objectArray) {
        this.clear();
        return this.appendSequence(objectArray);
    }

    public final Paintable[] addSequence(int n, Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        int n2 = objectArray.length;
        Paintable[] paintableArray = new Paintable[n2];
        int n3 = this.length();
        if (n < 0) {
            n = 0;
        }
        if (n > n3) {
            n = n3;
        }
        if (n2 > 0) {
            int n4 = 0;
            while (n4 < n2) {
                paintableArray[n4] = this.makePaintable(objectArray[n4]);
                this.addForwardingListener(paintableArray[n4]);
                this.paintablesequence.add(n + n4, paintableArray[n4]);
                ++n4;
            }
            this.firePropertyChange("set.paintable", null, null);
        }
        return paintableArray;
    }

    public final Paintable[] addSequence(Object[] objectArray, int n) {
        return this.addSequence(n, objectArray);
    }

    public final Paintable[] addSequence(Object[] objectArray) {
        return this.addSequence(0, objectArray);
    }

    public final Paintable[] addSequenceAtTop(Object[] objectArray) {
        return this.addSequence(0, objectArray);
    }

    public final Paintable[] appendSequence(Object[] objectArray) {
        return this.addSequence(Integer.MAX_VALUE, objectArray);
    }

    public final Paintable removePaintable(int n) {
        if (n < 0 || n >= this.length()) {
            return null;
        }
        Paintable paintable = (Paintable)this.paintablesequence.get(n);
        this.removeForwardingListener(paintable);
        this.paintablesequence.remove(n);
        this.firePropertyChange("remove.paintable", null, null);
        return paintable;
    }

    public final void removePaintable(Paintable paintable) {
        this.removePaintable(this.getIndex(paintable));
    }

    public final Paintable[] removeSequence(int n, int n2) {
        int n3;
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.length()) {
            n2 = this.length();
        }
        if ((n3 = n2 - n) <= 0) {
            return new Paintable[0];
        }
        Paintable[] paintableArray = new Paintable[n3];
        while (n2 > n) {
            Paintable paintable = (Paintable)this.paintablesequence.get(--n2);
            this.removeForwardingListener(paintable);
            this.paintablesequence.remove(n2);
            paintableArray[--n3] = paintable;
        }
        this.firePropertyChange("remove.paintable", null, null);
        return paintableArray;
    }

    public final Paintable[] clearSequence() {
        return this.removeSequence(0, Integer.MAX_VALUE);
    }

    public final Paintable[] clear() {
        return this.removeSequence(0, Integer.MAX_VALUE);
    }

    public final void shiftPaintable(int n, int n2) {
        int n3 = this.length();
        if (n < 0 || n >= n3) {
            return;
        }
        if (n2 < 0 || n2 >= n3) {
            return;
        }
        if (n == n2) {
            return;
        }
        if (n2 > n) {
            --n2;
        }
        Paintable paintable = (Paintable)this.paintablesequence.get(n);
        this.paintablesequence.remove(n);
        this.paintablesequence.add(n2, paintable);
        this.firePropertyChange("shift.paintable", null, null);
    }

    public final void shiftPaintableToTop(int n) {
        this.shiftPaintable(n, 0);
    }

    public final void shiftPaintableToBottom(int n) {
        this.shiftPaintable(n, this.length() - 1);
    }

    public final void shiftPaintableUp(int n) {
        this.shiftPaintable(n, n - 1);
    }

    public final void shiftPaintableDown(int n) {
        this.shiftPaintable(n, n + 1);
    }

    public final void shiftPaintable(Paintable paintable, int n) {
        this.shiftPaintable(this.getIndex(paintable), n);
    }

    public final void shiftPaintableToTop(Paintable paintable) {
        this.shiftPaintable(this.getIndex(paintable), 0);
    }

    public final void shiftPaintableToBottom(Paintable paintable) {
        this.shiftPaintable(this.getIndex(paintable), this.length() - 1);
    }

    public final void shiftPaintableUp(Paintable paintable) {
        int n = this.getIndex(paintable);
        this.shiftPaintable(n, n - 1);
    }

    public final void shiftPaintableDown(Paintable paintable) {
        int n = this.getIndex(paintable);
        this.shiftPaintable(n, n + 1);
    }

    public final Paintable[] toArray() {
        return this.paintablesequence.toArray(new Paintable[0]);
    }

    public final void setMutatorStrategyUsage(Mutator.StrategyUsage strategyUsage) {
        if (strategyUsage != null) {
            this.usage = strategyUsage;
        }
    }

    public final Mutator.StrategyUsage getMutatorStrategyUsage() {
        return this.usage;
    }

    public final void setMutateAsGroup() {
        this.usage = Mutator.MUTATE_AS_GROUP;
    }

    public final void setMutateAsItems() {
        this.usage = Mutator.MUTATE_AS_ITEMS;
    }

    public final Paintable hits(double d, double d2) {
        Paintable paintable = this.hitsItem(d, d2);
        if (paintable == null) {
            return null;
        }
        if (this.usage == Mutator.MUTATE_AS_ITEMS) {
            return paintable;
        }
        return this;
    }

    public final Paintable hits(Point2D point2D) {
        if (point2D == null) {
            return null;
        }
        return this.hits(point2D.getX(), point2D.getY());
    }

    public final Paintable hitsItem(double d, double d2) {
        return this.getPaintable(this.hitsItemAtIndex(d, d2));
    }

    public final Paintable hitsItem(Point2D point2D) {
        if (point2D == null) {
            return null;
        }
        return this.hitsItem(point2D.getX(), point2D.getY());
    }

    public final int hitsItemAtIndex(double d, double d2) {
        int n = this.length();
        if (n == 0 || !this.possiblyContains(d, d2)) {
            return -1;
        }
        int n2 = 0;
        while (n2 < n) {
            Paintable paintable = this.getPaintable(n2);
            if (paintable != null && paintable.contains(d, d2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public final int hitsItemAtIndex(Point2D point2D) {
        if (point2D == null) {
            return -1;
        }
        return this.hitsItemAtIndex(point2D.getX(), point2D.getY());
    }
}

