/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.PaintMode;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableSequenceComposite;
import edu.neu.ccs.gui.ShapePaintable;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PaintBar
extends PaintableSequenceComposite {
    private int number = 0;
    private int diameter = 0;
    private int gap = 0;
    private int base = 0;
    private int center = 0;
    private int skip = 0;
    private Rectangle2D.Double bounds;

    public PaintBar(Paint[] paintArray, int n, int n2, int n3) {
        if (paintArray == null) {
            throw new NullPointerException("PaintBar constructor error: paints array is null");
        }
        int n4 = paintArray.length;
        if (n4 == 0) {
            throw new NullPointerException("PaintBar constructor error: paints array has no data");
        }
        if (n < 5) {
            n = 5;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.diameter = n;
        this.gap = n2;
        this.base = n2 / 2;
        this.skip = n + n2;
        this.center = this.skip / 2;
        int n5 = this.xCorner(0);
        int n6 = this.yCorner(0);
        int n7 = 0;
        while (n7 < n4) {
            if (paintArray[n7] != null) {
                if (n3 == 0) {
                    n5 = this.xCorner(n7);
                } else {
                    n6 = this.yCorner(n7);
                }
                this.installPaint(paintArray[n7], n5, n6, n);
            }
            ++n7;
        }
        if (this.number == 0) {
            throw new NullPointerException("PaintBar constructor error: paints array has only null data");
        }
        this.bounds = n3 == 0 ? new Rectangle2D.Double(0.0, 0.0, this.skip * n4, this.skip) : new Rectangle2D.Double(0.0, 0.0, this.skip, this.skip * n4);
        this.getPaintableSequence().setDefaultBounds2D(this.bounds);
    }

    public PaintBar(Paint[][] paintArray, int n, int n2) {
        if (paintArray == null) {
            throw new NullPointerException("PaintBar constructor error: paints array is null");
        }
        int n3 = paintArray.length;
        if (n3 == 0) {
            throw new NullPointerException("PaintBar constructor error: paints array has no data");
        }
        int n4 = 0;
        if (n < 5) {
            n = 5;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.diameter = n;
        this.gap = n2;
        this.base = n2 / 2;
        this.skip = n + n2;
        this.center = this.skip / 2;
        int n5 = 0;
        while (n5 < n3) {
            if (paintArray[n5] != null) {
                int n6 = this.yCorner(n5);
                int n7 = paintArray[n5].length;
                n4 = Math.max(n4, n7);
                int n8 = 0;
                while (n8 < n7) {
                    if (paintArray[n5][n8] != null) {
                        int n9 = this.xCorner(n8);
                        this.installPaint(paintArray[n5][n8], n9, n6, n);
                    }
                    ++n8;
                }
            }
            ++n5;
        }
        if (this.number == 0) {
            throw new NullPointerException("PaintBar constructor error: paints array has only null data");
        }
        this.bounds = new Rectangle2D.Double(0.0, 0.0, this.skip * n4, this.skip * n3);
        this.getPaintableSequence().setDefaultBounds2D(this.bounds);
    }

    public int getPaintCount() {
        return this.number;
    }

    public Paint getPaint(int n, int n2) {
        return this.hitsPaint(this.xCenter(n2), this.yCenter(n));
    }

    public void setPaint(int n, int n2, Paint paint) {
        int n3;
        if (paint == null) {
            return;
        }
        int n4 = this.xCenter(n2);
        if (!this.bounds.contains(n4, n3 = this.yCenter(n))) {
            return;
        }
        Paintable paintable = this.getPaintableSequence().hits(n4, n3);
        if (paintable == null) {
            n4 = this.xCorner(n2);
            n3 = this.yCorner(n);
            this.installPaint(paint, n4, n3, this.diameter);
        } else {
            ShapePaintable shapePaintable = (ShapePaintable)paintable;
            shapePaintable.setFillPaint(paint);
        }
    }

    public Paint hitsPaint(double d, double d2) {
        Paintable paintable = this.getPaintableSequence().hits(d, d2);
        if (paintable == null) {
            return null;
        }
        ShapePaintable shapePaintable = (ShapePaintable)paintable;
        return shapePaintable.getFillPaint();
    }

    public Paint hitsPaint(Point2D point2D) {
        if (point2D == null) {
            return null;
        }
        return this.hitsPaint(point2D.getX(), point2D.getY());
    }

    public int diameter() {
        return this.diameter;
    }

    public int gap() {
        return this.gap;
    }

    public int xCorner(int n) {
        return this.base + n * this.skip;
    }

    public int yCorner(int n) {
        return this.base + n * this.skip;
    }

    public int xCenter(int n) {
        return this.center + n * this.skip;
    }

    public int yCenter(int n) {
        return this.center + n * this.skip;
    }

    protected ShapePaintable getShapePaintable(int n) {
        if (n < 0 || n >= this.getPaintCount()) {
            return null;
        }
        return (ShapePaintable)this.getPaintableSequence().getPaintable(n);
    }

    private void installPaint(Paint paint, int n, int n2, int n3) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(n, n2, n3, n3);
        ShapePaintable shapePaintable = new ShapePaintable(double_, PaintMode.FILL, paint);
        this.getPaintableSequence().appendPaintable(shapePaintable);
        ++this.number;
    }
}

