/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.TransformFactory;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImagePaintable
extends AbstractPaintable {
    public static final String SET_IMAGE = "set.image";
    public static final String SET_TOP_LEFT_CORNER = "set.top.left.corner";
    private Image image = null;
    private double xCorner = 0.0;
    private double yCorner = 0.0;
    private int width = 0;
    private int height = 0;

    public ImagePaintable() {
    }

    public ImagePaintable(Image image) {
        this.setImage(image);
    }

    public ImagePaintable(Image image, Point2D point2D) {
        this.setImage(image);
        this.setTopLeftCorner(point2D);
    }

    public ImagePaintable(Image image, double d, double d2) {
        this.setImage(image);
        this.setTopLeftCorner(d, d2);
    }

    public ImagePaintable(ImageIcon imageIcon) {
        this.setImageByImageIcon(imageIcon);
    }

    public ImagePaintable(ImageIcon imageIcon, Point2D point2D) {
        this.setImageByImageIcon(imageIcon);
        this.setTopLeftCorner(point2D);
    }

    public ImagePaintable(ImageIcon imageIcon, double d, double d2) {
        this.setImageByImageIcon(imageIcon);
        this.setTopLeftCorner(d, d2);
    }

    public ImagePaintable(String string) {
        this.setImageByFileName(string);
    }

    public ImagePaintable(String string, Point2D point2D) {
        this.setImageByFileName(string);
        this.setTopLeftCorner(point2D);
    }

    public ImagePaintable(String string, double d, double d2) {
        this.setImageByFileName(string);
        this.setTopLeftCorner(d, d2);
    }

    public ImagePaintable(URL uRL) {
        this.setImageByURL(uRL);
    }

    public ImagePaintable(URL uRL, Point2D point2D) {
        this.setImageByURL(uRL);
        this.setTopLeftCorner(point2D);
    }

    public ImagePaintable(URL uRL, double d, double d2) {
        this.setImageByURL(uRL);
        this.setTopLeftCorner(d, d2);
    }

    public final void originalPaint(Graphics graphics) {
        if (this.image == null || graphics == null || !this.isVisible()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        AffineTransform affineTransform = TransformFactory.translate(this.xCorner, this.yCorner);
        graphics2D.drawImage(this.image, affineTransform, null);
    }

    public final XRect getActualBounds2D() {
        if (this.image == null) {
            return null;
        }
        return new XRect(this.xCorner, this.yCorner, this.width, this.height);
    }

    public final boolean originalContains(double d, double d2) {
        if (this.width <= 0 || this.height <= 0) {
            return false;
        }
        return this.possiblyContains(d, d2);
    }

    public final void setImage(Image image) {
        if (image == this.image) {
            return;
        }
        this.removeAndAddForwardingListener(this.image, image);
        this.image = image;
        this.setImageSizeParameters();
    }

    public final void setImageByImageIcon(ImageIcon imageIcon) {
        if (imageIcon == null) {
            this.setImage(null);
        } else {
            this.setImage(imageIcon.getImage());
        }
    }

    public final void setImageByFileName(String string) {
        if (string == null) {
            this.setImage(null);
        } else {
            this.setImageByImageIcon(new ImageIcon(string));
        }
    }

    public final void setImageByURL(URL uRL) {
        if (uRL == null) {
            this.setImage(null);
        } else {
            this.setImageByImageIcon(new ImageIcon(uRL));
        }
    }

    public final Image getImage() {
        return this.image;
    }

    public final void setTopLeftCorner(Point2D point2D) {
        if (point2D == null) {
            return;
        }
        this.setTopLeftCorner(point2D.getX(), point2D.getY());
    }

    public final void setTopLeftCorner(double d, double d2) {
        if (d != this.xCorner || d2 != this.yCorner) {
            this.xCorner = d;
            this.yCorner = d2;
            this.firePropertyChange(SET_TOP_LEFT_CORNER, null, null);
        }
    }

    public final Point2D getTopLeftCorner() {
        return new Point2D.Double(this.xCorner, this.yCorner);
    }

    public final int getImageWidth() {
        return this.width;
    }

    public final int getImageHeight() {
        return this.height;
    }

    private final void setImageSizeParameters() {
        if (this.image == null) {
            this.width = 0;
            this.height = 0;
        } else {
            JPanel jPanel = new JPanel();
            this.width = this.image.getWidth(jPanel);
            this.height = this.image.getHeight(jPanel);
        }
        this.firePropertyChange(SET_IMAGE, null, null);
    }
}

