/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Strings;
import edu.neu.ccs.codec.CodecUtilities;
import edu.neu.ccs.gui.AlertEvent;
import edu.neu.ccs.gui.AlertListener;
import edu.neu.ccs.gui.ComponentFactory;
import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.gui.Fragile;
import edu.neu.ccs.gui.GeneralDialog;
import edu.neu.ccs.gui.JPTComponent;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.MalformedDataEvent;
import edu.neu.ccs.gui.MalformedDataListener;
import edu.neu.ccs.gui.Refresh;
import edu.neu.ccs.util.DimensionUtilities;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DisplayPanel
extends JPanel
implements Displayable,
MalformedDataListener,
JPTConstants {
    public static final String CODEC = "codec";
    protected Color background = SystemColor.control;
    protected String codec = CodecUtilities.getDefaultCodec();

    public DisplayPanel() {
    }

    public DisplayPanel(boolean bl) {
        super(bl);
    }

    public DisplayPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public DisplayPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
    }

    public Displayable[] getDisplayables() {
        Object object;
        int n = 0;
        int n2 = 0;
        while (n2 < this.getComponentCount()) {
            object = this.getComponent(n2);
            if (object instanceof Displayable) {
                ++n;
            }
            ++n2;
        }
        object = new Displayable[n];
        n = 0;
        int n3 = 0;
        while (n3 < this.getComponentCount()) {
            Component component = this.getComponent(n3);
            if (component instanceof Displayable) {
                object[n++] = (Displayable)((Object)component);
            }
            ++n3;
        }
        return object;
    }

    public void setViewState(String string) {
        if (string == null) {
            return;
        }
        this.setViewStates(Strings.decode(string));
    }

    public void setViewStates(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        Displayable[] displayableArray = this.getDisplayables();
        int n = Math.min(stringArray.length, displayableArray.length);
        int n2 = 0;
        while (n2 < n) {
            displayableArray[n2].setViewState(stringArray[n2]);
            ++n2;
        }
        this.firePropertyChange("view.state", null, null);
    }

    public String getViewState() {
        return CodecUtilities.encode(this.getViewStates(), this.getCodec());
    }

    public String[] getViewStates() {
        Displayable[] displayableArray = this.getDisplayables();
        int n = displayableArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = displayableArray[n2].getViewState();
            ++n2;
        }
        return stringArray;
    }

    public void setDefaultViewState(String string) {
        if (string == null) {
            return;
        }
        this.setDefaultViewStates(Strings.decode(string));
    }

    public void setDefaultViewStates(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        Displayable[] displayableArray = this.getDisplayables();
        int n = Math.min(stringArray.length, displayableArray.length);
        int n2 = 0;
        while (n2 < n) {
            displayableArray[n2].setDefaultViewState(stringArray[n2]);
            ++n2;
        }
        this.firePropertyChange("default.view.state", null, null);
    }

    public String getDefaultViewState() {
        return CodecUtilities.encode(this.getDefaultViewStates(), this.getCodec());
    }

    public String[] getDefaultViewStates() {
        Displayable[] displayableArray = this.getDisplayables();
        int n = displayableArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = displayableArray[n2].getDefaultViewState();
            ++n2;
        }
        return stringArray;
    }

    public void setEnabled(boolean bl) {
        int n = 0;
        while (n < this.getComponentCount()) {
            this.getComponent(n).setEnabled(bl);
            ++n;
        }
        super.setEnabled(bl);
    }

    public void reset() {
        Displayable[] displayableArray = this.getDisplayables();
        int n = displayableArray.length;
        int n2 = 0;
        while (n2 < n) {
            displayableArray[n2].reset();
            ++n2;
        }
    }

    public void dataMalformed(MalformedDataEvent malformedDataEvent) {
        if (malformedDataEvent.isAlertOn()) {
            this.startAlert(malformedDataEvent);
        } else {
            this.endAlert(malformedDataEvent);
        }
    }

    public void startAlert(AlertEvent alertEvent) {
        this.background = this.getBackground();
        this.setBackground(SystemColor.textHighlight);
        int n = 0;
        while (n < this.getComponentCount()) {
            Component component = this.getComponent(n);
            if (component instanceof AlertListener) {
                AlertListener alertListener = (AlertListener)((Object)component);
                alertListener.startAlert(alertEvent);
            }
            ++n;
        }
    }

    public void endAlert(AlertEvent alertEvent) {
        this.setBackground(this.background);
        int n = 0;
        while (n < this.getComponentCount()) {
            Component component = this.getComponent(n);
            if (component instanceof AlertListener) {
                AlertListener alertListener = (AlertListener)((Object)component);
                alertListener.endAlert(alertEvent);
            }
            ++n;
        }
    }

    public void setDeepBackground(Color color) {
        this.setBackground(color);
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component != null) {
                JComponent jComponent;
                if (component instanceof DisplayPanel) {
                    jComponent = (DisplayPanel)component;
                    ((DisplayPanel)jComponent).setDeepBackground(color);
                } else if (component instanceof JPTComponent) {
                    jComponent = (JPTComponent)component;
                    ((JPTComponent)jComponent).setDeepBackground(color);
                } else {
                    component.setBackground(color);
                }
            }
            ++n2;
        }
    }

    public void setDeepBackground(Color color, Class clazz) {
        if (clazz == null) {
            return;
        }
        if (clazz.isInstance(this)) {
            this.setBackground(color);
        }
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component != null) {
                JComponent jComponent;
                if (component instanceof DisplayPanel) {
                    jComponent = (DisplayPanel)component;
                    ((DisplayPanel)jComponent).setDeepBackground(color, clazz);
                } else if (component instanceof JPTComponent) {
                    jComponent = (JPTComponent)component;
                    ((JPTComponent)jComponent).setDeepBackground(color, clazz);
                } else if (clazz.isInstance(component)) {
                    component.setBackground(color);
                }
            }
            ++n2;
        }
    }

    public Component add(Component component) {
        return this.add(component, -1);
    }

    public Component add(Component component, int n) {
        super.add(component, n);
        if (component != null && component instanceof Fragile) {
            Fragile fragile = (Fragile)((Object)component);
            fragile.addMalformedDataListener(this);
        }
        this.revalidate();
        return component;
    }

    public void add(Component component, Object object) {
        super.add(component, object);
        if (component != null && component instanceof Fragile) {
            Fragile fragile = (Fragile)((Object)component);
            fragile.addMalformedDataListener(this);
        }
        this.revalidate();
    }

    public void add(Component component, Object object, int n) {
        super.add(component, object, n);
        if (component != null && component instanceof Fragile) {
            Fragile fragile = (Fragile)((Object)component);
            fragile.addMalformedDataListener(this);
        }
        this.revalidate();
    }

    public Component add(String string, Component component) {
        super.add(string, component);
        if (component != null && component instanceof Fragile) {
            Fragile fragile = (Fragile)((Object)component);
            fragile.addMalformedDataListener(this);
        }
        this.revalidate();
        return component;
    }

    public Component addObject(Object object) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component);
        }
        return component;
    }

    public Component addObject(Object object, int n) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component, n);
        }
        return component;
    }

    public Component addObject(Object object, Object object2) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component, object2);
        }
        return component;
    }

    public Component addObject(Object object, Object object2, int n) {
        Component component = this.makeComponent(object);
        if (component != null) {
            this.add(component, object2, n);
        }
        return component;
    }

    public Component makeComponent(Object object) {
        return ComponentFactory.makeComponent(object);
    }

    public void remove(Component component) {
        super.remove(component);
        if (component != null && component instanceof Fragile) {
            Fragile fragile = (Fragile)((Object)component);
            fragile.removeMalformedDataListener(this);
        }
        this.revalidate();
    }

    public void remove(int n) {
        try {
            try {
                Component component = this.getComponent(n);
                if (component != null && component instanceof Fragile) {
                    Fragile fragile = (Fragile)((Object)component);
                    fragile.removeMalformedDataListener(this);
                }
            }
            catch (Exception exception) {
            }
            Object var3_4 = null;
            super.remove(n);
            this.revalidate();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            super.remove(n);
            this.revalidate();
            throw throwable;
        }
    }

    public void removeAll() {
        while (this.getComponentCount() > 0) {
            this.remove(0);
        }
    }

    public void uniformizeSize() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        JComponent jComponent = null;
        Dimension dimension = new Dimension();
        int n2 = 0;
        while (n2 < n) {
            if (componentArray[n2] instanceof JComponent) {
                jComponent = (JComponent)componentArray[n2];
                dimension = DimensionUtilities.max(dimension, jComponent.getPreferredSize());
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            if (componentArray[n3] instanceof JComponent) {
                jComponent = (JComponent)componentArray[n3];
                jComponent.setPreferredSize(dimension);
            }
            ++n3;
        }
    }

    public void uniformizeWidth() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        JComponent jComponent = null;
        Dimension dimension = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (componentArray[n3] instanceof JComponent) {
                jComponent = (JComponent)componentArray[n3];
                dimension = jComponent.getPreferredSize();
                n2 = Math.max(n2, (int)dimension.getWidth());
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            if (componentArray[n4] instanceof JComponent) {
                jComponent = (JComponent)componentArray[n4];
                dimension = jComponent.getPreferredSize();
                dimension.setSize(n2, (int)dimension.getHeight());
                jComponent.setPreferredSize(dimension);
            }
            ++n4;
        }
    }

    public void uniformizeHeight() {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        JComponent jComponent = null;
        Dimension dimension = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (componentArray[n3] instanceof JComponent) {
                jComponent = (JComponent)componentArray[n3];
                dimension = jComponent.getPreferredSize();
                n2 = Math.max(n2, (int)dimension.getHeight());
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            if (componentArray[n4] instanceof JComponent) {
                jComponent = (JComponent)componentArray[n4];
                dimension = jComponent.getPreferredSize();
                dimension.setSize((int)dimension.getWidth(), n2);
                jComponent.setPreferredSize(dimension);
            }
            ++n4;
        }
    }

    public void setCodec(String string) {
        String string2 = this.getCodec();
        if (string != null) {
            this.codec = string;
        }
        if (this.getCodec() != string2) {
            this.firePropertyChange(CODEC, string2, this.getCodec());
        }
    }

    public String getCodec() {
        return this.codec;
    }

    public JPTFrame frame() {
        return this.frame(null, 0, null);
    }

    public JPTFrame frame(int n) {
        return this.frame(null, n, null);
    }

    public JPTFrame frame(String string) {
        return this.frame(string, 0, null);
    }

    public JPTFrame frame(String string, int n) {
        return this.frame(string, n, null);
    }

    public JPTFrame frame(String string, Insets insets) {
        return this.frame(string, 0, insets);
    }

    public JPTFrame frame(String string, int n, Insets insets) {
        return JPTFrame.frame(this, string, n, insets);
    }

    public GeneralDialog OKDialog() {
        return this.OKDialog(null);
    }

    public GeneralDialog OKDialog(String string) {
        GeneralDialog generalDialog = GeneralDialog.makeOKDialog(this, string);
        generalDialog.setVisible(true);
        return generalDialog;
    }

    public GeneralDialog OKCancelDialog() {
        return this.OKCancelDialog(null);
    }

    public GeneralDialog OKCancelDialog(String string) {
        GeneralDialog generalDialog = GeneralDialog.makeOKCancelDialog(this, string);
        generalDialog.setVisible(true);
        return generalDialog;
    }

    public GeneralDialog YesNoCancelDialog() {
        return this.YesNoCancelDialog(null);
    }

    public GeneralDialog YesNoCancelDialog(String string) {
        GeneralDialog generalDialog = GeneralDialog.makeYesNoCancelDialog(this, string);
        generalDialog.setVisible(true);
        return generalDialog;
    }

    public GeneralDialog generalDialog(Object[][] objectArray) {
        return this.generalDialog(null, objectArray, null);
    }

    public GeneralDialog generalDialog(Object[][] objectArray, Object object) {
        return this.generalDialog(null, objectArray, object);
    }

    public GeneralDialog generalDialog(String string, Object[][] objectArray) {
        return this.generalDialog(string, objectArray, null);
    }

    public GeneralDialog generalDialog(String string, Object[][] objectArray, Object object) {
        GeneralDialog generalDialog = new GeneralDialog((Object)this, string, objectArray, object);
        generalDialog.setVisible(true);
        return generalDialog;
    }

    public void refreshComponent() {
        Refresh.packParentWindow(this);
    }
}

