/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Displayable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class DisplayCollection
extends DisplayPanel {
    public static final int DEFAULT_ORIENTATION = 1;
    protected int direction = 1;
    protected DisplayPanel inner = new DisplayPanel();

    public DisplayCollection() {
        this(null, 1);
    }

    public DisplayCollection(int n) {
        this(null, n);
    }

    public DisplayCollection(Displayable[] displayableArray) {
        this(displayableArray, 1);
    }

    public DisplayCollection(Displayable[] displayableArray, int n) {
        this.setLayout(new BorderLayout());
        super.add((Component)this.inner, "North");
        super.add((Component)new JPanel(), "Center");
        this.setOrientation(n);
        if (displayableArray != null) {
            int n2 = 0;
            while (n2 < displayableArray.length) {
                this.add((Component)((Object)displayableArray[n2]));
                ++n2;
            }
        }
    }

    public void setViewState(String string) {
        this.inner.setViewState(string);
        this.firePropertyChange("view.state", null, string);
    }

    public String getViewState() {
        return this.inner.getViewState();
    }

    public void setDefaultViewState(String string) {
        this.inner.setDefaultViewState(string);
        this.firePropertyChange("default.view.state", null, string);
    }

    public String getDefaultViewState() {
        return this.inner.getDefaultViewState();
    }

    public void reset() {
        this.inner.reset();
    }

    public Component add(Component component) {
        this.inner.add(component);
        this.revalidate();
        return component;
    }

    public Component add(Component component, int n) {
        this.inner.add(component, n);
        this.revalidate();
        return component;
    }

    public void add(Component component, Object object) {
        this.inner.add(component, object);
        this.revalidate();
    }

    public void add(Component component, Object object, int n) {
        this.inner.add(component, object, n);
        this.revalidate();
    }

    public Component add(String string, Component component) {
        this.inner.add(string, component);
        this.revalidate();
        return component;
    }

    public void remove(Component component) {
        this.inner.remove(component);
        this.revalidate();
    }

    public void remove(int n) {
        this.inner.remove(n);
        this.revalidate();
    }

    public void removeAll() {
        this.inner.removeAll();
        this.revalidate();
    }

    public Component getItem(int n) {
        return this.inner.getComponent(n);
    }

    public Component[] getItemArray() {
        return this.inner.getComponents();
    }

    public int getItemCount() {
        return this.inner.getComponentCount();
    }

    public void setOrientation(int n) {
        int n2 = this.getOrientation();
        switch (n) {
            case 0: 
            case 1: {
                this.direction = n;
                break;
            }
            case -1: {
                this.direction = 1;
                break;
            }
            default: {
                return;
            }
        }
        switch (this.direction) {
            case 0: {
                this.inner.setLayout(new BoxLayout(this.inner, 0));
                break;
            }
            default: {
                this.inner.setLayout(new BoxLayout(this.inner, 1));
            }
        }
        this.revalidate();
        if (this.getOrientation() != n2) {
            this.firePropertyChange("orientation", n2, this.getOrientation());
        }
    }

    public int getOrientation() {
        return this.direction;
    }

    public DisplayPanel getCollectionPanel() {
        return this.inner;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        int n = 0;
        while (n < this.getComponentCount()) {
            Component component = this.getComponent(n);
            component.setBackground(color);
            ++n;
        }
    }
}

