/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.Annotation;
import edu.neu.ccs.gui.ImagePaintable;
import edu.neu.ccs.gui.PaintSwatch;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableComponent;
import edu.neu.ccs.gui.PaintableSequence;
import edu.neu.ccs.gui.PathList;
import edu.neu.ccs.gui.PointPaintable;
import edu.neu.ccs.gui.ShapePaintable;
import edu.neu.ccs.gui.TextPaintable;
import java.awt.Component;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ComponentFactory {
    public static Component makeComponent(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Component) {
            return (Component)object;
        }
        if (object instanceof String) {
            return new Annotation((String)object);
        }
        if (object instanceof Icon) {
            return new Annotation((Icon)object);
        }
        if (object instanceof Action) {
            return new JButton((Action)object);
        }
        if (object instanceof Paint) {
            return new PaintSwatch((Paint)object);
        }
        Paintable paintable = ComponentFactory.makePaintable(object);
        if (paintable instanceof Paintable) {
            return new PaintableComponent(paintable);
        }
        return null;
    }

    public static Icon makeIcon(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Icon) {
            return (Icon)object;
        }
        if (object instanceof Paint) {
            return new PaintSwatch((Paint)object);
        }
        Paintable paintable = ComponentFactory.makePaintable(object);
        if (paintable instanceof Paintable) {
            return new PaintableComponent(paintable);
        }
        return null;
    }

    public static Paintable makePaintable(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Paintable) {
            return (Paintable)object;
        }
        if (object instanceof Image) {
            return new ImagePaintable((Image)object);
        }
        if (object instanceof ImageIcon) {
            return new ImagePaintable((ImageIcon)object);
        }
        if (object instanceof PathList) {
            object = ((PathList)object).makeShape();
        }
        if (object instanceof Shape) {
            return new ShapePaintable((Shape)object);
        }
        if (object instanceof String) {
            return new TextPaintable((String)object);
        }
        if (object instanceof Point2D) {
            PointPaintable pointPaintable = new PointPaintable();
            pointPaintable.setPoint((Point2D)object);
            return pointPaintable;
        }
        if (object instanceof Object[]) {
            return new PaintableSequence((Object[])object);
        }
        return null;
    }
}

