/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ClosureMode;
import edu.neu.ccs.gui.Path;
import edu.neu.ccs.gui.PolygonDotsShape;
import edu.neu.ccs.gui.PolygonShape;
import edu.neu.ccs.gui.PropertyChangeForwardingListener;
import edu.neu.ccs.gui.SupportsPropertyChange;
import edu.neu.ccs.gui.TweakableShape;
import edu.neu.ccs.gui.WindingRule;
import edu.neu.ccs.util.Bezier;
import edu.neu.ccs.util.FloatArray;
import edu.neu.ccs.util.Metric;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class BaseShape
implements Shape,
SupportsPropertyChange {
    public static final String SET_PATH_STRATEGY = "set.path.strategy";
    public static final String SET_CLOSURE_MODE = "set.closure.mode";
    public static final String SET_WINDING_RULE = "set.winding.rule";
    public static final String REMOVE_SHAPE_DATA = "remove.shape.data";
    protected float[][] vertex = new float[0][2];
    protected float[][] tangent = null;
    private GeneralPath path = new GeneralPath(1);
    private Path.Strategy pathstrategy = Path.POLYGON;
    private ClosureMode closuremode = ClosureMode.CLOSED;
    private WindingRule windingrule = WindingRule.WIND_NON_ZERO;
    private final PropertyChangeSupport changeAdapter = new PropertyChangeSupport(this);
    private final PropertyChangeForwardingListener forwardingListener = new PropertyChangeForwardingListener(this);

    protected BaseShape() {
    }

    public final int length() {
        return this.vertex.length;
    }

    public final boolean isTangentNull() {
        return this.tangent == null;
    }

    public final float getVX(int n) {
        int n2 = this.vertex.length;
        if (n < 0 || n >= n2) {
            return 0.0f;
        }
        return this.vertex[n][0];
    }

    public final float getVY(int n) {
        int n2 = this.vertex.length;
        if (n < 0 || n >= n2) {
            return 0.0f;
        }
        return this.vertex[n][1];
    }

    public final float[] getVertex(int n) {
        return new float[]{this.getVX(n), this.getVY(n)};
    }

    public final float getTX(int n) {
        if (this.tangent == null) {
            return 0.0f;
        }
        int n2 = this.vertex.length;
        if (n < 0 || n >= n2) {
            return 0.0f;
        }
        return this.tangent[n][0];
    }

    public final float getTY(int n) {
        if (this.tangent == null) {
            return 0.0f;
        }
        int n2 = this.vertex.length;
        if (n < 0 || n >= n2) {
            return 0.0f;
        }
        return this.tangent[n][1];
    }

    public final float[] getTangent(int n) {
        return new float[]{this.getTX(n), this.getTY(n)};
    }

    public final float getAX(int n) {
        return this.getVX(n) + this.getTX(n);
    }

    public final float getAY(int n) {
        return this.getVY(n) + this.getTY(n);
    }

    public final float[] getControlA(int n) {
        return new float[]{this.getAX(n), this.getAY(n)};
    }

    public final float getBX(int n) {
        return this.getVX(n) - this.getTX(n);
    }

    public final float getBY(int n) {
        return this.getVY(n) - this.getTY(n);
    }

    public final float[] getControlB(int n) {
        return new float[]{this.getBX(n), this.getBY(n)};
    }

    public final float[] getVertexTangent(int n) {
        return new float[]{this.getVX(n), this.getVY(n), this.getTX(n), this.getTY(n)};
    }

    public final float[][] getVertexData() {
        int n = this.vertex.length;
        float[][] fArray = new float[n][];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = this.getVertex(n2);
            ++n2;
        }
        return fArray;
    }

    public final float[][] getTangentData() {
        int n = this.vertex.length;
        float[][] fArray = new float[n][];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = this.getTangent(n2);
            ++n2;
        }
        return fArray;
    }

    public final float[][] getVertexTangentData() {
        int n = this.vertex.length;
        float[][] fArray = new float[n][];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = this.getVertexTangent(n2);
            ++n2;
        }
        return fArray;
    }

    public final float[] getPolygonPoint(float f) {
        int n = this.vertex.length;
        if (n == 0) {
            return new float[2];
        }
        if (n == 1 || f <= 0.0f || f >= (float)n) {
            return this.getVertex(0);
        }
        int n2 = (int)f;
        float f2 = f - (float)n2;
        if (f2 == 0.0f) {
            return this.getVertex(n2);
        }
        int n3 = (n2 + 1) % n;
        float f3 = this.getVX(n2);
        float f4 = this.getVX(n3);
        float f5 = this.getVY(n2);
        float f6 = this.getVY(n3);
        return new float[]{Bezier.bezierF(f2, f3, f4), Bezier.bezierF(f2, f5, f6)};
    }

    public final float[] getCubicCurvePoint(float f) {
        int n = this.vertex.length;
        if (n == 0) {
            return new float[2];
        }
        if (n == 1 || f <= 0.0f || f >= (float)n) {
            return this.getVertex(0);
        }
        int n2 = (int)f;
        float f2 = f - (float)n2;
        if (f2 == 0.0f) {
            return this.getVertex(n2);
        }
        int n3 = (n2 + 1) % n;
        float f3 = this.getVX(n2);
        float f4 = this.getVX(n3);
        float f5 = f3 + this.getTX(n2);
        float f6 = f4 - this.getTX(n3);
        float f7 = this.getVY(n2);
        float f8 = this.getVY(n3);
        float f9 = f7 + this.getTY(n2);
        float f10 = f8 - this.getTY(n3);
        return new float[]{Bezier.bezierF(f2, f3, f5, f6, f4), Bezier.bezierF(f2, f7, f9, f10, f8)};
    }

    public final int findVertex(double d, double d2, double d3) {
        return this.findVertex(d, d2, d3, Metric.MAX);
    }

    public final int findVertex(double d, double d2, double d3, Metric metric) {
        if (metric == null) {
            metric = Metric.MAX;
        }
        int n = this.vertex.length;
        int n2 = 0;
        while (n2 < n) {
            if (metric.isNear(d, d2, this.getVX(n2), this.getVY(n2), d3)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public final int findControlA(double d, double d2, double d3) {
        return this.findControlA(d, d2, d3, Metric.MAX);
    }

    public final int findControlA(double d, double d2, double d3, Metric metric) {
        if (metric == null) {
            metric = Metric.MAX;
        }
        int n = this.vertex.length;
        int n2 = 0;
        while (n2 < n) {
            if (metric.isNear(d, d2, this.getAX(n2), this.getAY(n2), d3)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public final int findControlB(double d, double d2, double d3) {
        return this.findControlB(d, d2, d3, Metric.MAX);
    }

    public final int findControlB(double d, double d2, double d3, Metric metric) {
        if (metric == null) {
            metric = Metric.MAX;
        }
        int n = this.vertex.length;
        int n2 = 0;
        while (n2 < n) {
            if (metric.isNear(d, d2, this.getBX(n2), this.getBY(n2), d3)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void setPathStrategy(Path.Strategy strategy) {
        if (strategy == null || strategy == this.pathstrategy) {
            return;
        }
        this.pathstrategy = strategy;
        this.makePath();
        this.firePropertyChange(SET_PATH_STRATEGY, null, null);
    }

    public final Path.Strategy getPathStrategy() {
        return this.pathstrategy;
    }

    public final void setClosureMode(ClosureMode closureMode) {
        if (closureMode == null || closureMode == this.closuremode) {
            return;
        }
        this.closuremode = closureMode;
        this.makePath();
        this.firePropertyChange(SET_CLOSURE_MODE, null, null);
    }

    public final ClosureMode getClosureMode() {
        return this.closuremode;
    }

    public final void setWindingRule(WindingRule windingRule) {
        if (windingRule == null || windingRule == this.windingrule) {
            return;
        }
        this.windingrule = windingRule;
        this.makePath();
        this.firePropertyChange(SET_WINDING_RULE, null, null);
    }

    public final void setWindingRule(int n) {
        if (n == 1) {
            this.setWindingRule(WindingRule.WIND_NON_ZERO);
        } else if (n == 0) {
            this.setWindingRule(WindingRule.WIND_EVEN_ODD);
        }
    }

    public final WindingRule getWindingRule() {
        return this.windingrule;
    }

    public final void removeShapeData() {
        this.vertex = new float[0][2];
        if (this.tangent != null) {
            this.tangent = new float[0][2];
        }
        this.makePath();
        this.firePropertyChange(REMOVE_SHAPE_DATA, null, null);
    }

    public final GeneralPath getPath() {
        return this.pathstrategy.makePath(this.vertex, this.tangent, this.closuremode, this.windingrule);
    }

    protected void makePath() {
        this.path = this.getPath();
    }

    public final PolygonShape makeClosedPolygon() {
        return new PolygonShape(this.getVertexData(), ClosureMode.CLOSED, this.getWindingRule());
    }

    public final PolygonShape makeOpenPolygon() {
        return new PolygonShape(this.getVertexData(), ClosureMode.OPEN, this.getWindingRule());
    }

    public final PolygonDotsShape makePolygonDots() {
        return new PolygonDotsShape(this.getVertexData());
    }

    public final PolygonShape makeClosedBezierFrame() {
        return new PolygonShape(this.getClosedBezierFrameData(), ClosureMode.CLOSED, this.getWindingRule());
    }

    public final PolygonShape makeOpenBezierFrame() {
        return new PolygonShape(this.getOpenBezierFrameData(), ClosureMode.OPEN, this.getWindingRule());
    }

    public final PolygonDotsShape makeClosedControlDots() {
        return new PolygonDotsShape(this.getClosedBezierControlData());
    }

    public final PolygonDotsShape makeOpenControlDots() {
        return new PolygonDotsShape(this.getOpenBezierControlData());
    }

    public final TweakableShape makeBezierTangentSegments() {
        return new TweakableShape(this.getVertexData(), this.getTangentData(), Path.BEZIER_TANGENT_SEGMENTS, ClosureMode.OPEN, this.getWindingRule());
    }

    public final float[][] getClosedBezierFrameData() {
        int n = this.vertex.length;
        int n2 = 3 * n;
        float[][] fArray = new float[n2][];
        int n3 = 0;
        while (n3 < n) {
            int n4 = (n3 + 1) % n;
            int n5 = 3 * n3;
            int n6 = n5 + 1;
            int n7 = n6 + 1;
            fArray[n5] = this.getVertex(n3);
            fArray[n6] = this.getControlA(n3);
            fArray[n7] = this.getControlB(n4);
            ++n3;
        }
        return fArray;
    }

    public final float[][] getOpenBezierFrameData() {
        int n = this.vertex.length;
        if (n == 0) {
            return new float[0][2];
        }
        int n2 = n - 1;
        int n3 = 3 * n - 2;
        float[][] fArray = new float[n3][];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n4 + 1;
            int n6 = 3 * n4;
            int n7 = n6 + 1;
            int n8 = n7 + 1;
            fArray[n6] = this.getVertex(n4);
            fArray[n7] = this.getControlA(n4);
            fArray[n8] = this.getControlB(n5);
            ++n4;
        }
        fArray[n3 - 1] = this.getVertex(n2);
        return fArray;
    }

    public final float[][] getClosedBezierControlData() {
        int n = this.vertex.length;
        int n2 = 2 * n;
        float[][] fArray = new float[n2][];
        int n3 = 0;
        while (n3 < n) {
            int n4 = (n3 + 1) % n;
            int n5 = 2 * n3;
            int n6 = n5 + 1;
            fArray[n5] = this.getControlA(n3);
            fArray[n6] = this.getControlB(n4);
            ++n3;
        }
        return fArray;
    }

    public final float[][] getOpenBezierControlData() {
        int n = this.vertex.length;
        if (n <= 1) {
            return new float[0][2];
        }
        int n2 = n - 1;
        int n3 = 2 * n - 2;
        float[][] fArray = new float[n3][];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n4 + 1;
            int n6 = 3 * n4;
            int n7 = n6 + 1;
            fArray[n6] = this.getControlA(n4);
            fArray[n7] = this.getControlB(n5);
            ++n4;
        }
        return fArray;
    }

    public final float[][] getBezierTangentSegmentData() {
        int n = this.vertex.length;
        int n2 = 2 * n;
        float[][] fArray = new float[n2][];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 2 * n3;
            int n5 = n4 + 1;
            fArray[n4] = this.getControlB(n3);
            fArray[n5] = this.getControlA(n3);
            ++n3;
        }
        return fArray;
    }

    public static float[][] closedBezierFramePoints(float[][] fArray, float[][] fArray2) {
        if (fArray2 == null ? !FloatArray.checkArray(fArray, 2) : !FloatArray.checkArrayPair(fArray, fArray2, 2)) {
            return new float[0][2];
        }
        BaseShape baseShape = new BaseShape();
        baseShape.vertex = fArray;
        baseShape.tangent = fArray2;
        return baseShape.getClosedBezierFrameData();
    }

    public static float[][] openBezierFramePoints(float[][] fArray, float[][] fArray2) {
        if (fArray2 == null ? !FloatArray.checkArray(fArray, 2) : !FloatArray.checkArrayPair(fArray, fArray2, 2)) {
            return new float[0][2];
        }
        BaseShape baseShape = new BaseShape();
        baseShape.vertex = fArray;
        baseShape.tangent = fArray2;
        return baseShape.getOpenBezierFrameData();
    }

    public static float[][] closedBezierControlPoints(float[][] fArray, float[][] fArray2) {
        if (fArray2 == null ? !FloatArray.checkArray(fArray, 2) : !FloatArray.checkArrayPair(fArray, fArray2, 2)) {
            return new float[0][2];
        }
        BaseShape baseShape = new BaseShape();
        baseShape.vertex = fArray;
        baseShape.tangent = fArray2;
        return baseShape.getClosedBezierControlData();
    }

    public static float[][] openBezierControlPoints(float[][] fArray, float[][] fArray2) {
        if (fArray2 == null ? !FloatArray.checkArray(fArray, 2) : !FloatArray.checkArrayPair(fArray, fArray2, 2)) {
            return new float[0][2];
        }
        BaseShape baseShape = new BaseShape();
        baseShape.vertex = fArray;
        baseShape.tangent = fArray2;
        return baseShape.getOpenBezierControlData();
    }

    public static float[][] bezierTangentSegmentPoints(float[][] fArray, float[][] fArray2) {
        if (fArray2 == null ? !FloatArray.checkArray(fArray, 2) : !FloatArray.checkArrayPair(fArray, fArray2, 2)) {
            return new float[0][2];
        }
        BaseShape baseShape = new BaseShape();
        baseShape.vertex = fArray;
        baseShape.tangent = fArray2;
        return baseShape.getBezierTangentSegmentData();
    }

    public final boolean contains(double d, double d2) {
        return this.path.contains(d, d2);
    }

    public final boolean contains(Point2D point2D) {
        return this.path.contains(point2D);
    }

    public final boolean contains(double d, double d2, double d3, double d4) {
        return this.path.contains(d, d2, d3, d4);
    }

    public final boolean contains(Rectangle2D rectangle2D) {
        return this.path.contains(rectangle2D);
    }

    public final boolean intersects(double d, double d2, double d3, double d4) {
        return this.path.intersects(d, d2, d3, d4);
    }

    public final boolean intersects(Rectangle2D rectangle2D) {
        return this.path.intersects(rectangle2D);
    }

    public final Rectangle getBounds() {
        return this.path.getBounds();
    }

    public final Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    public final PathIterator getPathIterator(AffineTransform affineTransform) {
        return this.path.getPathIterator(affineTransform);
    }

    public final PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.path.getPathIterator(affineTransform, d);
    }

    public final Shape getTransformedShape(AffineTransform affineTransform) {
        GeneralPath generalPath = new GeneralPath(this.windingrule.rule());
        generalPath.append(this.getPathIterator(affineTransform), false);
        return generalPath;
    }

    public final Shape getTransformedShape(AffineTransform affineTransform, double d) {
        GeneralPath generalPath = new GeneralPath(this.windingrule.rule());
        generalPath.append(this.getPathIterator(affineTransform, d), false);
        return generalPath;
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(propertyChangeListener);
    }

    public final void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addPropertyChangeListeners(PropertyChangeListener[] propertyChangeListenerArray) {
        if (propertyChangeListenerArray == null) {
            return;
        }
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addPropertyChangeListener(propertyChangeListenerArray[n2]);
            ++n2;
        }
    }

    public void addPropertyChangeListeners(String string, PropertyChangeListener[] propertyChangeListenerArray) {
        if (propertyChangeListenerArray == null) {
            return;
        }
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addPropertyChangeListener(string, propertyChangeListenerArray[n2]);
            ++n2;
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(string, propertyChangeListener);
    }

    public final PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeAdapter.getPropertyChangeListeners();
    }

    public final PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.changeAdapter.getPropertyChangeListeners(string);
    }

    public final boolean hasListeners(String string) {
        return this.changeAdapter.hasListeners(string);
    }

    public final void firePropertyChange(String string, Object object, Object object2) {
        this.changeAdapter.firePropertyChange(string, object, object2);
    }

    public final void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (bl2 != bl) {
            this.changeAdapter.firePropertyChange(string, bl, bl2);
        }
    }

    public final void firePropertyChange(String string, char c, char c2) {
        if (c2 != c) {
            this.changeAdapter.firePropertyChange(string, new Character(c), new Character(c2));
        }
    }

    public final void firePropertyChange(String string, byte by, byte by2) {
        if (by2 != by) {
            this.changeAdapter.firePropertyChange(string, new Byte(by), new Byte(by2));
        }
    }

    public final void firePropertyChange(String string, short s, short s2) {
        if (s2 != s) {
            this.changeAdapter.firePropertyChange(string, new Short(s), new Short(s2));
        }
    }

    public final void firePropertyChange(String string, int n, int n2) {
        if (n2 != n) {
            this.changeAdapter.firePropertyChange(string, n, n2);
        }
    }

    public final void firePropertyChange(String string, long l, long l2) {
        if (l2 != l) {
            this.changeAdapter.firePropertyChange(string, new Long(l), new Long(l2));
        }
    }

    public final void firePropertyChange(String string, float f, float f2) {
        if (f2 != f) {
            this.changeAdapter.firePropertyChange(string, new Float(f), new Float(f2));
        }
    }

    public final void firePropertyChange(String string, double d, double d2) {
        if (d2 != d) {
            this.changeAdapter.firePropertyChange(string, new Double(d), new Double(d2));
        }
    }

    public final void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.changeAdapter.firePropertyChange(propertyChangeEvent);
    }

    public final PropertyChangeForwardingListener getForwardingListener() {
        return this.forwardingListener;
    }

    public final void addForwardingListener(Object object) {
        if (object instanceof SupportsPropertyChange) {
            SupportsPropertyChange supportsPropertyChange = (SupportsPropertyChange)object;
            supportsPropertyChange.addPropertyChangeListener(this.getForwardingListener());
        }
    }

    public final void removeForwardingListener(Object object) {
        if (object instanceof SupportsPropertyChange) {
            SupportsPropertyChange supportsPropertyChange = (SupportsPropertyChange)object;
            supportsPropertyChange.removePropertyChangeListener(this.getForwardingListener());
        }
    }

    public final void removeAndAddForwardingListener(Object object, Object object2) {
        this.removeForwardingListener(object);
        this.addForwardingListener(object2);
    }
}

