/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.XPoint2D;
import edu.neu.ccs.XRect;
import edu.neu.ccs.gui.Mutator;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PropertyChangeForwardingListener;
import edu.neu.ccs.gui.SupportsPropertyChange;
import edu.neu.ccs.gui.TransformFactory;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class AbstractPaintable
implements Paintable {
    private XRect defaultBounds2D = null;
    private XPoint2D defaultCenter = null;
    private XRect defaultOriginalBounds2D = null;
    private XPoint2D defaultOriginalCenter = null;
    private boolean visible = true;
    private float opacity = 1.0f;
    private AffineTransform mutator = new AffineTransform();
    private AffineTransform inverse = new AffineTransform();
    private final PropertyChangeSupport changeAdapter = new PropertyChangeSupport(this);
    private final PropertyChangeForwardingListener forwardingListener = new PropertyChangeForwardingListener(this);

    public void paint(Graphics graphics) {
        if (graphics == null || !this.visible) {
            return;
        }
        Graphics2D graphics2D = this.getPreparedGraphics2D(graphics);
        graphics2D.transform(this.mutator);
        this.originalPaint(graphics2D);
        graphics2D.transform(this.inverse);
    }

    public final void paintAt(Graphics graphics, double d, double d2) {
        if (graphics == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(d, d2);
        this.paint(graphics2D);
        graphics2D.translate(-d, -d2);
    }

    public final void paintAt(Graphics graphics, Point2D point2D) {
        if (point2D == null) {
            return;
        }
        this.paintAt(graphics, point2D.getX(), point2D.getY());
    }

    public final void paintAt(Graphics graphics, AffineTransform affineTransform, double d, double d2) {
        if (affineTransform == null || affineTransform.isIdentity()) {
            this.paintAt(graphics, d, d2);
            return;
        }
        Point2D.Double double_ = new Point2D.Double(d, d2);
        affineTransform.transform(double_, double_);
        this.paintAt(graphics, double_.getX(), double_.getY());
    }

    public final void paintAt(Graphics graphics, AffineTransform affineTransform, Point2D point2D) {
        if (point2D == null) {
            return;
        }
        this.paintAt(graphics, affineTransform, point2D.getX(), point2D.getY());
    }

    public final Graphics2D getPreparedGraphics2D(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.clip(this.getBounds2D());
        this.applyOpacity(graphics2D);
        return graphics2D;
    }

    public XRect getBounds2D() {
        XRect xRect = this.getDefaultBounds2D();
        if (xRect != null) {
            return xRect;
        }
        xRect = this.getOriginalBounds2D();
        if (this.mutator.isIdentity()) {
            return xRect;
        }
        double d = xRect.getMinX();
        double d2 = xRect.getMinY();
        double d3 = xRect.getMaxX();
        double d4 = xRect.getMaxY();
        double[] dArray = new double[]{d, d2, d3, d2, d3, d4, d, d4};
        double[] dArray2 = new double[8];
        this.mutator.transform(dArray, 0, dArray2, 0, 4);
        d = Math.min(dArray2[0], Math.min(dArray2[2], Math.min(dArray2[4], dArray2[6])));
        d2 = Math.min(dArray2[1], Math.min(dArray2[3], Math.min(dArray2[5], dArray2[7])));
        d3 = Math.max(dArray2[0], Math.max(dArray2[2], Math.max(dArray2[4], dArray2[6])));
        d4 = Math.max(dArray2[1], Math.max(dArray2[3], Math.max(dArray2[5], dArray2[7])));
        return new XRect(d, d2, d3 - d, d4 - d2);
    }

    public XPoint2D getCenter() {
        XPoint2D xPoint2D = this.getDefaultCenter();
        if (xPoint2D != null) {
            return xPoint2D;
        }
        xPoint2D = this.getOriginalCenter();
        if (this.mutator.isIdentity()) {
            return xPoint2D;
        }
        return (XPoint2D)this.mutator.transform(xPoint2D, xPoint2D);
    }

    public final XPoint2D getCorner() {
        XRect xRect = this.getBounds2D();
        return new XPoint2D(xRect.getMinX(), xRect.getMinY());
    }

    public boolean contains(double d, double d2) {
        if (this.mutator.isIdentity()) {
            return this.originalContains(d, d2);
        }
        XPoint2D xPoint2D = new XPoint2D(d, d2);
        this.inverse.transform(xPoint2D, xPoint2D);
        return this.originalContains(xPoint2D.getX(), xPoint2D.getY());
    }

    public final boolean contains(Point2D point2D) {
        if (point2D == null) {
            return false;
        }
        return this.contains(point2D.getX(), point2D.getY());
    }

    public final void setVisible(boolean bl) {
        if (this.visible != bl) {
            this.visible = bl;
            this.firePropertyChange("set.visible", null, null);
        }
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setOpacity(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (this.opacity != f) {
            this.opacity = f;
            this.firePropertyChange("set.opacity", null, null);
        }
    }

    public final float getOpacity() {
        return this.opacity;
    }

    public void setMutator(AffineTransform affineTransform) {
        if (affineTransform == null || affineTransform.equals(this.mutator)) {
            return;
        }
        try {
            AffineTransform affineTransform2 = affineTransform.createInverse();
            this.mutator = affineTransform;
            this.inverse = affineTransform2;
            this.firePropertyChange("set.mutator", null, null);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return;
        }
    }

    public void addPreMutation(AffineTransform affineTransform) {
        if (affineTransform == null) {
            return;
        }
        this.setMutator(TransformFactory.compose(this.mutator, affineTransform));
    }

    public void addPostMutation(AffineTransform affineTransform) {
        if (affineTransform == null) {
            return;
        }
        this.setMutator(TransformFactory.compose(affineTransform, this.mutator));
    }

    public void setMutator(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        this.setMutator(strategy.mutator(this.getOriginalCenter()));
    }

    public void addPreMutation(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        this.addPreMutation(strategy.mutator(this.getOriginalCenter()));
    }

    public void addPostMutation(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        this.addPostMutation(strategy.mutator(this.getCenter()));
    }

    public final AffineTransform getMutator() {
        return new AffineTransform(this.mutator);
    }

    public final AffineTransform getMutatorInverse() {
        return new AffineTransform(this.inverse);
    }

    public final void mutate(AffineTransform affineTransform) {
        this.addPostMutation(affineTransform);
    }

    public final void mutate(Mutator.Strategy strategy) {
        this.addPostMutation(strategy);
    }

    public void move(double d, double d2) {
        this.addPostMutation(TransformFactory.translate(d, d2));
    }

    public final void move(Point2D point2D) {
        if (point2D == null) {
            return;
        }
        this.move(point2D.getX(), point2D.getY());
    }

    public final void moveCenterTo(double d, double d2) {
        XPoint2D xPoint2D = this.getCenter();
        this.move(d - xPoint2D.getX(), d2 - xPoint2D.getY());
    }

    public final void moveCenterTo(Point2D point2D) {
        if (point2D == null) {
            return;
        }
        this.moveCenterTo(point2D.getX(), point2D.getY());
    }

    public final void moveCornerTo(double d, double d2) {
        XPoint2D xPoint2D = this.getCorner();
        this.move(d - xPoint2D.getX(), d2 - xPoint2D.getY());
    }

    public final void moveCornerTo(Point2D point2D) {
        if (point2D == null) {
            return;
        }
        this.moveCornerTo(point2D.getX(), point2D.getY());
    }

    public final void rotate(double d) {
        XPoint2D xPoint2D = this.getCenter();
        this.addPostMutation(TransformFactory.rotate(xPoint2D.getX(), xPoint2D.getY(), d));
    }

    public final void reflect(double d) {
        XPoint2D xPoint2D = this.getCenter();
        this.addPostMutation(TransformFactory.reflect(xPoint2D.getX(), xPoint2D.getY(), d));
    }

    public final void hreflect() {
        this.reflect(0.0);
    }

    public final void vreflect() {
        this.reflect(90.0);
    }

    public final void scale(double d) {
        XPoint2D xPoint2D = this.getCenter();
        this.addPostMutation(TransformFactory.scale(xPoint2D.getX(), xPoint2D.getY(), 0.0, d, d));
    }

    public final void scale(double d, double d2, double d3) {
        XPoint2D xPoint2D = this.getCenter();
        this.addPostMutation(TransformFactory.scale(((Point2D)xPoint2D).getX(), ((Point2D)xPoint2D).getY(), d, d2, d3));
    }

    public final void shear(double d, double d2) {
        XPoint2D xPoint2D = this.getCenter();
        this.addPostMutation(TransformFactory.shear(((Point2D)xPoint2D).getX(), ((Point2D)xPoint2D).getY(), d, d2));
    }

    public final void glide(double d, double d2) {
        this.addPostMutation(TransformFactory.glide(d, d2));
    }

    public final void glidereflect(double d, double d2) {
        XPoint2D xPoint2D = this.getCenter();
        this.addPostMutation(TransformFactory.glidereflect(xPoint2D.getX(), xPoint2D.getY(), d, d2));
    }

    public final void lineartransform(double d, double d2, double d3, double d4) {
        XPoint2D xPoint2D = this.getCenter();
        this.addPostMutation(TransformFactory.centeredTransform(xPoint2D.getX(), xPoint2D.getY(), d, d2, d3, d4, 0.0, 0.0));
    }

    public final void affinetransform(double d, double d2, double d3, double d4, double d5, double d6) {
        XPoint2D xPoint2D = this.getCenter();
        this.addPostMutation(TransformFactory.centeredTransform(xPoint2D.getX(), xPoint2D.getY(), d, d2, d3, d4, d5, d6));
    }

    public abstract void originalPaint(Graphics var1);

    public final XRect getOriginalBounds2D() {
        XRect xRect = this.getDefaultOriginalBounds2D();
        if (xRect != null) {
            return xRect;
        }
        xRect = this.getActualBounds2D();
        if (xRect != null) {
            return xRect;
        }
        return new XRect();
    }

    public abstract XRect getActualBounds2D();

    public XPoint2D getOriginalCenter() {
        XPoint2D xPoint2D = this.getDefaultOriginalCenter();
        if (xPoint2D != null) {
            return xPoint2D;
        }
        XRect xRect = this.getOriginalBounds2D();
        double d = xRect.getCenterX();
        double d2 = xRect.getCenterY();
        return new XPoint2D(d, d2);
    }

    public abstract boolean originalContains(double var1, double var3);

    public final boolean originalContains(Point2D point2D) {
        if (point2D == null) {
            return false;
        }
        return this.originalContains(point2D.getX(), point2D.getY());
    }

    protected final boolean possiblyContains(double d, double d2) {
        return this.visible && this.getOriginalBounds2D().contains(d, d2);
    }

    public final void applyOpacity(Graphics2D graphics2D) {
        if (this.opacity >= 1.0f) {
            return;
        }
        Composite composite = graphics2D.getComposite();
        float f = this.opacity;
        if (composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            if (alphaComposite.getRule() != 3) {
                return;
            }
            f *= alphaComposite.getAlpha();
        } else if (composite != null) {
            return;
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
    }

    public final void setDefaultBounds2D(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            if (this.defaultBounds2D == null) {
                return;
            }
            this.defaultBounds2D = null;
        } else {
            double d = rectangle2D.getX();
            double d2 = rectangle2D.getY();
            double d3 = rectangle2D.getWidth();
            double d4 = rectangle2D.getHeight();
            this.defaultBounds2D = new XRect(d, d2, d3, d4);
        }
        this.firePropertyChange("set.default.bounds2d", null, null);
    }

    public final XRect getDefaultBounds2D() {
        if (this.defaultBounds2D == null) {
            return null;
        }
        return new XRect(this.defaultBounds2D);
    }

    public final void setDefaultCenter(Point2D point2D) {
        if (point2D == null) {
            if (this.defaultCenter == null) {
                return;
            }
            this.defaultCenter = null;
        } else {
            double d = point2D.getX();
            double d2 = point2D.getY();
            this.defaultCenter = new XPoint2D(d, d2);
        }
        this.firePropertyChange("set.default.center", null, null);
    }

    public final XPoint2D getDefaultCenter() {
        if (this.defaultCenter == null) {
            return null;
        }
        return new XPoint2D(this.defaultCenter);
    }

    public final void setDefaultOriginalBounds2D(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            if (this.defaultOriginalBounds2D == null) {
                return;
            }
            this.defaultOriginalBounds2D = null;
        } else {
            double d = rectangle2D.getX();
            double d2 = rectangle2D.getY();
            double d3 = rectangle2D.getWidth();
            double d4 = rectangle2D.getHeight();
            this.defaultOriginalBounds2D = new XRect(d, d2, d3, d4);
        }
        this.firePropertyChange("set.default.original.bounds2d", null, null);
    }

    public final XRect getDefaultOriginalBounds2D() {
        if (this.defaultOriginalBounds2D == null) {
            return null;
        }
        return new XRect(this.defaultOriginalBounds2D);
    }

    public final void setDefaultOriginalCenter(Point2D point2D) {
        if (point2D == null) {
            if (this.defaultOriginalCenter == null) {
                return;
            }
            this.defaultOriginalCenter = null;
        } else {
            double d = point2D.getX();
            double d2 = point2D.getY();
            this.defaultOriginalCenter = new XPoint2D(d, d2);
        }
        this.firePropertyChange("set.default.original.center", null, null);
    }

    public final XPoint2D getDefaultOriginalCenter() {
        if (this.defaultOriginalCenter == null) {
            return null;
        }
        return new XPoint2D(this.defaultOriginalCenter);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(propertyChangeListener);
    }

    public final void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(string, propertyChangeListener);
    }

    public final void addPropertyChangeListeners(PropertyChangeListener[] propertyChangeListenerArray) {
        if (propertyChangeListenerArray == null) {
            return;
        }
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addPropertyChangeListener(propertyChangeListenerArray[n2]);
            ++n2;
        }
    }

    public final void addPropertyChangeListeners(String string, PropertyChangeListener[] propertyChangeListenerArray) {
        if (propertyChangeListenerArray == null) {
            return;
        }
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addPropertyChangeListener(string, propertyChangeListenerArray[n2]);
            ++n2;
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(string, propertyChangeListener);
    }

    public final PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeAdapter.getPropertyChangeListeners();
    }

    public final PropertyChangeListener[] getPropertyChangeListeners(String string) {
        return this.changeAdapter.getPropertyChangeListeners(string);
    }

    public final boolean hasListeners(String string) {
        return this.changeAdapter.hasListeners(string);
    }

    public final void firePropertyChange(String string, Object object, Object object2) {
        this.changeAdapter.firePropertyChange(string, object, object2);
    }

    public final void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (bl2 != bl) {
            this.changeAdapter.firePropertyChange(string, bl, bl2);
        }
    }

    public final void firePropertyChange(String string, char c, char c2) {
        if (c2 != c) {
            this.changeAdapter.firePropertyChange(string, new Character(c), new Character(c2));
        }
    }

    public final void firePropertyChange(String string, byte by, byte by2) {
        if (by2 != by) {
            this.changeAdapter.firePropertyChange(string, new Byte(by), new Byte(by2));
        }
    }

    public final void firePropertyChange(String string, short s, short s2) {
        if (s2 != s) {
            this.changeAdapter.firePropertyChange(string, new Short(s), new Short(s2));
        }
    }

    public final void firePropertyChange(String string, int n, int n2) {
        if (n2 != n) {
            this.changeAdapter.firePropertyChange(string, n, n2);
        }
    }

    public final void firePropertyChange(String string, long l, long l2) {
        if (l2 != l) {
            this.changeAdapter.firePropertyChange(string, new Long(l), new Long(l2));
        }
    }

    public final void firePropertyChange(String string, float f, float f2) {
        if (f2 != f) {
            this.changeAdapter.firePropertyChange(string, new Float(f), new Float(f2));
        }
    }

    public final void firePropertyChange(String string, double d, double d2) {
        if (d2 != d) {
            this.changeAdapter.firePropertyChange(string, new Double(d), new Double(d2));
        }
    }

    public final void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.changeAdapter.firePropertyChange(propertyChangeEvent);
    }

    public final PropertyChangeForwardingListener getForwardingListener() {
        return this.forwardingListener;
    }

    public final void addForwardingListener(Object object) {
        if (object instanceof SupportsPropertyChange) {
            SupportsPropertyChange supportsPropertyChange = (SupportsPropertyChange)object;
            supportsPropertyChange.addPropertyChangeListener(this.getForwardingListener());
        }
    }

    public final void removeForwardingListener(Object object) {
        if (object instanceof SupportsPropertyChange) {
            SupportsPropertyChange supportsPropertyChange = (SupportsPropertyChange)object;
            supportsPropertyChange.removePropertyChangeListener(this.getForwardingListener());
        }
    }

    public final void removeAndAddForwardingListener(Object object, Object object2) {
        this.removeForwardingListener(object);
        this.addForwardingListener(object2);
    }
}

