/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.filter;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.filter.BoundFilter;
import edu.neu.ccs.filter.FilterException;

public class MinimumBoundFilter
extends BoundFilter {
    public static final String MINIMUM = "minimum";

    public MinimumBoundFilter(boolean bl) {
        super(bl);
    }

    public static class Long
    extends MinimumBoundFilter {
        protected long minimum = 0L;

        public Long(long l) {
            this(l, true);
        }

        public Long(long l, boolean bl) {
            super(bl);
            this.setMinimum(l);
        }

        public Stringable filterStringable(Stringable stringable) throws FilterException {
            XNumber xNumber = (XNumber)super.filterStringable(stringable);
            long l = xNumber.longValue();
            if (this.getMinimum() < l || this.isInclusive() && this.getMinimum() == l) {
                return stringable;
            }
            String string = "Value not within the range ";
            string = String.valueOf(string) + (super.isInclusive() ? "[" : "(");
            string = String.valueOf(string) + this.getMinimum() + ", inf.]";
            throw new FilterException(stringable, string);
        }

        public void setMinimum(long l) {
            long l2 = this.getMinimum();
            this.minimum = l;
            if (this.getMinimum() != l2) {
                this.changeAdapter.firePropertyChange(MinimumBoundFilter.MINIMUM, new java.lang.Long(l2), new java.lang.Long(this.getMinimum()));
            }
        }

        public long getMinimum() {
            return this.minimum;
        }
    }

    public static class Double
    extends MinimumBoundFilter {
        protected double minimum = 0.0;

        public Double(double d) {
            this(d, true);
        }

        public Double(double d, boolean bl) {
            super(bl);
            this.setMinimum(d);
        }

        public Stringable filterStringable(Stringable stringable) throws FilterException {
            XNumber xNumber = (XNumber)super.filterStringable(stringable);
            double d = xNumber.doubleValue();
            if (this.getMinimum() < d || this.isInclusive() && this.getMinimum() == d) {
                return stringable;
            }
            String string = "Value not within the range ";
            string = String.valueOf(string) + (super.isInclusive() ? "[" : "(");
            string = String.valueOf(string) + this.getMinimum() + ", inf.]";
            throw new FilterException(stringable, string);
        }

        public void setMinimum(double d) {
            double d2 = this.getMinimum();
            this.minimum = d;
            if (this.getMinimum() != d2) {
                this.changeAdapter.firePropertyChange(MinimumBoundFilter.MINIMUM, new java.lang.Double(d2), new java.lang.Double(this.getMinimum()));
            }
        }

        public double getMinimum() {
            return this.minimum;
        }
    }

    public static class BigInteger
    extends MinimumBoundFilter {
        protected java.math.BigInteger minimum = null;

        public BigInteger(java.math.BigInteger bigInteger) {
            this(bigInteger, true);
        }

        public BigInteger(java.math.BigInteger bigInteger, boolean bl) {
            super(bl);
            this.setMinimum(bigInteger);
        }

        public Stringable filterStringable(Stringable stringable) throws FilterException {
            XNumber xNumber = (XNumber)super.filterStringable(stringable);
            java.math.BigInteger bigInteger = new java.math.BigInteger(new java.lang.Long(xNumber.longValue()).toString());
            if (bigInteger.compareTo(this.getMinimum()) > 0 || this.isInclusive() && bigInteger.compareTo(this.getMinimum()) == 0) {
                return stringable;
            }
            String string = "Value not within the range ";
            string = String.valueOf(string) + (super.isInclusive() ? "[" : "(");
            string = String.valueOf(string) + this.getMinimum() + ", inf.]";
            throw new FilterException(stringable, string);
        }

        public void setMinimum(java.math.BigInteger bigInteger) {
            if (bigInteger == null) {
                return;
            }
            java.math.BigInteger bigInteger2 = this.getMinimum();
            this.minimum = bigInteger;
            if (!this.getMinimum().equals(bigInteger2)) {
                this.changeAdapter.firePropertyChange(MinimumBoundFilter.MINIMUM, bigInteger2, this.getMinimum());
            }
        }

        public java.math.BigInteger getMinimum() {
            return this.minimum;
        }
    }

    public static class BigDecimal
    extends MinimumBoundFilter {
        protected java.math.BigDecimal minimum = null;

        public BigDecimal(java.math.BigDecimal bigDecimal) {
            this(bigDecimal, true);
        }

        public BigDecimal(java.math.BigDecimal bigDecimal, boolean bl) {
            super(bl);
            this.setMinimum(bigDecimal);
        }

        public Stringable filterStringable(Stringable stringable) throws FilterException {
            XNumber xNumber = (XNumber)super.filterStringable(stringable);
            java.math.BigDecimal bigDecimal = new java.math.BigDecimal(xNumber.doubleValue());
            if (bigDecimal.compareTo(this.getMinimum()) > 0 || this.isInclusive() && bigDecimal.compareTo(this.getMinimum()) == 0) {
                return stringable;
            }
            String string = "Value not within the range ";
            string = String.valueOf(string) + (super.isInclusive() ? "[" : "(");
            string = String.valueOf(string) + this.getMinimum() + ", inf.]";
            throw new FilterException(stringable, string);
        }

        public void setMinimum(java.math.BigDecimal bigDecimal) {
            if (bigDecimal == null) {
                return;
            }
            java.math.BigDecimal bigDecimal2 = this.getMinimum();
            this.minimum = bigDecimal;
            if (!this.getMinimum().equals(bigDecimal2)) {
                this.changeAdapter.firePropertyChange(MinimumBoundFilter.MINIMUM, bigDecimal2, this.getMinimum());
            }
        }

        public java.math.BigDecimal getMinimum() {
            return this.minimum;
        }
    }
}

