/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.console;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.XBigDecimal;
import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XBoolean;
import edu.neu.ccs.XByte;
import edu.neu.ccs.XChar;
import edu.neu.ccs.XColor;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XFloat;
import edu.neu.ccs.XInt;
import edu.neu.ccs.XLong;
import edu.neu.ccs.XObject;
import edu.neu.ccs.XShort;
import edu.neu.ccs.XString;
import edu.neu.ccs.console.ConsoleInputListener;
import edu.neu.ccs.console.ConsoleTextPane;
import edu.neu.ccs.console.ConsoleWindow;
import edu.neu.ccs.filter.CaseActionFilter;
import edu.neu.ccs.filter.FilterException;
import edu.neu.ccs.filter.StringableFilter;
import edu.neu.ccs.gui.CancelledException;
import edu.neu.ccs.quick.QuickHashSet;
import edu.neu.ccs.util.JPTConstants;
import edu.neu.ccs.util.StringableFactory;
import edu.neu.ccs.util.SystemUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import javax.swing.event.SwingPropertyChangeSupport;

public class ConsoleGateway
implements ConsoleInputListener,
JPTConstants,
Serializable {
    private static final int OUT = 0;
    private static final int ERR = 1;
    private static final int IN = 2;
    public static final String ACTIVATED = "activated";
    public static final String INPUT_COLOR = "input.color";
    public static final String OUTPUT_COLOR = "output.color";
    public static final String ERROR_COLOR = "error.color";
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);
    protected CaseActionFilter action = null;
    protected String input = "";
    protected transient InputStream inStream = null;
    protected transient OutputStream[] outStreams = null;
    protected transient String endl = null;
    protected ConsoleWindow window = null;
    public ConsoleInputStream in = new ConsoleInputStream();
    public PrintStream out = new PrintStream(new ConsoleOutputStream(0));
    public PrintStream err = new PrintStream(new ConsoleOutputStream(1));
    static /* synthetic */ Class class$edu$neu$ccs$XByte;
    static /* synthetic */ Class class$edu$neu$ccs$XShort;
    static /* synthetic */ Class class$edu$neu$ccs$XInt;
    static /* synthetic */ Class class$edu$neu$ccs$XLong;
    static /* synthetic */ Class class$edu$neu$ccs$XFloat;
    static /* synthetic */ Class class$edu$neu$ccs$XDouble;
    static /* synthetic */ Class class$edu$neu$ccs$XChar;
    static /* synthetic */ Class class$edu$neu$ccs$XBoolean;
    static /* synthetic */ Class class$edu$neu$ccs$XString;
    static /* synthetic */ Class class$edu$neu$ccs$XBigInteger;
    static /* synthetic */ Class class$edu$neu$ccs$XBigDecimal;
    static /* synthetic */ Class class$edu$neu$ccs$XColor;

    public ConsoleGateway() {
        this.inStream = System.in;
        this.outStreams = new OutputStream[]{System.out, System.err};
        this.endl = SystemUtilities.getLineSeparator();
    }

    public synchronized void consoleInputPerformed(String string) {
        this.input = string.substring(0, string.indexOf(this.endl));
        this.notify();
    }

    public synchronized void prompt(String string) {
        if (string != null && string.length() > 0) {
            this.out.print(String.valueOf(string) + " ");
        }
    }

    public synchronized void prompt(String string, String string2) {
        this.prompt(string);
        if (string2 != null && string2.length() > 0) {
            this.out.print("[" + string2 + "] ");
        }
    }

    public synchronized void pressReturn() {
        this.pressReturn(null);
    }

    public synchronized void pressReturn(String string) {
        if (string != null && string.length() > 0) {
            this.out.println(string);
        }
        this.prompt("Press return to continue");
        this.getOneLine();
    }

    public synchronized boolean confirm(String string, boolean bl) {
        String string2 = bl ? "Y" : "N";
        String string3 = "";
        while ((string3 = this.in.demandString(string, string2)).length() != 0) {
            if (Character.toUpperCase(string3.charAt(0)) == 'Y') {
                bl = true;
                break;
            }
            if (Character.toUpperCase(string3.charAt(0)) == 'N') {
                bl = false;
                break;
            }
            this.out.println("Must answer Y[es] or N[o].");
            this.out.println();
        }
        return bl;
    }

    public synchronized void setCaseActionFilter(CaseActionFilter caseActionFilter) {
        this.action = caseActionFilter;
    }

    public synchronized CaseActionFilter getCaseActionFilter() {
        return this.action;
    }

    public synchronized void setActivated(boolean bl) {
        boolean bl2 = this.isActivated();
        if (bl && !this.isActivated()) {
            this.window = new ConsoleWindow();
            ((Component)this.window).setVisible(true);
            this.window.setLocation(7);
        } else if (!bl && this.isActivated()) {
            ConsoleWindow consoleWindow = this.window;
            this.window = null;
            consoleWindow.close();
        }
        if (this.isActivated() != bl2) {
            this.changeAdapter.firePropertyChange(ACTIVATED, bl2, this.isActivated());
        }
    }

    public synchronized boolean isActivated() {
        return this.window != null;
    }

    public void normal() {
        if (this.window != null) {
            this.window.normal();
        }
    }

    public void iconify() {
        if (this.window != null) {
            this.window.iconify();
        }
    }

    public void maximize() {
        if (this.window != null) {
            this.window.maximize();
        }
    }

    public void toggle() {
        if (this.window != null) {
            this.window.toggle();
        }
    }

    public synchronized void setInputColor(Color color) {
        if (this.isActivated()) {
            Color color2 = this.getInputColor();
            this.window.setInputColor(color);
            this.changeAdapter.firePropertyChange(INPUT_COLOR, color2, this.getInputColor());
        }
    }

    public synchronized Color getInputColor() {
        if (this.isActivated()) {
            return this.window.getInputColor();
        }
        return null;
    }

    public synchronized void setOutputColor(Color color) {
        if (this.isActivated()) {
            Color color2 = this.getOutputColor();
            this.window.setOutputColor(color);
            this.changeAdapter.firePropertyChange(OUTPUT_COLOR, color2, this.getOutputColor());
        }
    }

    public synchronized Color getOutputColor() {
        if (this.isActivated()) {
            return this.window.getOutputColor();
        }
        return null;
    }

    public synchronized void setErrorColor(Color color) {
        if (this.isActivated()) {
            Color color2 = this.getErrorColor();
            this.window.setErrorColor(color);
            this.changeAdapter.firePropertyChange(ERROR_COLOR, color2, this.getErrorColor());
        }
    }

    public synchronized Color getErrorColor() {
        if (this.isActivated()) {
            return this.window.getErrorColor();
        }
        return null;
    }

    public synchronized void selectBlackTextScheme() {
        this.setOutputColor(Color.black);
        this.setInputColor(Color.black);
        this.setErrorColor(Color.black);
    }

    public synchronized void selectColorTextScheme() {
        this.setOutputColor(Color.black);
        this.setInputColor(Color.blue);
        this.setErrorColor(Color.red);
    }

    public static final String getMonospacedFontFamilyName() {
        String string = "";
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Object[] objectArray = graphicsEnvironment.getAvailableFontFamilyNames();
        QuickHashSet quickHashSet = new QuickHashSet(objectArray);
        string = quickHashSet.contains("Lucida Console") ? "Lucida Console" : (quickHashSet.contains("Lucida Sans Typewriter") ? "Lucida Sans Typewriter" : (quickHashSet.contains("Courier New") ? "Courier New" : (quickHashSet.contains("Andale Mono") ? "Andale Mono" : (quickHashSet.contains("Monospaced") ? "Monospaced" : "monospaced"))));
        return string;
    }

    public final String getFontFamilyName() {
        if (this.isActivated()) {
            return this.window.getFontFamilyName();
        }
        return "";
    }

    public final int getFontSize() {
        if (this.isActivated()) {
            return this.window.getFontSize();
        }
        return 0;
    }

    public static final int getMinimumFontSize() {
        return ConsoleTextPane.getMinimumFontSize();
    }

    public static final int getMaximumFontSize() {
        return ConsoleTextPane.getMaximumFontSize();
    }

    public final void setFontSize(int n) {
        if (this.isActivated()) {
            this.window.setFontSize(n);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeAdapter.removePropertyChangeListener(string, propertyChangeListener);
    }

    protected synchronized String getOneLine() {
        block14: {
            if (this.isActivated()) {
                this.input = null;
                this.window.setInputMode(true);
                try {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    Object var2_1 = null;
                    if (this.input == null) {
                        this.input = "";
                    }
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    if (this.input == null) {
                        this.input = "";
                    }
                    throw throwable;
                }
                this.window.setInputMode(false);
            } else {
                StringBuffer stringBuffer = new StringBuffer("");
                while (stringBuffer.toString().indexOf(this.endl) < 0) {
                    try {
                        int n = this.inStream.read();
                        if (n < 0) {
                            stringBuffer.append(this.endl);
                            continue;
                        }
                        stringBuffer.append((char)n);
                    }
                    catch (IOException iOException) {
                        stringBuffer.append(this.endl);
                    }
                }
                this.input = stringBuffer.toString();
                this.input = this.input.substring(0, this.input.indexOf(this.endl));
            }
            if (this.action == null) break block14;
            try {
                XString xString = (XString)this.action.filterStringable(new XString(this.input));
                this.input = xString.getValue();
            }
            catch (FilterException filterException) {}
        }
        return this.input;
    }

    protected String getLineSeparator() {
        return this.endl;
    }

    protected void flush(int n) throws IOException {
        if (!this.isActivated()) {
            this.outStreams[n].flush();
        }
    }

    protected void write(String string, int n) {
        if (string == null) {
            return;
        }
        if (this.isActivated()) {
            this.window.consoleOutputPerformed(string, n);
        } else {
            try {
                this.outStreams[n].write(string.getBytes());
            }
            catch (IOException iOException) {
                System.err.print("Could not write to ");
                switch (n) {
                    case 1: {
                        System.err.print("error");
                        break;
                    }
                    default: {
                        System.err.print("output");
                    }
                }
                System.err.println(" stream.");
                iOException.printStackTrace();
            }
            try {
                this.outStreams[n].flush();
            }
            catch (IOException iOException) {
                System.err.print("Could not flush ");
                switch (n) {
                    case 1: {
                        System.err.print("error");
                        break;
                    }
                    default: {
                        System.err.print("output");
                    }
                }
                System.err.println(" stream.");
                iOException.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ConsoleInputStream
    implements Serializable {
        protected StringableFactory factory = new StringableFactory(null);

        public void setDataType(Class clazz) {
            this.factory.setDataType(clazz);
        }

        public Class getDataType() {
            return this.factory.getDataType();
        }

        public Stringable demandObject(String string, String string2, Stringable stringable, StringableFilter stringableFilter) {
            if (stringable == null) {
                stringable = this.factory.getDefaultInstance();
            }
            while (true) {
                ConsoleGateway.this.prompt(string, string2);
                String string3 = ConsoleGateway.this.getOneLine();
                if (string3.length() == 0 && string2 != null) {
                    string3 = string2;
                }
                try {
                    block9: {
                        try {
                            stringable.fromStringData(string3);
                            if (stringableFilter == null) break block9;
                            try {
                                stringable = stringableFilter.filterStringable(stringable);
                            }
                            catch (FilterException filterException) {
                                throw new ParseException(filterException.getMessage(), -1);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException(numberFormatException.getMessage(), -1);
                        }
                    }
                    return stringable;
                }
                catch (ParseException parseException) {
                    ConsoleGateway.this.err.println(XObject.formatErrorMessage(parseException, string3));
                    continue;
                }
                break;
            }
        }

        public Stringable demandObject(String string) {
            return this.demandObject(string, null, null, null);
        }

        public Stringable demandObject(String string, StringableFilter stringableFilter) {
            return this.demandObject(string, null, null, stringableFilter);
        }

        public Stringable demandObject(String string, String string2) {
            return this.demandObject(string, string2, null, null);
        }

        public Stringable demandObject(String string, String string2, StringableFilter stringableFilter) {
            return this.demandObject(string, string2, null, stringableFilter);
        }

        public Stringable demandObject(Class clazz, String string, String string2, StringableFilter stringableFilter) {
            Class clazz2 = this.getDataType();
            this.setDataType(clazz);
            Stringable stringable = this.demandObject(string, string2, stringableFilter);
            this.setDataType(clazz2);
            return stringable;
        }

        public void demand(String string, Stringable stringable) {
            this.demand(string, null, stringable, null);
        }

        public void demand(String string, Stringable stringable, StringableFilter stringableFilter) {
            this.demand(string, null, stringable, stringableFilter);
        }

        public void demand(String string, String string2, Stringable stringable) {
            this.demand(string, string2, stringable, null);
        }

        public void demand(String string, String string2, Stringable stringable, StringableFilter stringableFilter) {
            if (stringable == null) {
                throw new NullPointerException("Null object in demand method.");
            }
            this.demandObject(string, string2, stringable, stringableFilter);
        }

        public Stringable requestObject(String string, Stringable stringable, StringableFilter stringableFilter) throws CancelledException {
            if (stringable == null) {
                stringable = this.factory.getDefaultInstance();
            }
            while (true) {
                ConsoleGateway.this.prompt(string);
                String string2 = ConsoleGateway.this.getOneLine();
                if (string2.length() == 0) {
                    throw new CancelledException();
                }
                try {
                    block9: {
                        try {
                            stringable.fromStringData(string2);
                            if (stringableFilter == null) break block9;
                            try {
                                stringable = stringableFilter.filterStringable(stringable);
                            }
                            catch (FilterException filterException) {
                                throw new ParseException(filterException.getMessage(), -1);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException(numberFormatException.getMessage(), -1);
                        }
                    }
                    return stringable;
                }
                catch (ParseException parseException) {
                    ConsoleGateway.this.err.println(XObject.formatErrorMessage(parseException, string2));
                    continue;
                }
                break;
            }
        }

        public Stringable requestObject(String string) throws CancelledException {
            return this.requestObject(string, null, null);
        }

        public Stringable requestObject(String string, StringableFilter stringableFilter) throws CancelledException {
            return this.requestObject(string, null, stringableFilter);
        }

        public Stringable requestObject(Class clazz, String string, StringableFilter stringableFilter) throws CancelledException {
            Class clazz2 = this.getDataType();
            this.setDataType(clazz);
            Stringable stringable = this.requestObject(string, stringableFilter);
            this.setDataType(clazz2);
            return stringable;
        }

        public void request(String string, Stringable stringable) throws CancelledException {
            this.requestObject(string, stringable, null);
        }

        public void request(String string, Stringable stringable, StringableFilter stringableFilter) throws CancelledException {
            if (stringable == null) {
                throw new NullPointerException("Null object in request method.");
            }
            this.requestObject(string, stringable, stringableFilter);
        }

        public boolean reading(String string, Stringable stringable) {
            return this.reading(string, stringable, null);
        }

        public boolean reading(String string, Stringable stringable, StringableFilter stringableFilter) {
            if (stringable == null) {
                throw new NullPointerException("Null object in reading method.");
            }
            while (true) {
                ConsoleGateway.this.prompt(string);
                String string2 = ConsoleGateway.this.getOneLine();
                if (string2.length() == 0) {
                    return false;
                }
                try {
                    block9: {
                        try {
                            stringable.fromStringData(string2);
                            if (stringableFilter == null) break block9;
                            try {
                                stringableFilter.filterStringable(stringable);
                            }
                            catch (FilterException filterException) {
                                throw new ParseException(filterException.getMessage(), -1);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException(numberFormatException.getMessage(), -1);
                        }
                    }
                    return true;
                }
                catch (ParseException parseException) {
                    ConsoleGateway.this.err.println(XObject.formatErrorMessage(parseException, string2));
                    continue;
                }
                break;
            }
        }

        public byte demandByte(String string) {
            return this.demandByte(string, null);
        }

        public byte demandByte(String string, StringableFilter stringableFilter) {
            return ((XByte)this.demandObject(class$edu$neu$ccs$XByte != null ? class$edu$neu$ccs$XByte : (class$edu$neu$ccs$XByte = ConsoleGateway.class$("edu.neu.ccs.XByte")), string, null, stringableFilter)).getValue();
        }

        public byte demandByte(String string, byte by) {
            return this.demandByte(string, by, null);
        }

        public byte demandByte(String string, byte by, StringableFilter stringableFilter) {
            return ((XByte)this.demandObject(class$edu$neu$ccs$XByte != null ? class$edu$neu$ccs$XByte : (class$edu$neu$ccs$XByte = ConsoleGateway.class$("edu.neu.ccs.XByte")), string, String.valueOf(by), stringableFilter)).getValue();
        }

        public byte requestByte(String string) throws CancelledException {
            return this.requestByte(string, null);
        }

        public byte requestByte(String string, StringableFilter stringableFilter) throws CancelledException {
            return ((XByte)this.requestObject(class$edu$neu$ccs$XByte != null ? class$edu$neu$ccs$XByte : (class$edu$neu$ccs$XByte = ConsoleGateway.class$("edu.neu.ccs.XByte")), string, stringableFilter)).getValue();
        }

        public short demandShort(String string) {
            return this.demandShort(string, null);
        }

        public short demandShort(String string, StringableFilter stringableFilter) {
            return ((XShort)this.demandObject(class$edu$neu$ccs$XShort != null ? class$edu$neu$ccs$XShort : (class$edu$neu$ccs$XShort = ConsoleGateway.class$("edu.neu.ccs.XShort")), string, null, stringableFilter)).getValue();
        }

        public short demandShort(String string, short s) {
            return this.demandShort(string, s, null);
        }

        public short demandShort(String string, short s, StringableFilter stringableFilter) {
            return ((XShort)this.demandObject(class$edu$neu$ccs$XShort != null ? class$edu$neu$ccs$XShort : (class$edu$neu$ccs$XShort = ConsoleGateway.class$("edu.neu.ccs.XShort")), string, String.valueOf(s), stringableFilter)).getValue();
        }

        public short requestShort(String string) throws CancelledException {
            return this.requestShort(string, null);
        }

        public short requestShort(String string, StringableFilter stringableFilter) throws CancelledException {
            return ((XShort)this.requestObject(class$edu$neu$ccs$XShort != null ? class$edu$neu$ccs$XShort : (class$edu$neu$ccs$XShort = ConsoleGateway.class$("edu.neu.ccs.XShort")), string, stringableFilter)).getValue();
        }

        public int demandInt(String string) {
            return this.demandInt(string, null);
        }

        public int demandInt(String string, StringableFilter stringableFilter) {
            return ((XInt)this.demandObject(class$edu$neu$ccs$XInt != null ? class$edu$neu$ccs$XInt : (class$edu$neu$ccs$XInt = ConsoleGateway.class$("edu.neu.ccs.XInt")), string, null, stringableFilter)).getValue();
        }

        public int demandInt(String string, int n) {
            return this.demandInt(string, n, null);
        }

        public int demandInt(String string, int n, StringableFilter stringableFilter) {
            return ((XInt)this.demandObject(class$edu$neu$ccs$XInt != null ? class$edu$neu$ccs$XInt : (class$edu$neu$ccs$XInt = ConsoleGateway.class$("edu.neu.ccs.XInt")), string, String.valueOf(n), stringableFilter)).getValue();
        }

        public int requestInt(String string) throws CancelledException {
            return this.requestInt(string, null);
        }

        public int requestInt(String string, StringableFilter stringableFilter) throws CancelledException {
            return ((XInt)this.requestObject(class$edu$neu$ccs$XInt != null ? class$edu$neu$ccs$XInt : (class$edu$neu$ccs$XInt = ConsoleGateway.class$("edu.neu.ccs.XInt")), string, stringableFilter)).getValue();
        }

        public long demandLong(String string) {
            return this.demandLong(string, null);
        }

        public long demandLong(String string, StringableFilter stringableFilter) {
            return ((XLong)this.demandObject(class$edu$neu$ccs$XLong != null ? class$edu$neu$ccs$XLong : (class$edu$neu$ccs$XLong = ConsoleGateway.class$("edu.neu.ccs.XLong")), string, null, stringableFilter)).getValue();
        }

        public long demandLong(String string, long l) {
            return this.demandLong(string, l, null);
        }

        public long demandLong(String string, long l, StringableFilter stringableFilter) {
            return ((XLong)this.demandObject(class$edu$neu$ccs$XLong != null ? class$edu$neu$ccs$XLong : (class$edu$neu$ccs$XLong = ConsoleGateway.class$("edu.neu.ccs.XLong")), string, String.valueOf(l), stringableFilter)).getValue();
        }

        public long requestLong(String string) throws CancelledException {
            return this.requestLong(string, null);
        }

        public long requestLong(String string, StringableFilter stringableFilter) throws CancelledException {
            return ((XLong)this.requestObject(class$edu$neu$ccs$XLong != null ? class$edu$neu$ccs$XLong : (class$edu$neu$ccs$XLong = ConsoleGateway.class$("edu.neu.ccs.XLong")), string, stringableFilter)).getValue();
        }

        public float demandFloat(String string) {
            return this.demandFloat(string, null);
        }

        public float demandFloat(String string, StringableFilter stringableFilter) {
            return ((XFloat)this.demandObject(class$edu$neu$ccs$XFloat != null ? class$edu$neu$ccs$XFloat : (class$edu$neu$ccs$XFloat = ConsoleGateway.class$("edu.neu.ccs.XFloat")), string, null, stringableFilter)).getValue();
        }

        public float demandFloat(String string, float f) {
            return this.demandFloat(string, f, null);
        }

        public float demandFloat(String string, float f, StringableFilter stringableFilter) {
            return ((XFloat)this.demandObject(class$edu$neu$ccs$XFloat != null ? class$edu$neu$ccs$XFloat : (class$edu$neu$ccs$XFloat = ConsoleGateway.class$("edu.neu.ccs.XFloat")), string, String.valueOf(f), stringableFilter)).getValue();
        }

        public float requestFloat(String string) throws CancelledException {
            return this.requestFloat(string, null);
        }

        public float requestFloat(String string, StringableFilter stringableFilter) throws CancelledException {
            return ((XFloat)this.requestObject(class$edu$neu$ccs$XFloat != null ? class$edu$neu$ccs$XFloat : (class$edu$neu$ccs$XFloat = ConsoleGateway.class$("edu.neu.ccs.XFloat")), string, stringableFilter)).getValue();
        }

        public double demandDouble(String string) {
            return this.demandDouble(string, null);
        }

        public double demandDouble(String string, StringableFilter stringableFilter) {
            return ((XDouble)this.demandObject(class$edu$neu$ccs$XDouble != null ? class$edu$neu$ccs$XDouble : (class$edu$neu$ccs$XDouble = ConsoleGateway.class$("edu.neu.ccs.XDouble")), string, null, stringableFilter)).getValue();
        }

        public double demandDouble(String string, double d) {
            return this.demandDouble(string, d, null);
        }

        public double demandDouble(String string, double d, StringableFilter stringableFilter) {
            return ((XDouble)this.demandObject(class$edu$neu$ccs$XDouble != null ? class$edu$neu$ccs$XDouble : (class$edu$neu$ccs$XDouble = ConsoleGateway.class$("edu.neu.ccs.XDouble")), string, String.valueOf(d), stringableFilter)).getValue();
        }

        public double requestDouble(String string) throws CancelledException {
            return this.requestDouble(string, null);
        }

        public double requestDouble(String string, StringableFilter stringableFilter) throws CancelledException {
            return ((XDouble)this.requestObject(class$edu$neu$ccs$XDouble != null ? class$edu$neu$ccs$XDouble : (class$edu$neu$ccs$XDouble = ConsoleGateway.class$("edu.neu.ccs.XDouble")), string, stringableFilter)).getValue();
        }

        public char demandChar(String string) {
            return this.demandChar(string, null);
        }

        public char demandChar(String string, StringableFilter stringableFilter) {
            return ((XChar)this.demandObject(class$edu$neu$ccs$XChar != null ? class$edu$neu$ccs$XChar : (class$edu$neu$ccs$XChar = ConsoleGateway.class$("edu.neu.ccs.XChar")), string, null, stringableFilter)).getValue();
        }

        public char demandChar(String string, char c) {
            return this.demandChar(string, c, null);
        }

        public char demandChar(String string, char c, StringableFilter stringableFilter) {
            return ((XChar)this.demandObject(class$edu$neu$ccs$XChar != null ? class$edu$neu$ccs$XChar : (class$edu$neu$ccs$XChar = ConsoleGateway.class$("edu.neu.ccs.XChar")), string, String.valueOf(c), stringableFilter)).getValue();
        }

        public char requestChar(String string) throws CancelledException {
            return this.requestChar(string, null);
        }

        public char requestChar(String string, StringableFilter stringableFilter) throws CancelledException {
            return ((XChar)this.requestObject(class$edu$neu$ccs$XChar != null ? class$edu$neu$ccs$XChar : (class$edu$neu$ccs$XChar = ConsoleGateway.class$("edu.neu.ccs.XChar")), string, stringableFilter)).getValue();
        }

        public boolean demandBoolean(String string) {
            return this.demandBoolean(string, null);
        }

        public boolean demandBoolean(String string, StringableFilter stringableFilter) {
            return ((XBoolean)this.demandObject(class$edu$neu$ccs$XBoolean != null ? class$edu$neu$ccs$XBoolean : (class$edu$neu$ccs$XBoolean = ConsoleGateway.class$("edu.neu.ccs.XBoolean")), string, null, stringableFilter)).getValue();
        }

        public boolean demandBoolean(String string, boolean bl) {
            return this.demandBoolean(string, bl, null);
        }

        public boolean demandBoolean(String string, boolean bl, StringableFilter stringableFilter) {
            return ((XBoolean)this.demandObject(class$edu$neu$ccs$XBoolean != null ? class$edu$neu$ccs$XBoolean : (class$edu$neu$ccs$XBoolean = ConsoleGateway.class$("edu.neu.ccs.XBoolean")), string, String.valueOf(bl), stringableFilter)).getValue();
        }

        public boolean requestBoolean(String string) throws CancelledException {
            return this.requestBoolean(string, null);
        }

        public boolean requestBoolean(String string, StringableFilter stringableFilter) throws CancelledException {
            return ((XBoolean)this.requestObject(class$edu$neu$ccs$XBoolean != null ? class$edu$neu$ccs$XBoolean : (class$edu$neu$ccs$XBoolean = ConsoleGateway.class$("edu.neu.ccs.XBoolean")), string, stringableFilter)).getValue();
        }

        public String demandString(String string) {
            return this.demandString(string, (StringableFilter)null);
        }

        public String demandString(String string, StringableFilter stringableFilter) {
            return ((XString)this.demandObject(class$edu$neu$ccs$XString != null ? class$edu$neu$ccs$XString : (class$edu$neu$ccs$XString = ConsoleGateway.class$("edu.neu.ccs.XString")), string, null, stringableFilter)).getValue();
        }

        public String demandString(String string, String string2) {
            return this.demandString(string, string2, null);
        }

        public String demandString(String string, String string2, StringableFilter stringableFilter) {
            return ((XString)this.demandObject(class$edu$neu$ccs$XString != null ? class$edu$neu$ccs$XString : (class$edu$neu$ccs$XString = ConsoleGateway.class$("edu.neu.ccs.XString")), string, String.valueOf(string2), stringableFilter)).getValue();
        }

        public String requestString(String string) throws CancelledException {
            return this.requestString(string, null);
        }

        public String requestString(String string, StringableFilter stringableFilter) throws CancelledException {
            return ((XString)this.requestObject(class$edu$neu$ccs$XString != null ? class$edu$neu$ccs$XString : (class$edu$neu$ccs$XString = ConsoleGateway.class$("edu.neu.ccs.XString")), string, stringableFilter)).getValue();
        }

        public BigInteger demandBigInteger(String string) {
            return this.demandBigInteger(string, (StringableFilter)null);
        }

        public BigInteger demandBigInteger(String string, StringableFilter stringableFilter) {
            return ((XBigInteger)this.demandObject(class$edu$neu$ccs$XBigInteger != null ? class$edu$neu$ccs$XBigInteger : (class$edu$neu$ccs$XBigInteger = ConsoleGateway.class$("edu.neu.ccs.XBigInteger")), string, null, stringableFilter)).getValue();
        }

        public BigInteger demandBigInteger(String string, BigInteger bigInteger) {
            return this.demandBigInteger(string, bigInteger, null);
        }

        public BigInteger demandBigInteger(String string, BigInteger bigInteger, StringableFilter stringableFilter) {
            String string2 = bigInteger == null ? null : String.valueOf(String.valueOf(bigInteger));
            return ((XBigInteger)this.demandObject(class$edu$neu$ccs$XBigInteger != null ? class$edu$neu$ccs$XBigInteger : (class$edu$neu$ccs$XBigInteger = ConsoleGateway.class$("edu.neu.ccs.XBigInteger")), string, string2, stringableFilter)).getValue();
        }

        public BigInteger requestBigInteger(String string) throws CancelledException {
            return this.requestBigInteger(string, null);
        }

        public BigInteger requestBigInteger(String string, StringableFilter stringableFilter) throws CancelledException {
            return ((XBigInteger)this.requestObject(class$edu$neu$ccs$XBigInteger != null ? class$edu$neu$ccs$XBigInteger : (class$edu$neu$ccs$XBigInteger = ConsoleGateway.class$("edu.neu.ccs.XBigInteger")), string, stringableFilter)).getValue();
        }

        public BigDecimal demandBigDecimal(String string) {
            return this.demandBigDecimal(string, (StringableFilter)null);
        }

        public BigDecimal demandBigDecimal(String string, StringableFilter stringableFilter) {
            return ((XBigDecimal)this.demandObject(class$edu$neu$ccs$XBigDecimal != null ? class$edu$neu$ccs$XBigDecimal : (class$edu$neu$ccs$XBigDecimal = ConsoleGateway.class$("edu.neu.ccs.XBigDecimal")), string, null, stringableFilter)).getValue();
        }

        public BigDecimal demandBigDecimal(String string, BigDecimal bigDecimal) {
            return this.demandBigDecimal(string, bigDecimal, null);
        }

        public BigDecimal demandBigDecimal(String string, BigDecimal bigDecimal, StringableFilter stringableFilter) {
            String string2 = bigDecimal == null ? null : String.valueOf(String.valueOf(bigDecimal));
            return ((XBigDecimal)this.demandObject(class$edu$neu$ccs$XBigDecimal != null ? class$edu$neu$ccs$XBigDecimal : (class$edu$neu$ccs$XBigDecimal = ConsoleGateway.class$("edu.neu.ccs.XBigDecimal")), string, string2, stringableFilter)).getValue();
        }

        public BigDecimal requestBigDecimal(String string) throws CancelledException {
            return this.requestBigDecimal(string, null);
        }

        public BigDecimal requestBigDecimal(String string, StringableFilter stringableFilter) throws CancelledException {
            return ((XBigDecimal)this.requestObject(class$edu$neu$ccs$XBigDecimal != null ? class$edu$neu$ccs$XBigDecimal : (class$edu$neu$ccs$XBigDecimal = ConsoleGateway.class$("edu.neu.ccs.XBigDecimal")), string, stringableFilter)).getValue();
        }

        public Color demandColor(String string) {
            return this.demandColor(string, (StringableFilter)null);
        }

        public Color demandColor(String string, StringableFilter stringableFilter) {
            return ((XColor)this.demandObject(class$edu$neu$ccs$XColor != null ? class$edu$neu$ccs$XColor : (class$edu$neu$ccs$XColor = ConsoleGateway.class$("edu.neu.ccs.XColor")), string, null, stringableFilter)).getValue();
        }

        public Color demandColor(String string, Color color) {
            return this.demandColor(string, color, null);
        }

        public Color demandColor(String string, Color color, StringableFilter stringableFilter) {
            String string2 = color == null ? null : XColor.colorToString(color);
            return ((XColor)this.demandObject(class$edu$neu$ccs$XColor != null ? class$edu$neu$ccs$XColor : (class$edu$neu$ccs$XColor = ConsoleGateway.class$("edu.neu.ccs.XColor")), string, string2, stringableFilter)).getValue();
        }

        public Color requestColor(String string) throws CancelledException {
            return this.requestColor(string, null);
        }

        public Color requestColor(String string, StringableFilter stringableFilter) throws CancelledException {
            return ((XColor)this.requestObject(class$edu$neu$ccs$XColor != null ? class$edu$neu$ccs$XColor : (class$edu$neu$ccs$XColor = ConsoleGateway.class$("edu.neu.ccs.XColor")), string, stringableFilter)).getValue();
        }
    }

    public class ConsoleOutputStream
    extends OutputStream {
        private int stream = 0;

        public ConsoleOutputStream(int n) {
            this.stream = n;
        }

        public void close() {
        }

        public void flush() throws IOException {
            ConsoleGateway.this.flush(this.stream);
        }

        public void write(byte[] byArray) {
            ConsoleGateway.this.write(new String(byArray), this.stream);
        }

        public void write(byte[] byArray, int n, int n2) {
            ConsoleGateway.this.write(new String(byArray, n, n2), this.stream);
        }

        public void write(int n) {
            ConsoleGateway.this.write(String.valueOf((char)n), this.stream);
        }
    }
}

