/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.XRect;
import edu.neu.ccs.util.JPTConstants;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import javax.swing.event.SwingPropertyChangeSupport;

public class XSquare
extends XRect
implements Serializable,
Stringable,
JPTConstants {
    private static String[] BLANK = new String[]{"", "", ""};
    private static String[] XYR = new String[]{"xc", "yc", "r"};
    public static final String standardMessage = "\nXSquare Error: Data format must be\n[...;...;...] or\n[xc=...;yc=...;r=...]\nwhere ... stands for\nthe center data xc,yc\nand the radius r\n";
    private double r;
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);

    public XSquare() {
    }

    public XSquare(double x, double y, double r) {
        this.setXYR(x, y, r);
    }

    public XSquare(double r) {
        this.setXYR(0.0, 0.0, r);
    }

    public XSquare(XSquare square) {
        this.setSquare(square);
    }

    public String toString() {
        double xc = this.getCenterX();
        double yc = this.getCenterY();
        return "XSquare[xc=" + xc + ";yc=" + yc + ";r=" + this.r + "]";
    }

    public String toStringData() {
        double xc = this.getCenterX();
        double yc = this.getCenterY();
        return "[" + xc + ";" + yc + ";" + this.r + "]";
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException(standardMessage, -1);
        }
        String[] strings = Strings.decode(data);
        if (strings == null) {
            throw new ParseException(standardMessage, -1);
        }
        if (strings.length != 3) {
            throw new ParseException(standardMessage, -1);
        }
        Object[] names = Strings.getNames(strings);
        String[] values = Strings.getValues(strings);
        if (!Arrays.equals(names, BLANK) && !Arrays.equals(names, XYR)) {
            throw new ParseException(standardMessage, -1);
        }
        names = XYR;
        double[] result = null;
        try {
            result = Strings.stringsToDoubles(values);
        }
        catch (ParseException ex) {
            throw Strings.makeAdjustedParseException(ex, "XSquare", (String[])names);
        }
        this.setXYR(result[0], result[1], result[2]);
    }

    public void setXYR(double xc, double yc, double r) {
        this.r = r = Math.abs(r);
        double d = 2.0 * r;
        super.setXYWH(xc - r, yc - r, d, d);
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public void setSquare(XSquare square) {
        if (square == null) {
            return;
        }
        double xc = square.getCenterX();
        double yc = square.getCenterY();
        double r = square.getRadius();
        this.setXYR(xc, yc, r);
    }

    public double getRadius() {
        return this.r;
    }

    public void setXYWH(double x, double y, double w, double h) {
    }

    public void move(double dx, double dy) {
        double xc = this.getCenterX();
        double yc = this.getCenterY();
        double r = this.getRadius();
        this.setXYR(this.x + dx, this.y + dy, r);
    }

    public void move(Point2D p) {
        if (p == null) {
            return;
        }
        this.move(p.getX(), p.getY());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }
}

