/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.FunctionComplex;
import edu.neu.ccs.ParameterComplex;
import edu.neu.ccs.Stringable;
import edu.neu.ccs.Strings;
import edu.neu.ccs.XComplex;
import edu.neu.ccs.util.JPTConstants;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;
import javax.swing.event.SwingPropertyChangeSupport;

public class XPolynomialComplex
implements FunctionComplex.OneArg,
ParameterComplex.ArrayParam,
Stringable,
JPTConstants,
Serializable {
    public static final String standardMessage = "\nXPolynomialComplex Error: Data format must be\n{[...;...]|[...;...]|[...;...]|etc} or\n{c0=[...;...]|c1=[...;...]|c2=[...;...]|etc}\nwhere [...;...] stands for the complex numbers\nthat constitute the polynomial coefficients\nin increasing order starting at index 0\nfrom left to right\n";
    private static String divisionMessage = "Division by zero in class XPolynomialComplex";
    protected XComplex[] coefficients = null;
    protected SwingPropertyChangeSupport changeAdapter = new SwingPropertyChangeSupport(this);

    public XPolynomialComplex() {
    }

    public XPolynomialComplex(int capacity) {
        this.setCapacity(capacity);
    }

    public XPolynomialComplex(XComplex[] params) {
        this.setCoefficients(params);
    }

    public XPolynomialComplex(double[][] params) {
        this.setCoefficients(params);
    }

    public XPolynomialComplex(float[][] params) {
        this.setCoefficients(params);
    }

    public XPolynomialComplex(XPolynomialComplex polynomial) {
        if (polynomial != null) {
            this.setCoefficients(polynomial.coefficients);
        }
    }

    public XPolynomialComplex(String data) throws ParseException {
        this.fromStringData(data);
    }

    public XPolynomialComplex(String[] strings) throws ParseException {
        this.fromStringArrayData(strings);
    }

    public void setPolynomialToZero() {
        this.coefficients = null;
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public int getDegree() {
        if (this.coefficients == null) {
            return -1;
        }
        int d = this.coefficients.length - 1;
        while (d >= 0 && XComplex.isZero(this.coefficients[d])) {
            --d;
        }
        return d;
    }

    public int getCapacity() {
        if (this.coefficients == null) {
            return -1;
        }
        return this.coefficients.length - 1;
    }

    public void setCapacity(int capacity) {
        if (capacity < 0) {
            capacity = -1;
        }
        if (this.getCapacity() == capacity) {
            return;
        }
        int d = this.getDegree();
        if (capacity < 0) {
            this.coefficients = null;
        } else {
            int size = capacity + 1;
            XComplex[] data = new XComplex[size];
            if (this.coefficients != null) {
                size = Math.min(size, this.coefficients.length);
                int i = 0;
                while (i < size) {
                    data[i] = this.coefficients[i];
                    ++i;
                }
            }
            this.coefficients = data;
        }
        if (capacity < d) {
            this.changeAdapter.firePropertyChange("value", null, null);
        }
    }

    public void shrinkCapacity() {
        this.setCapacity(this.getDegree());
    }

    public XComplex[] getCoefficients() {
        int d = this.getDegree();
        XComplex[] values = new XComplex[d + 1];
        int i = 0;
        while (i <= d) {
            values[i] = XComplex.copy(this.coefficients[i]);
            ++i;
        }
        return values;
    }

    public double[][] toData() {
        int d = this.getDegree();
        double[][] values = new double[d + 1][0];
        int i = 0;
        while (i <= d) {
            values[i] = XComplex.toData(this.coefficients[i]);
            ++i;
        }
        return values;
    }

    public void setCoefficients(XComplex[] params) {
        this.coefficients = params == null || params.length == 0 ? null : XComplex.copy(params);
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public void setCoefficients(double[][] params) {
        this.coefficients = params == null || params.length == 0 ? null : XComplex.copyData(params);
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public void setCoefficients(float[][] params) {
        this.coefficients = params == null || params.length == 0 ? null : XComplex.copyData(params);
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public void setCoefficients(XPolynomialComplex polynomial) {
        if (polynomial == null) {
            this.setPolynomialToZero();
        } else {
            this.setCoefficients(polynomial.coefficients);
        }
    }

    public XComplex getCoefficient(int index) {
        if (index < 0) {
            return null;
        }
        int capacity = this.getCapacity();
        if (index > capacity) {
            return null;
        }
        return XComplex.copy(this.coefficients[index]);
    }

    public void setCoefficient(int index, XComplex value) {
        if (index < 0) {
            return;
        }
        int capacity = this.getCapacity();
        if (index > capacity) {
            this.setCapacity(index);
        }
        this.coefficients[index] = XComplex.copy(value);
        this.changeAdapter.firePropertyChange("value", null, null);
    }

    public double maxCoefficient() {
        int d = this.getDegree();
        if (d == -1) {
            return 0.0;
        }
        double max = XComplex.maxabs(this.coefficients[d]);
        int i = 0;
        while (i < d) {
            max = Math.max(max, XComplex.maxabs(this.coefficients[i]));
            ++i;
        }
        return max;
    }

    public boolean isZero() {
        return this.getDegree() == -1;
    }

    public boolean isAlmostZero(double epsilon) {
        int d = this.getDegree();
        if (d == -1) {
            return true;
        }
        epsilon = Math.abs(epsilon);
        int i = 0;
        while (i <= d) {
            if (XComplex.maxabs(this.coefficients[i]) > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEqualTo(XPolynomialComplex p) {
        if (p == null) {
            return this.isZero();
        }
        int d = this.getDegree();
        int e = p.getDegree();
        if (e != d) {
            return false;
        }
        int i = 0;
        while (i <= d) {
            if (!XComplex.isEqualTo(this.coefficients[i], p.coefficients[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isAlmostEqualTo(XPolynomialComplex p, double epsilon) {
        if (p == null) {
            return this.isAlmostZero(epsilon);
        }
        int d = this.getDegree();
        int e = p.getDegree();
        int n = Math.max(d, e);
        epsilon = Math.abs(epsilon);
        int i = 0;
        while (i <= n) {
            double max;
            double x1 = 0.0;
            double y1 = 0.0;
            double x2 = 0.0;
            double y2 = 0.0;
            if (i <= d && this.coefficients[i] != null) {
                x1 = this.coefficients[i].Re();
                y1 = this.coefficients[i].Im();
            }
            if (i <= e && p.coefficients[i] != null) {
                x2 = p.coefficients[i].Re();
                y2 = p.coefficients[i].Im();
            }
            if ((max = Math.max(Math.abs(x1 - x2), Math.abs(y1 - y2))) > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public XComplex evaluate(XComplex x) {
        int d = this.getDegree();
        if (d < 0) {
            return new XComplex();
        }
        if (XComplex.isZero(x)) {
            return new XComplex(this.coefficients[0]);
        }
        XComplex result = new XComplex(this.coefficients[d]);
        int i = d - 1;
        while (i >= 0) {
            result.multiply(x);
            result.add(this.coefficients[i]);
            --i;
        }
        return result;
    }

    public void setParam(XComplex[] params) {
        this.setCoefficients(params);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("XPolynomialComplex{");
        int d = this.getDegree();
        int i = 0;
        while (i <= d) {
            buffer.append('c');
            buffer.append(Integer.toString(i));
            buffer.append('=');
            buffer.append(XComplex.toStringData(this.coefficients[i]));
            if (i < d) {
                buffer.append('|');
            }
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public String toStringData() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        int d = this.getDegree();
        int i = 0;
        while (i <= d) {
            buffer.append(XComplex.toStringData(this.coefficients[i]));
            if (i < d) {
                buffer.append('|');
            }
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public String[] toStringArrayData() {
        int d = this.getDegree();
        String[] strings = new String[d + 1];
        int i = 0;
        while (i <= d) {
            strings[i] = XComplex.toStringData(this.coefficients[i]);
            ++i;
        }
        return strings;
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException(standardMessage, -1);
        }
        String[] split = Strings.splitIn2(data = data.trim());
        String input = split[1].trim();
        if (!Strings.isStartEnd(input, '{', '}')) {
            throw new ParseException(standardMessage, -1);
        }
        String[] items = Strings.trim(Strings.decode(input));
        this.fromStringArrayData(items);
    }

    public void fromStringArrayData(String[] strings) throws ParseException {
        if (strings == null) {
            throw new ParseException(standardMessage, -1);
        }
        String[] values = Strings.getValues(strings);
        try {
            this.setCoefficients(Strings.stringsToXComplexValues(values));
        }
        catch (ParseException ex) {
            String message = ex.getMessage();
            int offset = ex.getErrorOffset();
            message = "\nXPolynomial error in term " + message + "\nat offset " + offset + "\n";
            throw new ParseException(message, -1);
        }
    }

    public static XPolynomialComplex scale(XComplex f, XPolynomialComplex p) {
        if (p == null || XComplex.isZero(f)) {
            return new XPolynomialComplex();
        }
        int d = p.getDegree();
        if (d == -1) {
            return new XPolynomialComplex();
        }
        XPolynomialComplex result = new XPolynomialComplex(d);
        int i = 0;
        while (i <= d) {
            result.coefficients[i] = XComplex.multiply(f, p.coefficients[i]);
            ++i;
        }
        return result;
    }

    public static XPolynomialComplex add(XPolynomialComplex p, XPolynomialComplex q) {
        if (p == null) {
            return new XPolynomialComplex(q);
        }
        if (q == null) {
            return new XPolynomialComplex(p);
        }
        int d = p.getDegree();
        int e = q.getDegree();
        if (d == -1) {
            return new XPolynomialComplex(q);
        }
        if (e == -1) {
            return new XPolynomialComplex(p);
        }
        int n = Math.max(d, e);
        XPolynomialComplex result = new XPolynomialComplex(n);
        int i = 0;
        while (i <= n) {
            double x1 = 0.0;
            double y1 = 0.0;
            double x2 = 0.0;
            double y2 = 0.0;
            if (i <= d && p.coefficients[i] != null) {
                x1 = p.coefficients[i].Re();
                y1 = p.coefficients[i].Im();
            }
            if (i <= e && q.coefficients[i] != null) {
                x2 = q.coefficients[i].Re();
                y2 = q.coefficients[i].Im();
            }
            result.coefficients[i] = XComplex.add(x1, y1, x2, y2);
            ++i;
        }
        return result;
    }

    public static XPolynomialComplex subtract(XPolynomialComplex p, XPolynomialComplex q) {
        if (p == null) {
            return new XPolynomialComplex(q);
        }
        if (q == null) {
            return new XPolynomialComplex(p);
        }
        int d = p.getDegree();
        int e = q.getDegree();
        if (d == -1) {
            return new XPolynomialComplex(q);
        }
        if (e == -1) {
            return new XPolynomialComplex(p);
        }
        int n = Math.max(d, e);
        XPolynomialComplex result = new XPolynomialComplex(n);
        int i = 0;
        while (i <= n) {
            double x1 = 0.0;
            double y1 = 0.0;
            double x2 = 0.0;
            double y2 = 0.0;
            if (i <= d && p.coefficients[i] != null) {
                x1 = p.coefficients[i].Re();
                y1 = p.coefficients[i].Im();
            }
            if (i <= e && q.coefficients[i] != null) {
                x2 = q.coefficients[i].Re();
                y2 = q.coefficients[i].Im();
            }
            result.coefficients[i] = XComplex.subtract(x1, y1, x2, y2);
            ++i;
        }
        return result;
    }

    public static XPolynomialComplex multiply(XPolynomialComplex p, XPolynomialComplex q) {
        if (p == null || q == null) {
            return new XPolynomialComplex();
        }
        int d = p.getDegree();
        int e = q.getDegree();
        if (d == -1 || e == -1) {
            return new XPolynomialComplex();
        }
        int n = d + e;
        XPolynomialComplex result = new XPolynomialComplex(n);
        int k = 0;
        while (k <= n) {
            result.coefficients[k] = new XComplex();
            ++k;
        }
        int i = 0;
        while (i <= d) {
            int j = 0;
            while (j <= e) {
                result.coefficients[i + j].addProduct(p.coefficients[i], q.coefficients[j]);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static XPolynomialComplex[] divide(XPolynomialComplex p, XPolynomialComplex q) {
        if (q == null) {
            throw new ArithmeticException(divisionMessage);
        }
        int e = q.getDegree();
        if (e == -1) {
            throw new ArithmeticException(divisionMessage);
        }
        if (p == null) {
            return new XPolynomialComplex[]{new XPolynomialComplex(), new XPolynomialComplex()};
        }
        int d = p.getDegree();
        if (d == -1) {
            return new XPolynomialComplex[]{new XPolynomialComplex(), new XPolynomialComplex()};
        }
        int n = d - e;
        XPolynomialComplex quo = new XPolynomialComplex(n);
        XPolynomialComplex rem = new XPolynomialComplex(p);
        if (n >= 0) {
            int k = 0;
            while (k <= d) {
                if (rem.coefficients[k] == null) {
                    rem.coefficients[k] = new XComplex();
                }
                ++k;
            }
            XComplex leading = q.coefficients[e];
            int i = n;
            while (i >= 0) {
                XComplex ratio;
                quo.coefficients[i] = ratio = XComplex.divide(rem.coefficients[e + i], leading);
                rem.coefficients[e + i] = null;
                int j = 0;
                while (j < e) {
                    rem.coefficients[j + i].subtractProduct(ratio, q.coefficients[j]);
                    ++j;
                }
                --i;
            }
        }
        rem.shrinkCapacity();
        return new XPolynomialComplex[]{quo, rem};
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeAdapter.removePropertyChangeListener(propertyName, listener);
    }
}

