/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.Strings;
import edu.neu.ccs.XPoint2D;
import edu.neu.ccs.util.MathUtilities;
import java.awt.geom.Point2D;
import java.text.ParseException;
import java.util.Arrays;

public class XComplex
extends XPoint2D {
    public static final String complexMessage = "\nXComplex Error: Data format must be\n[...;...] or\n[x=...;y=...]\nwhere ... stands for\nthe x,y coordinate data\n";
    private static final double twopi = Math.PI * 2;

    public XComplex() {
    }

    public XComplex(double x) {
        this.setValue(x);
    }

    public XComplex(double x, double y) {
        this.setValue(x, y);
    }

    public XComplex(Point2D p) {
        this.setValue(p);
    }

    public XComplex(double[] data) {
        this.setValue(data);
    }

    public XComplex(float[] data) {
        this.setValue(data);
    }

    public XComplex(String data) throws ParseException {
        this.fromStringData(data);
    }

    public String toString() {
        return "XComplex[x=" + this.x + ";y=" + this.y + "]";
    }

    public static String toString(XComplex z) {
        return z == null ? "XComplex[x=0;y=0]" : z.toString();
    }

    public static String toStringData(XComplex z) {
        return z == null ? "[0;0]" : z.toStringData();
    }

    public void fromStringData(String data) throws ParseException {
        if (data == null) {
            throw new ParseException(complexMessage, -1);
        }
        String[] strings = Strings.decode(data);
        if (strings == null) {
            throw new ParseException(complexMessage, -1);
        }
        if (strings.length != 2) {
            throw new ParseException(complexMessage, -1);
        }
        Object[] names = Strings.getNames(strings);
        String[] values = Strings.getValues(strings);
        if (!Arrays.equals(names, XPoint2D.BLANK) && !Arrays.equals(names, XPoint2D.XY)) {
            throw new ParseException(complexMessage, -1);
        }
        names = XPoint2D.XY;
        double[] result = null;
        try {
            result = Strings.stringsToDoubles(values);
        }
        catch (ParseException ex) {
            throw Strings.makeAdjustedParseException(ex, "XComplex", (String[])names);
        }
        this.setValue(result[0], result[1]);
    }

    public final void setValue(double x) {
        this.setValue(x, 0.0);
    }

    public static XComplex copy(XComplex z) {
        return z == null ? null : new XComplex(z);
    }

    public static XComplex copyData(double[] data) {
        return data == null ? null : new XComplex(data);
    }

    public static XComplex copyData(float[] data) {
        return data == null ? null : new XComplex(data);
    }

    public static double[] toData(XComplex z) {
        double[] dArray;
        if (z == null) {
            dArray = null;
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = z.x;
            dArray = dArray2;
            dArray2[1] = z.y;
        }
        return dArray;
    }

    public static XComplex[] copy(XComplex[] array) {
        if (array == null) {
            return null;
        }
        int length = array.length;
        XComplex[] result = new XComplex[length];
        int i = 0;
        while (i < length) {
            result[i] = XComplex.copy(array[i]);
            ++i;
        }
        return result;
    }

    public static XComplex[] copyData(double[][] array) {
        if (array == null) {
            return null;
        }
        int length = array.length;
        XComplex[] result = new XComplex[length];
        int i = 0;
        while (i < length) {
            result[i] = XComplex.copyData(array[i]);
            ++i;
        }
        return result;
    }

    public static XComplex[] copyData(float[][] array) {
        if (array == null) {
            return null;
        }
        int length = array.length;
        XComplex[] result = new XComplex[length];
        int i = 0;
        while (i < length) {
            result[i] = XComplex.copyData(array[i]);
            ++i;
        }
        return result;
    }

    public static double[][] toData(XComplex[] array) {
        if (array == null) {
            return null;
        }
        int length = array.length;
        double[][] result = new double[length][];
        int i = 0;
        while (i < length) {
            result[i] = XComplex.toData(array[i]);
            ++i;
        }
        return result;
    }

    public final void negate() {
        this.setValue(-this.x, -this.y);
    }

    public static XComplex negate(XComplex z) {
        return z == null ? new XComplex() : new XComplex(-z.x, -z.y);
    }

    public final void scale(double s) {
        this.setValue(s * this.x, s * this.y);
    }

    public static XComplex scale(double s, XComplex z) {
        return z == null ? new XComplex() : new XComplex(s * z.x, s * z.y);
    }

    public final void conjugate() {
        this.setValue(this.x, -this.y);
    }

    public static XComplex conjugate(XComplex z) {
        return z == null ? new XComplex() : new XComplex(z.x, -z.y);
    }

    public final void invert() {
        if (this.x == 0.0 && this.y == 0.0) {
            throw new ArithmeticException("Zero divisor in XComplex.invert");
        }
        double rr = this.x * this.x + this.y * this.y;
        this.setValue(this.x / rr, -this.y / rr);
    }

    public static XComplex invert(XComplex z) {
        if (XComplex.isZero(z)) {
            throw new ArithmeticException("Zero divisor in XComplex.invert");
        }
        double rr = z.x * z.x + z.y * z.y;
        double xx = z.x / rr;
        double yy = -z.y / rr;
        return new XComplex(xx, yy);
    }

    public final void add(XComplex w) {
        if (XComplex.isZero(w)) {
            return;
        }
        this.add(w.x, w.y);
    }

    public final void add(double x, double y) {
        this.setValue(this.x + x, this.y + y);
    }

    public static XComplex add(XComplex z, XComplex w) {
        if (XComplex.isZero(z)) {
            return new XComplex(w);
        }
        if (XComplex.isZero(w)) {
            return new XComplex(z);
        }
        return XComplex.add(z.x, z.y, w.x, w.y);
    }

    public static XComplex add(double x1, double y1, double x2, double y2) {
        return new XComplex(x1 + x2, y1 + y2);
    }

    public final void subtract(XComplex w) {
        if (XComplex.isZero(w)) {
            return;
        }
        this.subtract(w.x, w.y);
    }

    public final void subtract(double x, double y) {
        this.setValue(this.x - x, this.y - y);
    }

    public static XComplex subtract(XComplex z, XComplex w) {
        if (XComplex.isZero(z)) {
            return XComplex.negate(w);
        }
        if (XComplex.isZero(w)) {
            return new XComplex(z);
        }
        return XComplex.subtract(z.x, z.y, w.x, w.y);
    }

    public static XComplex subtract(double x1, double y1, double x2, double y2) {
        return new XComplex(x1 - x2, y1 - y2);
    }

    public final void multiply(XComplex w) {
        if (XComplex.isZero(w)) {
            this.setValue(0.0, 0.0);
        } else {
            this.multiply(w.x, w.y);
        }
    }

    public final void multiply(double x, double y) {
        double xx = this.x * x - this.y * y;
        double yy = this.x * y + this.y * x;
        this.setValue(xx, yy);
    }

    public static XComplex multiply(XComplex z, XComplex w) {
        if (XComplex.isZero(z) || XComplex.isZero(w)) {
            return new XComplex();
        }
        return XComplex.multiply(z.x, z.y, w.x, w.y);
    }

    public static XComplex multiply(double x1, double y1, double x2, double y2) {
        double xx = x1 * x2 - y1 * y2;
        double yy = x1 * y2 + y1 * x2;
        return new XComplex(xx, yy);
    }

    public final void divide(XComplex w) {
        if (XComplex.isZero(w)) {
            throw new ArithmeticException("Zero divisor in XComplex.divide");
        }
        this.divide(w.x, w.y);
    }

    public final void divide(double x, double y) {
        if (x == 0.0 && y == 0.0) {
            throw new ArithmeticException("Zero divisor in XComplex.divide");
        }
        double rr = x * x + y * y;
        double xx = x / rr;
        double yy = -y / rr;
        this.multiply(xx, yy);
    }

    public static XComplex divide(XComplex z, XComplex w) {
        if (XComplex.isZero(w)) {
            throw new ArithmeticException("Zero divisor in XComplex.divide");
        }
        if (XComplex.isZero(z)) {
            return new XComplex();
        }
        return XComplex.divide(z.x, z.y, w.x, w.y);
    }

    public static XComplex divide(double x1, double y1, double x2, double y2) {
        if (x2 == 0.0 && y2 == 0.0) {
            throw new ArithmeticException("Zero divisor in XComplex.divide");
        }
        if (x1 == 0.0 && y1 == 0.0) {
            return new XComplex();
        }
        double rr = x2 * x2 + y2 * y2;
        double xx = x2 / rr;
        double yy = -y2 / rr;
        return XComplex.multiply(x1, y1, xx, yy);
    }

    public final void addProduct(XComplex z, XComplex w) {
        if (XComplex.isZero(z) || XComplex.isZero(w)) {
            return;
        }
        this.addProduct(z.x, z.y, w.x, w.y);
    }

    public final void addProduct(double x1, double y1, double x2, double y2) {
        double xx = x1 * x2 - y1 * y2;
        double yy = x1 * y2 + y1 * x2;
        this.setValue(this.x + xx, this.y + yy);
    }

    public final void subtractProduct(XComplex z, XComplex w) {
        if (XComplex.isZero(z) || XComplex.isZero(w)) {
            return;
        }
        this.subtractProduct(z.x, z.y, w.x, w.y);
    }

    public final void subtractProduct(double x1, double y1, double x2, double y2) {
        double xx = x1 * x2 - y1 * y2;
        double yy = x1 * y2 + y1 * x2;
        this.setValue(this.x - xx, this.y - yy);
    }

    public static XComplex makeUsingRadiusAndRadians(double radius, double radians) {
        if (radius == 0.0) {
            return new XComplex();
        }
        double x = Math.cos(radians);
        double y = Math.sin(radians);
        return new XComplex(radius * x, radius * y);
    }

    public static XComplex makeUsingRadiusAndDegrees(double radius, double degrees) {
        if (radius == 0.0) {
            return new XComplex();
        }
        double x = MathUtilities.cosdeg(degrees);
        double y = MathUtilities.sindeg(degrees);
        return new XComplex(radius * x, radius * y);
    }

    public final double Re() {
        return this.x;
    }

    public static double Re(XComplex z) {
        return z == null ? 0.0 : z.x;
    }

    public final double Im() {
        return this.y;
    }

    public static double Im(XComplex z) {
        return z == null ? 0.0 : z.y;
    }

    public final double abs() {
        return this.radius();
    }

    public static double abs(XComplex z) {
        return z == null ? 0.0 : z.radius();
    }

    public final double maxabs() {
        return Math.max(Math.abs(this.x), Math.abs(this.y));
    }

    public static double maxabs(XComplex z) {
        return z == null ? 0.0 : z.maxabs();
    }

    public final boolean isZero() {
        return this.x == 0.0 && this.y == 0.0;
    }

    public static boolean isZero(XComplex z) {
        return z == null ? true : z.isZero();
    }

    public final boolean isAlmostZero(double epsilon) {
        epsilon = Math.abs(epsilon);
        return this.maxabs() <= epsilon;
    }

    public static boolean isAlmostZero(XComplex z, double epsilon) {
        return z == null ? true : z.isAlmostZero(epsilon);
    }

    public final boolean isEqualTo(XComplex w) {
        return w == null ? this.isZero() : this.x == w.x && this.y == w.y;
    }

    public static boolean isEqualTo(XComplex z, XComplex w) {
        if (z == null && w == null) {
            return true;
        }
        if (z == null) {
            return w.isZero();
        }
        if (w == null) {
            return z.isZero();
        }
        return z.x == w.x && z.y == w.y;
    }

    public final boolean isAlmostEqualTo(XComplex w, double epsilon) {
        if (w == null) {
            return this.isAlmostZero(epsilon);
        }
        epsilon = Math.abs(epsilon);
        return Math.max(Math.abs(this.x - w.x), Math.abs(this.y - w.y)) <= epsilon;
    }

    public static boolean isAlmostEqualTo(XComplex z, XComplex w, double epsilon) {
        if (z == null && w == null) {
            return true;
        }
        if (z == null) {
            return w.isAlmostZero(epsilon);
        }
        if (w == null) {
            return z.isAlmostZero(epsilon);
        }
        epsilon = Math.abs(epsilon);
        return Math.max(Math.abs(z.x - w.x), Math.abs(z.y - w.y)) <= epsilon;
    }

    public static XComplex exp(XComplex z) {
        double rr;
        if (z == null) {
            return new XComplex(1.0);
        }
        double d = rr = z.x == 0.0 ? 1.0 : Math.exp(z.x);
        if (z.y == 0.0) {
            return new XComplex(rr);
        }
        double xx = rr * Math.cos(z.y);
        double yy = rr * Math.sin(z.y);
        return new XComplex(xx, yy);
    }

    public static XComplex log(XComplex z) {
        if (XComplex.isZero(z)) {
            throw new ArithmeticException("Zero argument in XComplex.log");
        }
        double radius = z.radius();
        double radians = z.angleInRadians();
        return new XComplex(Math.log(radius), radians);
    }

    public static XComplex sqrt(XComplex z) {
        if (XComplex.isZero(z)) {
            return new XComplex();
        }
        double radius = z.radius();
        double radians = z.angleInRadians();
        return XComplex.makeUsingRadiusAndRadians(Math.sqrt(radius), radians / 2.0);
    }

    public static XComplex power(XComplex z, int n) {
        if (z == null) {
            throw new ArithmeticException("Null argument in XComplex.power");
        }
        if (n < 0 && z.x == 0.0 && z.y == 0.0) {
            throw new ArithmeticException("Negative exponent and zero argument in XComplex.power");
        }
        XComplex result = new XComplex(1.0);
        if (n == 0) {
            return result;
        }
        if (n > 0) {
            z = new XComplex(z);
        } else {
            n = -n;
            z = XComplex.invert(z);
        }
        while (n > 0) {
            if (n % 2 != 0) {
                result.multiply(z);
                --n;
                continue;
            }
            z.multiply(z);
            n /= 2;
        }
        return result;
    }

    public static XComplex generalPower(XComplex z, double d) {
        if (z == null) {
            throw new ArithmeticException("Null argument in XComplex.generalPower");
        }
        if (z.x == 0.0 && z.y == 0.0) {
            throw new ArithmeticException("Zero argument in XComplex.generalPower");
        }
        if (d == 0.0) {
            return new XComplex(1.0);
        }
        return XComplex.exp(XComplex.scale(d, XComplex.log(z)));
    }

    public static XComplex generalPower(XComplex z, XComplex w) {
        if (z == null) {
            throw new ArithmeticException("Null argument in XComplex.generalPower");
        }
        if (z.x == 0.0 && z.y == 0.0) {
            throw new ArithmeticException("Zero argument in XComplex.generalPower");
        }
        if (XComplex.isZero(w)) {
            return new XComplex(1.0);
        }
        return XComplex.exp(XComplex.multiply(w, XComplex.log(z)));
    }

    public static XComplex rootOfUnity(int n, int k) {
        if (n <= 0) {
            throw new ArithmeticException("n-th root specifier is zero or negative in XComplex.rootOfUnity");
        }
        return XComplex.makeUsingRadiusAndRadians(1.0, Math.PI * 2 * (double)k / (double)n);
    }

    public static XComplex[] rootsOfUnity(int n) {
        if (n <= 0) {
            throw new ArithmeticException("n-th root specifier is zero or negative in XComplex.rootsOfUnity");
        }
        XComplex[] result = new XComplex[n];
        int k = 0;
        while (k < n) {
            result[k] = XComplex.makeUsingRadiusAndRadians(1.0, Math.PI * 2 * (double)k / (double)n);
            ++k;
        }
        return result;
    }
}

