/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs;

import edu.neu.ccs.XNumber;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.parser.ParserUtilities;
import java.math.BigInteger;
import java.text.ParseException;

public class XBigInteger
extends XNumber
implements Comparable {
    private static final BigInteger ZERO = BigInteger.ZERO;
    private static final BigInteger MINUSONE = new BigInteger("-1");
    private static final char zero = '0';
    private static final char one = '1';
    private static final char period = '.';
    private static final String positive = "...0";
    private static final String negative = "...1";
    public static final String standardMessage = "\nXBigInteger Error: Data format must be\na big integer in decimal format with an optional sign\nor a big integer expression with data in decimal format\nor a binary bit representation formatted as follows.\nRepresent a positive big integer in binary bits as ...0bbb\nRepresent a negative big integer in binary bits as ...1bbb\nThe prefix ...0 or ...1 is mandatory and must be typed as is\nThe sequence bbb stands for zero or more additional 0,1 digits\n";
    private BigInteger value = BigInteger.ZERO;

    public XBigInteger() {
    }

    public XBigInteger(BigInteger bigInteger) {
        this.setValue(bigInteger);
    }

    public XBigInteger(XBigInteger xBigInteger) {
        this.setValue(xBigInteger);
    }

    public XBigInteger(long l) {
        this.setValue(l);
    }

    public XBigInteger(String string) throws ParseException {
        this.fromStringData(string);
    }

    public XBigInteger(String string, int n) {
        this.setValue(string, n);
    }

    public XBigInteger(byte[] byArray) {
        this.setValue(byArray);
    }

    public final void fromStringData(String string) throws ParseException {
        if (string == null) {
            throw new ParseException("\nXBigInteger fromStringData(String) Error: Data was null\n", -1);
        }
        BigInteger bigInteger = this.value;
        int n = (string = string.trim()).length();
        if (n >= 4 && string.charAt(0) == '.') {
            this.fromBits(string);
        } else {
            try {
                Parser parser = ParserUtilities.getDefaultParser();
                Object object = parser.parse(string);
                if (object instanceof XNumber) {
                    XBigInteger xBigInteger = ParserUtilities.toXBigInteger((XNumber)object);
                    this.value = xBigInteger.getValue();
                }
            }
            catch (Exception exception) {
                throw new ParseException(standardMessage, -1);
            }
        }
        this.changeAdapter.firePropertyChange("value", bigInteger, this.value);
    }

    public final String toStringData() {
        return this.toString();
    }

    public final String toString() {
        return this.getValue().toString();
    }

    public final String toString(int n) {
        return this.getValue().toString(n);
    }

    public String toBits() {
        String string = "";
        int n = this.getValue().compareTo(BigInteger.ZERO);
        string = n >= 0 ? positive : negative;
        int n2 = this.getValue().bitLength();
        if (n2 == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = n2 - 1;
        int n4 = 0;
        while (n4 <= n3) {
            if (this.getValue().testBit(n3 - n4)) {
                stringBuffer.append('1');
            } else {
                stringBuffer.append('0');
            }
            ++n4;
        }
        return String.valueOf(string) + stringBuffer.toString();
    }

    private void fromBits(String string) throws ParseException {
        BigInteger bigInteger;
        if (string == null) {
            throw new ParseException("\nXBigInteger fromBits(String) Error: Data was null\n", -1);
        }
        if (string.startsWith(positive)) {
            bigInteger = ZERO;
        } else if (string.startsWith(negative)) {
            bigInteger = MINUSONE;
        } else {
            throw new ParseException(standardMessage, -1);
        }
        string = string.substring(4);
        int n = string.length();
        if (n == 0) {
            this.value = bigInteger;
            return;
        }
        int n2 = n - 1;
        bigInteger = bigInteger.shiftLeft(n);
        int n3 = 0;
        while (n3 <= n2) {
            if (string.charAt(n3) == '1') {
                bigInteger = bigInteger.setBit(n2 - n3);
            } else if (string.charAt(n3) == '0') {
                bigInteger = bigInteger.clearBit(n2 - n3);
            } else {
                throw new ParseException(standardMessage, -1);
            }
            ++n3;
        }
        this.value = bigInteger;
    }

    public final int digits() {
        String string = this.toString();
        int n = string.length();
        if (string.charAt(0) == '-') {
            return n - 1;
        }
        return n;
    }

    public final int digits(int n) {
        String string = this.toString(n);
        int n2 = string.length();
        if (string.charAt(0) == '-') {
            return n2 - 1;
        }
        return n2;
    }

    public final boolean equals(Object object) {
        if (object instanceof XBigInteger) {
            XBigInteger xBigInteger = (XBigInteger)object;
            return this.getValue().equals(xBigInteger.getValue());
        }
        return false;
    }

    public final int hashCode() {
        return this.getValue().hashCode();
    }

    public final void setValue(BigInteger bigInteger) {
        BigInteger bigInteger2 = this.value;
        BigInteger bigInteger3 = this.value = bigInteger == null ? BigInteger.ZERO : bigInteger;
        if (!this.value.equals(bigInteger2)) {
            this.changeAdapter.firePropertyChange("value", bigInteger2, this.value);
        }
    }

    public final void setValue(XBigInteger xBigInteger) {
        this.setValue(xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue());
    }

    public final void setValue(long l) {
        this.setValue(BigInteger.valueOf(l));
    }

    public final void setValue(String string) throws ParseException {
        if (string == null) {
            throw new ParseException("\nXBigInteger setValue(String) Error: Data was null\n", -1);
        }
        this.fromStringData(string);
    }

    public final void setValue(String string, int n) {
        if (string == null) {
            throw new NumberFormatException("\nXBigInteger setValue(String, int) Error: Data was null\n");
        }
        this.setValue(new BigInteger(string, n));
    }

    public final void setValue(byte[] byArray) {
        this.setValue(byArray == null || byArray.length == 0 ? BigInteger.ZERO : new BigInteger(byArray));
    }

    public final BigInteger getValue() {
        return this.value;
    }

    public final byte byteValue() {
        BigInteger bigInteger = new BigInteger("127");
        BigInteger bigInteger2 = new BigInteger("-128");
        if (this.getValue().compareTo(bigInteger) > 0 || this.getValue().compareTo(bigInteger2) < 0) {
            throw new NumberFormatException("Number beyond precision of a byte.");
        }
        return (byte)this.getValue().intValue();
    }

    public final short shortValue() {
        BigInteger bigInteger = new BigInteger("32767");
        BigInteger bigInteger2 = new BigInteger("-32768");
        if (this.getValue().compareTo(bigInteger) > 0 || this.getValue().compareTo(bigInteger2) < 0) {
            throw new NumberFormatException("Number beyond precision of a short.");
        }
        return (short)this.getValue().intValue();
    }

    public final int intValue() {
        BigInteger bigInteger = new BigInteger("2147483647");
        BigInteger bigInteger2 = new BigInteger("-2147483648");
        if (this.getValue().compareTo(bigInteger) > 0 || this.getValue().compareTo(bigInteger2) < 0) {
            throw new NumberFormatException("Number beyond precision of an int.");
        }
        return this.getValue().intValue();
    }

    public final long longValue() {
        BigInteger bigInteger = new BigInteger("9223372036854775807");
        BigInteger bigInteger2 = new BigInteger("-9223372036854775808");
        if (this.getValue().compareTo(bigInteger) > 0 || this.getValue().compareTo(bigInteger2) < 0) {
            throw new NumberFormatException("Number beyond precision of a long.");
        }
        return this.getValue().longValue();
    }

    public final float floatValue() {
        return this.getValue().floatValue();
    }

    public final double doubleValue() {
        return this.getValue().doubleValue();
    }

    public final int signum() {
        return this.getValue().signum();
    }

    public final void abs() {
        this.setValue(this.getValue().abs());
    }

    public static XBigInteger abs(XBigInteger xBigInteger) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        return new XBigInteger(bigInteger.abs());
    }

    public final void negate() {
        this.setValue(this.getValue().negate());
    }

    public static XBigInteger negate(XBigInteger xBigInteger) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        return new XBigInteger(bigInteger.negate());
    }

    public final void max(XBigInteger xBigInteger) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        this.setValue(this.getValue().max(bigInteger));
    }

    public static XBigInteger max(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger2 = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        return new XBigInteger(bigInteger.max(bigInteger2));
    }

    public final void min(XBigInteger xBigInteger) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        this.setValue(this.getValue().min(bigInteger));
    }

    public static XBigInteger min(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger2 = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        return new XBigInteger(bigInteger.min(bigInteger2));
    }

    public final void add(XBigInteger xBigInteger) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        this.setValue(this.getValue().add(bigInteger));
    }

    public static XBigInteger add(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger2 = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        return new XBigInteger(bigInteger.add(bigInteger2));
    }

    public final void subtract(XBigInteger xBigInteger) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        this.setValue(this.getValue().subtract(bigInteger));
    }

    public static XBigInteger subtract(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger2 = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        return new XBigInteger(bigInteger.subtract(bigInteger2));
    }

    public final void multiply(XBigInteger xBigInteger) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        this.setValue(this.getValue().multiply(bigInteger));
    }

    public static XBigInteger multiply(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger2 = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        return new XBigInteger(bigInteger.multiply(bigInteger2));
    }

    public final void divide(XBigInteger xBigInteger) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        if (bigInteger.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigInteger.divide(y)");
        }
        this.setValue(this.getValue().divide(bigInteger));
    }

    public static XBigInteger divide(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger3 = bigInteger = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        if (bigInteger.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigInteger.divide(x,y)");
        }
        return new XBigInteger(bigInteger2.divide(bigInteger));
    }

    public final void remainder(XBigInteger xBigInteger) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        if (bigInteger.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigInteger.remainder(y)");
        }
        this.setValue(this.getValue().remainder(bigInteger));
    }

    public static XBigInteger remainder(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = xBigInteger == null ? BigInteger.ZERO : xBigInteger.value;
        BigInteger bigInteger3 = bigInteger = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.value;
        if (bigInteger.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigInteger.remainder(x,y)");
        }
        return new XBigInteger(bigInteger2.remainder(bigInteger));
    }

    public static XBigInteger[] divideAndRemainder(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger3 = bigInteger = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        if (bigInteger.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("Zero divisor in XBigInteger.divideAndRemainder(x,y)");
        }
        BigInteger[] bigIntegerArray = bigInteger2.divideAndRemainder(bigInteger);
        return new XBigInteger[]{new XBigInteger(bigIntegerArray[0]), new XBigInteger(bigIntegerArray[1])};
    }

    public final void mod(XBigInteger xBigInteger) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        if (bigInteger.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("Zero or negative divisor in XBigInteger.mod(y)");
        }
        this.setValue(this.getValue().mod(bigInteger));
    }

    public static XBigInteger mod(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger3 = bigInteger = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        if (bigInteger.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("Zero or negative divisor in XBigInteger.mod(x,y)");
        }
        return new XBigInteger(bigInteger2.mod(bigInteger));
    }

    public final void modInverse(XBigInteger xBigInteger) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        if (bigInteger.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("Zero or negative divisor in XBigInteger.modInverse(y)");
        }
        try {
            this.setValue(this.getValue().modInverse(bigInteger));
        }
        catch (Exception exception) {
            throw new ArithmeticException("Value not relatively prime in XBigInteger.modInverse(y)");
        }
    }

    public static XBigInteger modInverse(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger3 = bigInteger = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        if (bigInteger.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("Zero or negative divisor in XBigInteger.modInverse(x,y)");
        }
        try {
            return new XBigInteger(bigInteger2.modInverse(bigInteger));
        }
        catch (Exception exception) {
            throw new ArithmeticException("Value not relatively prime in XBigInteger.modInverse(x,y)");
        }
    }

    public final void pow(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative exponent in XBigInteger.pow(e)");
        }
        this.setValue(this.getValue().pow(n));
    }

    public static XBigInteger pow(XBigInteger xBigInteger, int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative exponent in XBigInteger.pow(x, e)");
        }
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        return new XBigInteger(bigInteger.pow(n));
    }

    public final void modPow(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger3 = bigInteger = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        if (bigInteger.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("Zero or negative modulus in XBigInteger.modPow(e,y)");
        }
        try {
            this.setValue(this.getValue().modPow(bigInteger2, bigInteger));
        }
        catch (Exception exception) {
            throw new ArithmeticException("Value not relatively prime in XBigInteger.modPow(e,y)");
        }
    }

    public static XBigInteger modPow(XBigInteger xBigInteger, XBigInteger xBigInteger2, XBigInteger xBigInteger3) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger3 = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        BigInteger bigInteger4 = bigInteger = xBigInteger3 == null ? BigInteger.ZERO : xBigInteger3.getValue();
        if (bigInteger.compareTo(BigInteger.ZERO) <= 0) {
            throw new ArithmeticException("Zero or negative modulus in XBigInteger.modPow(x,e,y)");
        }
        try {
            return new XBigInteger(bigInteger2.modPow(bigInteger3, bigInteger));
        }
        catch (Exception exception) {
            throw new ArithmeticException("Value not relatively prime in XBigInteger.modPow(x,e,y)");
        }
    }

    public final void gcd(XBigInteger xBigInteger) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        this.setValue(this.getValue().gcd(bigInteger));
    }

    public static XBigInteger gcd(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger2 = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        return new XBigInteger(bigInteger.gcd(bigInteger2));
    }

    public final void lcm(XBigInteger xBigInteger) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        this.setValue(XBigInteger.lcm(this, xBigInteger));
    }

    public static XBigInteger lcm(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger3 = bigInteger = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        if (bigInteger2.equals(BigInteger.ZERO)) {
            return new XBigInteger(bigInteger.abs());
        }
        if (bigInteger.equals(BigInteger.ZERO)) {
            return new XBigInteger(bigInteger2.abs());
        }
        bigInteger2 = bigInteger2.abs();
        bigInteger = bigInteger.abs();
        BigInteger bigInteger4 = bigInteger2.gcd(bigInteger);
        return new XBigInteger(bigInteger2.multiply(bigInteger.divide(bigInteger4)));
    }

    public final void shiftLeft(int n) {
        this.setValue(this.getValue().shiftLeft(n));
    }

    public static XBigInteger shiftLeft(XBigInteger xBigInteger, int n) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        return new XBigInteger(bigInteger.shiftLeft(n));
    }

    public final void shiftRight(int n) {
        this.setValue(this.getValue().shiftRight(n));
    }

    public static XBigInteger shiftRight(XBigInteger xBigInteger, int n) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        return new XBigInteger(bigInteger.shiftRight(n));
    }

    public final void not() {
        this.setValue(this.getValue().not());
    }

    public static XBigInteger not(XBigInteger xBigInteger) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        return new XBigInteger(bigInteger.not());
    }

    public final void and(XBigInteger xBigInteger) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        this.setValue(this.getValue().and(bigInteger));
    }

    public static XBigInteger and(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger2 = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        return new XBigInteger(bigInteger.and(bigInteger2));
    }

    public final void or(XBigInteger xBigInteger) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        this.setValue(this.getValue().or(bigInteger));
    }

    public static XBigInteger or(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger2 = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        return new XBigInteger(bigInteger.or(bigInteger2));
    }

    public final void xor(XBigInteger xBigInteger) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        this.setValue(this.getValue().xor(bigInteger));
    }

    public static XBigInteger xor(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger2 = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        return new XBigInteger(bigInteger.xor(bigInteger2));
    }

    public final void andNot(XBigInteger xBigInteger) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        this.setValue(this.getValue().andNot(bigInteger));
    }

    public static XBigInteger andNot(XBigInteger xBigInteger, XBigInteger xBigInteger2) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        BigInteger bigInteger2 = xBigInteger2 == null ? BigInteger.ZERO : xBigInteger2.getValue();
        return new XBigInteger(bigInteger.andNot(bigInteger2));
    }

    public final boolean testBit(int n) {
        return this.getValue().testBit(n);
    }

    public final void setBit(int n) {
        this.setValue(this.getValue().setBit(n));
    }

    public static XBigInteger setBit(XBigInteger xBigInteger, int n) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        return new XBigInteger(bigInteger.setBit(n));
    }

    public final void clearBit(int n) {
        this.setValue(this.getValue().clearBit(n));
    }

    public static XBigInteger clearBit(XBigInteger xBigInteger, int n) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        return new XBigInteger(bigInteger.clearBit(n));
    }

    public final void flipBit(int n) {
        this.setValue(this.getValue().flipBit(n));
    }

    public static XBigInteger flipBit(XBigInteger xBigInteger, int n) {
        BigInteger bigInteger = xBigInteger == null ? BigInteger.ZERO : xBigInteger.getValue();
        return new XBigInteger(bigInteger.flipBit(n));
    }

    public final int getLowestSetBit() {
        return this.getValue().getLowestSetBit();
    }

    public final int bitLength() {
        return this.getValue().bitLength();
    }

    public final int bitCount() {
        return this.getValue().bitCount();
    }

    public final boolean isProbablePrime(int n) {
        return this.getValue().isProbablePrime(n);
    }

    public final int compareTo(XBigInteger xBigInteger) {
        if (xBigInteger == null) {
            throw new NullPointerException("Null object passed to XBigInteger.compareTo(XBigInteger)");
        }
        return this.getValue().compareTo(xBigInteger.getValue());
    }

    public final int compareTo(Object object) {
        if (object == null) {
            throw new ClassCastException("Null object passed to XBigInteger.compareTo(Object)");
        }
        if (!(object instanceof XBigInteger)) {
            throw new ClassCastException("Invalid object passed to XBigInteger.compareTo(Object)");
        }
        return this.compareTo((XBigInteger)object);
    }

    public static XBigInteger factorial(int n) {
        if (n < 0) {
            return new XBigInteger();
        }
        if (n < 2) {
            return new XBigInteger(1L);
        }
        XBigInteger xBigInteger = new XBigInteger(n--);
        while (n > 1) {
            xBigInteger.multiply(new XBigInteger(n--));
        }
        return xBigInteger;
    }

    public static XBigInteger binomial(int n, int n2) {
        if (n2 < 0) {
            return new XBigInteger();
        }
        if (n2 == 0) {
            return new XBigInteger(1L);
        }
        if (n >= 0 && n < n2) {
            return new XBigInteger();
        }
        if (n >= 0 && n == n2) {
            return new XBigInteger(1L);
        }
        if (n >= 0 && n < 2 * n2) {
            n2 = n - n2;
        }
        XBigInteger xBigInteger = new XBigInteger(n--);
        int n3 = 2;
        while (n2 > 1) {
            xBigInteger.multiply(new XBigInteger(n--));
            xBigInteger.divide(new XBigInteger(n3++));
            --n2;
        }
        return xBigInteger;
    }

    public static BigInteger[] toPrimitiveArray(XBigInteger[] xBigIntegerArray) {
        if (xBigIntegerArray == null) {
            return null;
        }
        BigInteger[] bigIntegerArray = new BigInteger[xBigIntegerArray.length];
        int n = 0;
        while (n < bigIntegerArray.length) {
            if (xBigIntegerArray[n] != null) {
                bigIntegerArray[n] = xBigIntegerArray[n].getValue();
            }
            ++n;
        }
        return bigIntegerArray;
    }

    public static XBigInteger[] toXArray(BigInteger[] bigIntegerArray) {
        if (bigIntegerArray == null) {
            return null;
        }
        XBigInteger[] xBigIntegerArray = new XBigInteger[bigIntegerArray.length];
        int n = 0;
        while (n < xBigIntegerArray.length) {
            if (bigIntegerArray[n] != null) {
                xBigIntegerArray[n] = new XBigInteger(bigIntegerArray[n]);
            }
            ++n;
        }
        return xBigIntegerArray;
    }
}

