/*
 * Decompiled with CFR 0.152.
 */
import edu.neu.ccs.console.ConsoleAware;

public class SimpleTestHarness
implements ConsoleAware {
    String testResults = "Test results: \n";
    String fullTestResults = "Full test results: \n";
    int total = 0;
    int failed = 0;

    public SimpleTestHarness(String testsuite) {
        this.testResults = String.valueOf(testsuite) + " test results: \n";
        this.fullTestResults = String.valueOf(testsuite) + "Full test results: \n";
    }

    public SimpleTestHarness() {
        this("");
    }

    void test(String testname, boolean result) {
        if (!result) {
            ++this.failed;
            this.testResults = String.valueOf(this.testResults) + testname + ": failed \n";
        }
        ++this.total;
    }

    void test(String testname, ISame expected, ISame actual) {
        if (expected.same(actual)) {
            this.reportSuccess(testname, expected, actual);
        } else {
            this.reportFailed(testname, expected, actual);
        }
    }

    void test(String testname, int expected, int actual) {
        if (expected == actual) {
            this.reportSuccess(testname, "" + expected, "" + actual);
        } else {
            this.reportFailed(testname, "" + expected, "" + actual);
        }
    }

    void test(String testname, short expected, short actual) {
        if (expected == actual) {
            this.reportSuccess(testname, "" + expected, "" + actual);
        } else {
            this.reportFailed(testname, "" + expected, "" + actual);
        }
    }

    void test(String testname, long expected, long actual) {
        if (expected == actual) {
            this.reportSuccess(testname, "" + expected, "" + actual);
        } else {
            this.reportFailed(testname, "" + expected, "" + actual);
        }
    }

    void test(String testname, boolean expected, boolean actual) {
        if (expected == actual) {
            this.reportSuccess(testname, "" + expected, "" + actual);
        } else {
            this.reportFailed(testname, "" + expected, "" + actual);
        }
    }

    void test(String testname, char expected, char actual) {
        if (expected == actual) {
            this.reportSuccess(testname, "" + expected, "" + actual);
        } else {
            this.reportFailed(testname, "" + expected, "" + actual);
        }
    }

    void test(String testname, float expected, float actual, float epsilon) {
        double divisor;
        double absExpected;
        double absActual = Math.abs(actual);
        double relativeError = Math.abs((absActual - (absExpected = (double)Math.abs(expected))) / (divisor = Math.max(absActual, absExpected)));
        if (relativeError <= (double)epsilon) {
            this.reportSuccess(testname, "" + expected, "" + actual);
        } else {
            this.reportFailed(testname, "" + expected, "" + actual);
        }
    }

    void test(String testname, double expected, double actual, double epsilon) {
        double divisor;
        double absExpected;
        double absActual = Math.abs(actual);
        double relativeError = Math.abs((absActual - (absExpected = Math.abs(expected))) / (divisor = Math.max(absActual, absExpected)));
        if (relativeError <= epsilon) {
            this.reportSuccess(testname, "" + expected, "" + actual);
        } else {
            this.reportFailed(testname, "" + expected, "" + actual);
        }
    }

    void test(String testname, double expected, double actual) {
        this.test(testname, expected, actual, 0.01);
    }

    void reportFailed(String testname, Object expected, Object actual) {
        ++this.failed;
        this.testResults = String.valueOf(this.testResults) + "\n" + testname + ": failed \n" + "expected: " + expected + "\n" + "actual:   " + actual + "\n";
        this.fullTestResults = String.valueOf(this.fullTestResults) + "\n" + testname + ": failed \n" + "expected: " + expected + "\n" + "actual:   " + actual + "\n";
        ++this.total;
    }

    void reportSuccess(String testname, Object expected, Object actual) {
        this.fullTestResults = String.valueOf(this.fullTestResults) + "\n" + testname + ": success \n" + "expected: " + expected + "\n" + "actual:   " + actual + "\n";
        ++this.total;
    }

    void testReport() {
        if (this.failed == 1) {
            SimpleTestHarness.console.out.println(String.valueOf(this.testResults) + this.failed + " test failed.\n");
        } else if (this.failed > 1) {
            SimpleTestHarness.console.out.println(String.valueOf(this.testResults) + this.failed + " tests failed.\n");
        } else {
            SimpleTestHarness.console.out.println(String.valueOf(this.testResults) + "All tests passed.\n");
        }
    }

    void fullTestReport() {
        if (this.failed == 1) {
            SimpleTestHarness.console.out.println("\n 1 test failed.\n");
        } else if (this.failed > 1) {
            SimpleTestHarness.console.out.println("\n " + this.failed + " tests failed.\n");
        } else {
            SimpleTestHarness.console.out.println("All tests passed.\n");
        }
        SimpleTestHarness.console.out.println(this.fullTestResults);
    }
}

