import world.*;

// Represents a world in the UFO game
class UFOGameWorld extends World {
  // The world has a width and a height (dimensions of the canvas)
  int width;
  int height;

  // Here's our major players.
  UFO  ufo;
  //Tank tank;
  //ALoS los;

  UFOGameWorld(int width, int height, UFO ufo) {
    this.width  = width;
    this.height = height;
    this.ufo    = ufo;
    //this.tank   = tank;
    //this.los    = los;
  }

  // To draw the world, we draw the players.
  public boolean draw() {
    return this.theCanvas.drawRect(new Posn(0,0), this.width, this.height, new White()) &&
           this.ufo.draw(this);
  }

  // The game's over when a) a shot hits the UFO or b) the UFO lands.
  boolean gameOver(UFO ufo) {
     return (ufo.loc.y >= (this.height - 15)); // The UFO has landed
  }

  // If the game isn't over, return the new world.  If it is, then
  // call endOfTime().
  UFOGameWorld move(UFO ufo) {
      return new UFOGameWorld(this.width, this.height, ufo);
  }
  
  // When KeyEvents happen (which are represented by strings), then we need to do
  // the appropriate action, which is:
  //
  //  - "up"    : the tank shoots
  //  - "left"  : the tank moves left
  //  - "right" : the tank moves right.
  //
  // The tank move method handles the latter two, and we handle telling the tank to shoot.
  public World onKeyEvent(String ke) {
    return this;
  }

  // When the tick event happens, then we need to move the UFO and the shots
  // (the tank only moves when the player moves it).
  public World onTick() {
    if(this.gameOver(this.ufo))
        return this.endOfWorld();
    else
        return this.move(this.ufo.moveRandom(10, this.width, this.height));
  }

  // run() takes the amount of time between ticks as a double and calls all the necessary
  // functions.
  boolean run(double tick) {
    return this.bigBang(this.width, this.height, tick);
  }

  // erase the canvas
  boolean erase() {
    return this.theCanvas.drawRect(new Posn(0,0), this.width, this.height, new White());
  }
}
