import world.*;

// We use rectangles for bounding boxes -- the main thing you
// want them for is to tell when they overlap.
class BoundingBox {
  Posn loc; // Upper left of bounding box
  int width;
  int height;

  BoundingBox(Posn loc, int width, int height) {
    this.loc = loc;
    this.width = width;
    this.height = height;
  }

  // When two bounding boxes overlap, we want to return true.
  // We do this by the following:
  //
  // Check the sides of the boxes.  If the we have that there's
  // an overlap between the boxes both horizontally and vertically,
  // then we have an overlap.
  //
  // For each, we check the left-most (top-most) right (bottom) side
  // and subtract from it the right-most (bottom-most) left (top)
  // side.  Draw it out and you'll see what I mean.
  boolean intersects(BoundingBox bb) {
    return (Math.min(this.loc.x + this.width, bb.loc.x + bb.width) -
            Math.max(this.loc.x, bb.loc.x) > 0) &&
           (Math.min(this.loc.y + this.height, bb.loc.y + bb.height) -
            Math.max(this.loc.y, bb.loc.y) > 0);
  }
}
