/*
 * Decompiled with CFR 0.152.
 */
package world;

import java.awt.Color;
import world.BigWorld;
import world.Blue;
import world.Green;
import world.MyCanvas;
import world.Posn;
import world.Red;

public class World
extends BigWorld {
    public BigWorld theWorld = BigWorld.theWorld;
    public MyCanvas theCanvas = new MyCanvas(this);

    public boolean bigBang(double speed) {
        return this.bigBang(speed, true, true);
    }

    public boolean bigBang(double speed, boolean key, boolean mouse) {
        return this.theWorld.bigBang(0.0, this, key, mouse);
    }

    public boolean bigBang(int width, int height, double speed) {
        return this.start(width, height) && this.theWorld.bigBang(speed, this, true, true);
    }

    public boolean start(int width, int height) {
        return this.theWorld.start(width, height) && this.draw() && this.theWorld.drawAll();
    }

    public boolean stop() {
        return this.theWorld.stop();
    }

    public boolean endOfTime() {
        return this.theWorld.stop();
    }

    public World endOfWorld() {
        return this.theWorld.endOfWorld();
    }

    public World onTick() {
        System.out.println("Tick");
        return this;
    }

    public World onKeyEvent(String ke) {
        if (ke.equals("b")) {
            this.drawRect(new Posn(20, 20), 50, 50, new Blue());
            this.paint();
        }
        if (ke.equals("g")) {
            this.drawRect(new Posn(20, 20), 50, 50, new Green());
            this.paint();
        }
        if (ke.equals("r")) {
            this.drawRect(new Posn(20, 20), 50, 50, new Red());
            this.paint();
        }
        return this;
    }

    public World mouseClicked() {
        return this;
    }

    public World mouseEntered() {
        return this;
    }

    public World mouseExited() {
        return this;
    }

    public World mousePressed() {
        return this;
    }

    public World mouseReleased() {
        return this;
    }

    public boolean sleepForAWhile(int s) {
        int rounds = 100000000 * s;
        int i = 0;
        while (i < rounds) {
            ++i;
        }
        return true;
    }

    public final boolean drawAll() {
        return this.theWorld.drawAll();
    }

    protected final boolean drawCircle(Posn p, int r, Color c) {
        return this.theWorld.drawCircle(p, r, c);
    }

    protected final boolean drawDisk(Posn p, int r, Color c) {
        return this.theWorld.drawDisk(p, r, c);
    }

    protected final boolean drawRect(Posn p, int width, int height, Color c) {
        return this.theWorld.drawRect(p, width, height, c);
    }

    protected final boolean drawLine(Posn p0, Posn p1, Color c) {
        return this.theWorld.drawLine(p0, p1, c);
    }

    protected final boolean drawString(Posn p, String s) {
        return this.theWorld.drawString(p, s);
    }

    protected final boolean clearCircle(Posn p, int r, Color c) {
        return this.theWorld.clearCircle(p, r, c);
    }

    protected final boolean clearDisk(Posn p, int r, Color c) {
        return this.theWorld.clearDisk(p, r, c);
    }

    protected final boolean clearRect(Posn p, int width, int height, Color c) {
        return this.theWorld.clearRect(p, width, height, c);
    }

    protected final boolean clearLine(Posn p0, Posn p1, Color c) {
        return this.theWorld.clearLine(p0, p1, c);
    }

    protected final boolean clearString(Posn p, String s) {
        return this.theWorld.clearString(p, s);
    }

    protected final boolean setColor(Color c) {
        return this.theWorld.setColor(c);
    }

    protected final boolean paint() {
        return this.theWorld.paintWorld();
    }

    public static void main(String[] argv) {
        World c = new World();
        c.start(300, 300);
        c.bigBang(5.0);
        c.sleepForAWhile(2);
    }
}

