/* @(#)Interactions.java 1.0  20 September 2004 */

/* Useful imports */

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.codec.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.filter.*;
import edu.neu.ccs.jpf.*;
import edu.neu.ccs.parser.*;
import edu.neu.ccs.pedagogy.*;
import edu.neu.ccs.quick.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.awt.image.*;
import javax.swing.*;
import javax.swing.border.*;

import java.io.*;
import java.util.*;
import java.math.*;
import java.beans.*;
import java.lang.reflect.*;
import java.net.URL;
import java.util.regex.*;

//import java.text.*;

public class Interactions extends JPF 
{
  
  public static void main(String[] args) { 
    // To optionally adjust the look and feel,
    // remove the comments from one of the two statements below.
    
    // LookAndFeelTools.showSelectLookAndFeelDialog();
    // LookAndFeelTools.adjustAllDefaultFontSizes(2);
    
    new Interactions();
  }	
  
  // run the test suite for the class Balloon
  public void testSuite(){
    Examples e = new Examples();
    e.go();
  }
  
  // verify the GUI input processing
  public void testGuiInput(){
    BalloonInputView bView = new BalloonInputView();
    console.out.println("The first balloon:\n" + bView.demandBalloon());
    
    Balloon b3 = BalloonInputView.demandOneBalloon();
    console.out.println("We paint the second balloon \n");
    b3.paintBalloon(this.window);
    
    try{
      console.out.println("We request and paint the third balloon \n");
      Balloon b4 = bView.requestBalloon();
      b4.paintBalloon(this.window);
    }
    catch(CancelledException e){
      console.out.println("No balloon given");
    }
    
    // try to get another balloon
    try{
      console.out.println("Request through a static method \n");
      Balloon b5 = BalloonInputView.requestOneBalloon();
      b5.paintBalloon(this.window);
    }
    catch(CancelledException e){
      console.out.println("No balloon given");
    }		
  }
  
  // verify the console input processing
  public void testConsoleInput(){
    ConsoleBalloonInput cbi = new ConsoleBalloonInput();
    
    // demand a balloon and paint it
    (cbi.demandBalloon()).paintBalloon(this.window);
    
    // request a balloon
    try{
      (cbi.requestBalloon()).paintBalloon(this.window);
    }
    catch(CancelledException e){
      console.out.println("No balloon given");
    }
    
  }
  
  // explore the balloon control GUI
  public void testBalloonControl(){
    BalloonControl bc = new BalloonControl(this.window);
    GeneralDialog.showOKDialog(bc, "Balloon Control");		
  }
  
}
