import java.util.Iterator;

class MyLinkedList<E> implements Iterable
{
  /**
   * The inner class representing each node of the list
   */
  class ListNode<E>{
    E data;
    ListNode<E> prev;
    ListNode<E> next;
    ListNode(E data, ListNode<E> prev, ListNode<E> next){
      this.data = data;
      this.prev = prev;
      this.next = next;
    }
  }
  /**
   * The pointer to the beginning of the list.
   * header.next actually points to the first node of the list
   */
  ListNode<E> header = new ListNode<E>(null, null, null);
  
  /**
   * lastNode points to the last node of the list
   * At first, when the list is empty, it points to the header
   */
  ListNode<E> lastNode = header;
  
  /**
   * The variable keeping track of the size of the list
   */
  int size = 0;
  
  /**
   * Appends the specified element to the end of this list.
   *
   * @param o element to be appended to this list.
   * @return true (as per the general contract of
   * Collection.add).
   */
  public boolean add(E e){
    // create a node containing the new data
    ListNode<E> newnode = new ListNode<E>(e, this.lastNode, null);
    // and append it to the end of the list
    this.lastNode.next = newnode;     
    this.lastNode = newnode;
    
    // update the size of the list
    this.size++;
    
    return true;
  }
  
  
  public Iterator<E> iterator(){
    return new MyLLIterator<E>();
  }
  
  /**
   * The inner class representing the iterator over this collection
   */
  class MyLLIterator<E> implements Iterator<E>{
    ListNode<E> current_pointer;
    MyLLIterator(){
      // At first, set the current position to the beginning of the list
      this.current_pointer = (ListNode<E>)header.next;
     }
    /**
     * For what hasNext() is supposed to do, look at the specification
     * of Iterator interface.
     */
    public boolean hasNext(){
      // TODO: you need to re-implement the body of this method.
      // At present, it is just a dummy
      return true;
    }
    
    /**
     * For what next() is supposed to do, look at the specification of
     * Iterator interface.
     * @return The method should return the data object, not the ListNode object
     */
    public E next(){
      // TODO: you need to re-implement the body of this method
      // At present, it is just a dummy
      return null;
    }
    public void remove(){
      // For this lab assignment, don't worry about this method.
      // Do nothing !
    }
  }
}
