/* @(#)Interactions.java 1.0  20 September 2004 */

/* Useful imports */

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.codec.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.filter.*;
import edu.neu.ccs.jpf.*;
import edu.neu.ccs.parser.*;
import edu.neu.ccs.pedagogy.*;
import edu.neu.ccs.quick.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.awt.image.*;
import javax.swing.*;
import javax.swing.border.*;

import java.io.*;
import java.util.*;
import java.math.*;
import java.beans.*;
import java.lang.reflect.*;
import java.net.URL;
import java.util.regex.*;

// import java.text.*;

public class Interactions extends JPF 
{
    
    public static void main(String[] args) { 
        // To optionally adjust the look and feel,
        // remove the comments from one of the two statements below.
        
        // LookAndFeelTools.showSelectLookAndFeelDialog();
        // LookAndFeelTools.adjustAllDefaultFontSizes(2);
        
        new Interactions();
    }
    
	// An example of catching an exception automatically thrown by Java
	public int divide(int x, int y) {
		int z = 0; // give z a default value
		try {
			z = x/y; //divide by zero!
		} catch (ArithmeticException e) {
			//handle the exception smoothly
			console.out.println("Divide by zero error! divide given " + x + "/" + y);
		}
		return z;
	}
	
	// An example of manually creating and throwing an exception
	public int multiply(int x, int y) {
		// As an example, imagine that our application can only handle numbers
		// smaller than 1000. In this case, we'll throw an error when we produce
		// a number that is too big
		int z = 0;
		try {
			z = x*y;
			if(z > 1000) {
				//create and throw an exception
              ArithmeticException e = 
					new ArithmeticException("Multiply produced a number > 1000");
				throw e;
			}
		} catch (ArithmeticException e){
			// handle the exception
			console.out.println("The following exception occured:" + e);
		}
		return z;
	}
	
	// An example of a method that throws an exception instead of immediately
	// handling it. The exceptions thrown by this method should be caught at a
	// higher level
	public int multiplyAndThrow(int x, int y) throws ArithmeticException {
		int z = x*y;
		if(z > 1000) {
			// create and throw an exception
			ArithmeticException e = 
				new ArithmeticException("Multiply produced a number > 1000");
			throw e;
		}
		return z;
	}
	
	// This method uses multiplyAndThrow to perform multiplication and catches
	// the exceptions thrown by it
	public int multiplyAndCatch(int x, int y) {
		int z = 0;
		try {
			z = multiplyAndThrow(x,y);
		} catch (ArithmeticException e) {
			// handle the exception
			console.out.println("The following exception occured:" + e);
		}
		return z;
	}
 
	/*
	 *   ADD METHODS HERE: add the methods subtractAndThrow and subtractAndCatch
	 * 
	 *   subtractAndThrow should be defined to throw an exception if the resulting
	 *   value is negative.
	 * 
	 *   subtractAndCatch should use subtractAndThrow to do the subtraction and
	 *   use a try-catch statement to handle exceptions
	 */
	
    /*----------------------------------------------------------------------- 
	 Run the test suite 
	------------------------------------------------------------------------- */
    public void TestSuite(){
   
       Examples e = new Examples();
       
       e.runTests();
   }
    
  
 }

