import java.util.Collection;
import java.util.List;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.LinkedList;
import java.util.Stack;
//All the wordy "import"'s above can be replaced with a simple
//import java.util.*;
import edu.neu.ccs.*;

public class Examples extends SimpleTestHarness {
  /**
   * Data for test cases.
   */
  Person p1 = new Person("Alice", 1);
  Person p2 = new Person("Bob", 2);
  Person p3 = new Person("Chris", 3);
  
  
  /**
   * Produce a simple String from a collection
   */
  public String makeString(Iterable<Person> col){
    String s = "";
    for(Iterator<Person> it = col.iterator();it.hasNext();){
      Person o = it.next();
      s = s + o.toString();
    }
    return s;
  }
  
  
  /**
   * Test the Java standard LinkedList class
   */
  public void testStandardLinkedList(){
    
    // prepare data for test, adding data using Collection interface
    Collection<Person> colStandard = new LinkedList<Person>();
    colStandard.add(p1);
    colStandard.add(p2);
    colStandard.add(p3);
    
    // Now, actually test
    // First, check the size
    test("linked list size", 3, colStandard.size());
    
    // Then, check to contents of all elements
    test("linked list elements",
        p1.toString() + p2.toString() + p3.toString(),
        makeString(colStandard));
  }
  
  /**
   * Test MyLinkedList class
   */
  /*
   public void testMyLinkedList(){

   // prepare data for test, adding data using Collection interface
    MyLinkedList colMy = new MyLinkedList();
    colMy.add(p1);
    colMy.add(p2);
    colMy.add(p3);
    
    // Now, actually test
     // First, check the size
      test("linked list size", 3, colMy.size());
      
      // Then, check to contents of all elements
       test("linked list elements",
       p1.toString() + p2.toString() + p3.toString(),
       makeString(colMy));
       }
       */
  
  /**
   *  Test MyStack class
   *
   */
  public void testMyStack(){
    MyStack<Person> mySt = new MyStack<Person>();
    /*
     mySt.push(p1);
     mySt.push(p2);
     mySt.push(p3);
     
     test("peek(2)", p2, mySt.peek(2));
     test("peek(3)", p1,mySt.peek(3));
     test("peek(10)", "EmptyStackException", mySt.peek(10));
     */
  }
  
  /**
   * Test the ListIterator of standard LinkedList class
   */
  public void testListIteratorOfStandard(){  
    // prepare data for test, adding data using Collection interface
    Collection<Person> colStandard = new LinkedList<Person>();
    colStandard.add(p1);
    colStandard.add(p2);
    colStandard.add(p3);
    
    // Now, actually test
    test("ListIterator of standard LinkedList", 3, colStandard.size());
    
    ListIterator<Person> lit = ((List<Person>)colStandard).listIterator();
    test("ListIterator of standard LinkedList: forward", 
        p1.toString() + p2.toString() + p3.toString(),
        makeForwardString(lit));
    
    test("ListIterator of standard LinkedList: reverse", 
        p3.toString() + p2.toString() + p1.toString(),
        makeReverseString(lit));
  }
  
  /**
   * produce a simple list from all items generated by forward traversal
   * @param lit the list iterator
   * @return string generated by forward traversal
   */
  public String makeForwardString(ListIterator lit){
    String s = "";
    while(lit.hasNext()){
      s = s + (lit.next()).toString();
    }
    return s;
  }
  
  /**
   * produce a simple list from all items generated by reverse traversal
   * @param lit the list iterator
   * @return string generated by reverse traversal
   */
  public String makeReverseString(ListIterator lit){
    String s = "";
    while(lit.hasPrevious()){
      s = s + (lit.previous()).toString();
    }
    return s;
  }
  
  /**
   * Test the ListIterator of MyLinkedList class
   */
  /*
   public void testListIteratorOfMyLinkedList(){
   // prepare data for test, adding data using Collection interface
    MyLinkedLIst colMy = new MyLinkedList();
    colMy.add(p1);
    colMy.add(p2);
    colMy.add(p3);
    
    // Now, actually test
     test("ListIterator of standard LinkedList", 3, colMy.size());
     
     ListIterator lit = ((List)colMy).listIterator();
     test("ListIterator of standard LinkedList: forward", 
     p1.toString() + p2.toString() + p3.toString(),
     makeForwardString(lit));
     
     test("ListIterator of standard LinkedList: reverse", 
     p3.toString() + p2.toString() + p1.toString(),
     makeReverseString(lit));
     }
     */
  
  public void runTests(){
    // Run the stack tests
    this.testStandardLinkedList();
    this.testListIteratorOfStandard();
    this.testMyStack();
    
    // ** Put a line to run your queue tests here **
    
    // example of a report on failures
    testReport();
    
    // example of a full test report
    fullTestReport();
  } 
}



