/* Class to represent loop algorithms for a data structure
 * generated by a parametrized ETraversal
 * Lab 10: 21 March 2006
 */

import edu.neu.ccs.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.console.*;

import java.awt.*;
import java.math.*;
import java.util.*;

public class Algorithms implements ConsoleAware{
  
  /*
  TEMPLATE:  
  ... tr.hasMore() ...           -- boolean         ::PREDICATE
    if false:                    -- result??        ::BASE CASE
    if true:  ... tr.current()   -- E               ::CURRENT
              ... tr.advance()   -- ETraversal<E>   ::ADVANCE
   */
  
  
  // orMap method implemented recursively
  public  <E> boolean orMap(ETraversal<E> tr, ISelect<E> predicate){
    if (tr.hasMore())
      if (predicate.select(tr.current()))
        return true;
      else
        return this.<E>orMap(tr.advance(), predicate);
    else
      return false;
  }	
  
  // print all elements in the given traversal
  public String makeString(ETraversal tr){
    if (tr.hasMore())                             // PREDICATE
      return tr.current().toString() + "\n" +     // CURRENT
      makeString(tr.advance());                   // ADVANCE
    else
      return "-----";                             // BASE CASE
  } 
  
  /*------------------------------------------------------------------*/
  // orMap with while loop and iterator
  public <E> boolean orMapWhile(ETraversal<E> tr, ISelect<E> predicate){
    // preamble: initialize the empty clause
    boolean result = false;
    
    // loop header: while(predicate)
    while(tr.hasMore()){ 
      
      // loop body: uses current element
      if (predicate.select(tr.current()))
        result = true;
      
      // loop update: advance the iterator
      tr = tr.advance();
    }
    
    // postmortem: produce the result
    return result;
  }
  
  // print all elements in the given traversal using while loop
  public String makeStringWhile(ETraversal tr){
    // preamble: initialize the empty BASE CASE clause
    String result = "------";
    
    // loop header: while(PREDICATE)
    while(tr.hasMore()){ 
      
      // loop body: uses CURRENT element
      result = result + "\n" +
      tr.current().toString();
      
      // loop update: ADVANCE the iterator
      tr = tr.advance();
    }
    
    // postmortem: produce the result
    return result;
  }   
    
  /*------------------------------------------------------------------*/
  // orMap with for loop and iterator
  public <E> boolean orMapFor(ETraversal<E> tr, ISelect<E> predicate){
    // preamble: initialize the empty clause
    boolean result = false;
    
    // loop header: for(initializer; predicate; update)
    for(; tr.hasMore(); tr = tr.advance()){
      
      // loop body: uses current element
      if (predicate.select(tr.current()))
        result = true;
    }
    
    // postmortem: produce the result
    return result;
  }
  
  // print all elements in the given traversal using for loop
  public String makeStringFor(ETraversal tr){
    // preamble: initialize the empty BASE CASE clause
    String result = "------";
    
    // loop header: for(initializer; PREDICATE; ADVANCE)
    for(; tr.hasMore(); tr = tr.advance()){
      
      // loop body: uses CURRENT element
      result = result + "\n" +
      tr.current().toString();
    }
    
    // postmortem: produce the result
    return result;
  }   
  
 
  /*------------------------------------------------------------------*/
  // orMap with counted for loop and iterator
  public <E> boolean orMapForCounted(ArrayList<E> alist, ISelect<E> predicate){
    // preamble: initialize the empty clause
    boolean result = false;
   
    // loop header: for(initializer; predicate; update)
    for(int index = 0; index < alist.size(); index = index + 1){
      
      // loop body: uses current element
      if (predicate.select(alist.get(index)))
        result = true;
    }
    
    // postmortem: produce the result
    return result;
  }
  
  // print all elements in the given traversal using counted for loop
  public String makeStringForCounted(ArrayList alist){
    // preamble: initialize the empty  BASE CASE clause
    String result = "------";
    
    // loop header: for(initializer; PREDICATE; ADVANCE)
    for(int index = 0; index < alist.size(); index = index + 1){
      
      // loop body: uses CURRENT element
      result = result + "\n" +
      alist.get(index).toString();
    }
    
    // postmortem: produce the result
    return result;
  }   
  
}

