/* ------------------------------------------------------------------
 * Functional (External) Iterator Pattern:
 *      iterator for a list of cities
*/

import edu.neu.ccs.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.util.*;

import java.awt.*;
import java.io.*;
import javax.swing.*;
import java.util.*;

/** An input iterator for City object from file input. */
class OutFileTraversal implements Traversal {

  /*--------------------------------------------------------
   * Member data
   *------------------------------------------------------*/

  /* the list of cities to output */
  protected City[] cities;

  /* loop counter */
  int i = 0;

  /* true if the file is closed */
  boolean closed = false;

  /* a String object to hold file contents */
  protected String s = "";

  /* file chooser - to select the file from */
  protected JFileChooser chooser;

  /*--------------------------------------------------------
   * Constructor
   *------------------------------------------------------*/
  public OutFileTraversal(City[] aCities) {

    this.cities = aCities;

    /** build a file chooser
        and have the user choose a file,
        quitting this operation
        if the user cancelled the choice */
    chooser = new JFileChooser(".");

    /** set the file extension to be .txt */
    chooser.setFileFilter(new FileView.ExtensionFileFilter("txt"));

    /** see if file was selected - quit if user canceled */
    if (chooser.showSaveDialog(null) != JFileChooser.APPROVE_OPTION) {
      i = cities.length;
      closed = true;
      return;
    } else
      closed = false;

  }

  /*--------------------------------------------------------
   * Methods to implement the Traversal interface
   *------------------------------------------------------*/

  /** process next item, if available */
  public Traversal advance() {

    String temp = s;
    if (hasMore()) {
      s = new String(temp + cities[i].toStringData());
      i++;
    }
    return this;
  }

  /** return the most recent city processed - if available */
  public Object current() {
    if (hasMore())
      return cities[i];
    return null;
  }

  /** verify that new city is available to add tothe file*/
  public boolean hasMore() {

    /** more balloons available */
    if ((i < cities.length) && (!closed))
      return true;

    if (!closed) {
      /** no more items to add to the file */
      /** OK to overwrite existing file    */
      try {
        FileUtilities.writeFile(chooser.getSelectedFile(),s,true);
        closed = true;
      } catch (IOException e) {
        System.out.println(e.getMessage() + " Error saving:\n" + s);
        closed = true;
      }
    }
    return false;
  }

}
