/* ------------------------------------------------------------------
 * Functional (External) Iterator Pattern:
 *     iterator for console input of a list of cities
 */

import edu.neu.ccs.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.gui.*;

import java.io.*;
import java.awt.*;

class InConsoleTraversal implements Traversal, ConsoleAware {

  /*--------------------------------------------------------
   * Member data
   *------------------------------------------------------*/
  protected City c;

  protected boolean done = true;
  protected boolean submitted = false;

  /*--------------------------------------------------------
   * Constructor
   *------------------------------------------------------*/
  InConsoleTraversal() {
    done = false;
    read();
  }

  /*--------------------------------------------------------
   * Methods to implement the Traversal interface
   *------------------------------------------------------*/

  public Traversal advance() {
    read();
    return this;
  }

  public Object current() {
    return c;
  }

  public boolean hasMore() {
    return (!done);
  }

  /*--------------------------------------------------------------
   * Methods
   *------------------------------------------------------------*/

  /* read data for one city from the console */
  public City read() {

    try {
      c = new City (console.in.requestInt("Zip code: "),
                    console.in.requestString("City name: "),
                    console.in.requestString("State: "),
                    console.in.requestDouble("Longitude: "),
                    console.in.requestDouble("Latitude: "));
    } catch (CancelledException e) {
      console.out.println("End of input");
      this.done = true;
    }
    return c;
  }

}
