/*
 * @(#)TraversalOutFile 22 March 2006
 *
 * @author Viera K. Proulx
 */
/* ------------------------------------------------------------------
   Functional (External) Iterator Pattern:
        iterator for a list of cities 
*/

import java.io.IOException;

import javax.swing.JFileChooser;

import edu.neu.ccs.gui.FileView;
import edu.neu.ccs.util.FileUtilities;

/** An output iterator for City objects for file output. */
class TraversalOutFile implements Traversal<City>{
    
    /*-------------------------------------------------------- 
     Member data
     *------------------------------------------------------*/
    
    /* the list of cities to output */
    protected City[] cities;
    
    /* loop counter */
    int i = 0;
    
    /* true if the file is closed */
    boolean closed = false;
    
    /* a String object to hold file contents */
    protected String s = "";

    /* file chooser - to select the file from */
    protected JFileChooser chooser;
        
    /*-------------------------------------------------------- 
     Constructor
     *------------------------------------------------------*/    
    public TraversalOutFile(City[] aCities) {
        
        this.cities = aCities;
                     
        /** build a file chooser 
            and have the user choose a file, 
            quitting this operation 
            if the user cancelled the choice */
        chooser = new JFileChooser(".");
        
        /** set the file extension to be .txt */
        chooser.setFileFilter(new FileView.ExtensionFileFilter("txt"));
        
        /** see if file was selected - quit if user canceled */
        if (chooser.showSaveDialog(null) != JFileChooser.APPROVE_OPTION){
            i = cities.length;
            closed = true;
            return;
        }
        else
            closed = false;
        
    }
    /*--------------------------------------------------------
     Methods to implement the Traversal interface
     *------------------------------------------------------*/

    /** process next item, if available */
    public Traversal<City> advance() {

        String temp = s;
        if (hasMore()){
            s = new String(temp + cities[i].toStringData());
            i++;
        }
        return this;
    }

    /** return the most recent city processed - if available */
    public City current() {
           
        if (hasMore())
            return cities[i];
        return null;
    }
    
    /** verify that new city is available to add to the file*/
    public boolean hasMore() {
        
        /** more cities available */
        if ((i < cities.length) && (!closed))
            return true;

        if (!closed){
            /** no more items to add to the file */
            /** OK to overwrite existing file    */
            try {
                FileUtilities.writeFile(
                    chooser.getSelectedFile(),s,true);
                closed = true;
            }
            catch (IOException e){
                System.out.println(e.getMessage() + " Error saving:\n" + s);
                closed = true;
            }
        }
        return false; 
    }
    
    /*--------------------------------------------------------
    Self Test
    *------------------------------------------------------*/
    public static void main(String argv[]){
      City northville = 
        new City(48167, "Northville", "MI", 83.479355, 42.426245);
      City pinckney = 
        new City("48169", "Pinckney", "MI", 83.909918, 42.459579);
      City plymouth = 
        new City(48170, "Plymouth", "MI", 83.479946, 42.36882);
      City plymouth2 = new City();
      
      City[] cityarray= 
        new City[]{northville, pinckney, plymouth, plymouth2};
      
      System.out.println("Examples of CitiesList-s:");
      Traversal tr = new TraversalOutFile(cityarray);
      
      while (tr.hasMore()){
        System.out.println(tr.current().toString());
        tr = tr.advance(); 
      }
      System.out.println("End of the list.");
    }
}