/*
 * @(#)TraversalInConsole 22 March 2006
 *
 * @author Viera K. Proulx
 */
/* ------------------------------------------------------------------
 Functional (External) Iterator Pattern:
 iterator for console input of a list of cities 
 */

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.gui.CancelledException;

class TraversalInConsole implements Traversal<City>, ConsoleAware {
  
  /*-------------------------------------------------------- 
   Member data
   *------------------------------------------------------*/
  protected City c;
  
  protected boolean done = true;
  protected boolean submitted = false;
  
  /*-------------------------------------------------------- 
   Constructor
   *------------------------------------------------------*/
  TraversalInConsole() { 
    
    done = false;
    read();          
  }
  
  /*--------------------------------------------------------
   Methods to implement the Traversal interface
   *------------------------------------------------------*/
  
  public Traversal<City> advance(){
    read();
    return this;
  }
  
  
  public City current() {
    return c;
  }
  
  public boolean hasMore() {
    return (!done); 
  }
  
  /*--------------------------------------------------------------
   Methods
   *------------------------------------------------------------*/
  
  /* read data for one city from the console */
  public City read(){
    
    try{
      c = new City
      (console.in.requestInt("Zip code: "),
          console.in.requestString("City name: "),
          console.in.requestString("State: "),
          console.in.requestDouble("Longitude: "),
          console.in.requestDouble("Latitude: "));
    }
    catch(CancelledException e){
      console.out.println("End of input");
      this.done = true;
    }
    return c;
  }
  
  /*--------------------------------------------------------
  Self Test
  *------------------------------------------------------*/
  public static void main(String argv[]){
    
    System.out.println("Examples of CitiesList-s:");
    Traversal tr = new TraversalInConsole();
    
    while (tr.hasMore()){
      System.out.println(tr.current().toString());
      tr = tr.advance(); 
    }
    System.out.println("End of the list.");
  }
}

